/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispanremote.utils;

import org.hibernate.ogm.datastore.infinispanremote.utils.RemoteHotRodServerRule;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

@RunListener.ThreadSafe
public class HotrodServerLifecycle
extends RunListener {
    private volatile RemoteHotRodServerRule server;

    public void testRunStarted(Description description) throws Exception {
        this.printEvent("Test suite start detected");
        if (this.server == null) {
            this.startHotRodServer();
        }
    }

    public void testRunFinished(Result result) throws Exception {
        if (this.server != null) {
            this.printEvent("Test suite end detected");
            this.shutdownServer();
        }
    }

    public void testFinished(Description description) throws Exception {
        if (this.server != null) {
            // empty if block
        }
    }

    private synchronized void startHotRodServer() {
        if (this.server == null) {
            this.server = new RemoteHotRodServerRule();
            try {
                this.printEvent("Starting HotRod Server");
                this.server.before();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    private synchronized void shutdownServer() {
        RemoteHotRodServerRule serverLocal = this.server;
        if (serverLocal != null) {
            this.printEvent("Terminating HotRod Server");
            serverLocal.after();
        }
    }

    private void printEvent(String message) {
        System.out.println(((Object)((Object)this)).getClass().getCanonicalName() + ": " + message);
    }
}

