package org.hibernate.ogm.datastore.infinispanremote.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import org.hibernate.ogm.exception.EntityAlreadyExistsException;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.HibernateException;
import org.jboss.logging.DelegatingBasicLogger;
import java.io.IOException;
import java.lang.String;
import org.hibernate.LockMode;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.TransactionException;
import javax.transaction.SystemException;
import org.hibernate.service.spi.ServiceException;
import org.jboss.logging.BasicLogger;
import javax.persistence.PersistenceException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements org.hibernate.ogm.datastore.infinispanremote.logging.impl.Log, Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String hotrodClientConfigurationMissing = "OGM001701: The Hot Rod client configuration was not defined";
    protected String hotrodClientConfigurationMissing$str() {
        return hotrodClientConfigurationMissing;
    }
    @Override
    public final HibernateException hotrodClientConfigurationMissing() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), hotrodClientConfigurationMissing$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedLoadingHotRodConfigurationProperties = "OGM001702: Could not load the Hot Rod client configuration properties";
    protected String failedLoadingHotRodConfigurationProperties$str() {
        return failedLoadingHotRodConfigurationProperties;
    }
    @Override
    public final HibernateException failedLoadingHotRodConfigurationProperties(final IOException e) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), failedLoadingHotRodConfigurationProperties$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void successfulSchemaDeploy(final String protobufName) {
        super.log.logf(FQCN, INFO, null, successfulSchemaDeploy$str(), protobufName);
    }
    private static final String successfulSchemaDeploy = "OGM001703: Protobuf schema '%s' successfully deployed";
    protected String successfulSchemaDeploy$str() {
        return successfulSchemaDeploy;
    }
    private static final String errorAtSchemaDeploy1 = "OGM001704: Error deploying Protobuf schema '%s' to the server";
    protected String errorAtSchemaDeploy1$str() {
        return errorAtSchemaDeploy1;
    }
    @Override
    public final HibernateException errorAtSchemaDeploy(final String generatedProtobufName, final Exception schemaDeployError) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), errorAtSchemaDeploy1$str(), generatedProtobufName), schemaDeployError);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void generatedSchema(final String fullSchema) {
        super.log.logf(FQCN, INFO, null, generatedSchema$str(), fullSchema);
    }
    private static final String generatedSchema = "OGM001705: Generated schema: \n===========\n%s\n===========\n";
    protected String generatedSchema$str() {
        return generatedSchema;
    }
    private static final String truncatingShortOnRead = "OGM001706: Can not read value '%d' as a char for protobuf field '%s' as it's out of range for a Short type";
    protected String truncatingShortOnRead$str() {
        return truncatingShortOnRead;
    }
    @Override
    public final HibernateException truncatingShortOnRead(final int readInt, final String name) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), truncatingShortOnRead$str(), readInt, name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String valueRequestedForUnknownSequence = "OGM001707: Requested value for an unknown sequence on table '%s', segment '%s'";
    protected String valueRequestedForUnknownSequence$str() {
        return valueRequestedForUnknownSequence;
    }
    @Override
    public final HibernateException valueRequestedForUnknownSequence(final String table, final String columnValue) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), valueRequestedForUnknownSequence$str(), table, columnValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorAtProtobufParsing = "OGM001708: Error during parse of Protobuf schema";
    protected String errorAtProtobufParsing$str() {
        return errorAtProtobufParsing;
    }
    @Override
    public final HibernateException errorAtProtobufParsing(final Exception e) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), errorAtProtobufParsing$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedCachesNotDefined = "OGM001710: The remote caches '%s' were expected to exist but are not defined on the server";
    protected String expectedCachesNotDefined$str() {
        return expectedCachesNotDefined;
    }
    @Override
    public final HibernateException expectedCachesNotDefined(final java.util.Set<String> cacheNames) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), expectedCachesNotDefined$str(), new StringSetFormatter(cacheNames)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tableHasNoPrimaryKey = "OGM001711: This domain model would cause table '%s' to be generated without a primary key.This is not supported on an Infinispan Remote dialect: check that your embedded collections have a proper ordering definition.";
    protected String tableHasNoPrimaryKey$str() {
        return tableHasNoPrimaryKey;
    }
    @Override
    public final HibernateException tableHasNoPrimaryKey(final String tableName) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), tableHasNoPrimaryKey$str(), tableName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void excessiveCasForSequencer(final String segmentName) {
        super.log.logf(FQCN, WARN, null, excessiveCasForSequencer$str(), segmentName);
    }
    private static final String excessiveCasForSequencer = "OGM001712: Sequence generator '%s' has been retrying optimistic CAS operations 10 times. This is considered high contention and has a significant performance impact; consider using a different id type, like UUID or application assigned.";
    protected String excessiveCasForSequencer$str() {
        return excessiveCasForSequencer;
    }
    private static final String interruptedDuringCASSequenceGeneration = "OGM001713: This thread was interrupted while in a CAS loop to generate a unique sequence number";
    protected String interruptedDuringCASSequenceGeneration$str() {
        return interruptedDuringCASSequenceGeneration;
    }
    @Override
    public final HibernateException interruptedDuringCASSequenceGeneration() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), interruptedDuringCASSequenceGeneration$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String criticalDataLossDetected = "OGM001714: A remote read returned null while this entry was definitely initialized before. Possible data loss on the Infinispan server?";
    protected String criticalDataLossDetected$str() {
        return criticalDataLossDetected;
    }
    @Override
    public final HibernateException criticalDataLossDetected() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), criticalDataLossDetected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConfigurationValue = "OGM001715: Property <%s> has to be set to <%s> but it's set to <%s>";
    protected String invalidConfigurationValue$str() {
        return invalidConfigurationValue;
    }
    @Override
    public final HibernateException invalidConfigurationValue(final String property, final String expectedValue, final String actualValue) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), invalidConfigurationValue$str(), property, expectedValue, actualValue));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorAtSchemaDeploy2 = "OGM001716: Error deploying Protobuf schema '%s' to the server: '%s'";
    protected String errorAtSchemaDeploy2$str() {
        return errorAtSchemaDeploy2;
    }
    @Override
    public final HibernateException errorAtSchemaDeploy(final String generatedProtobufName, final String remoteErrorMessage) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), errorAtSchemaDeploy2$str(), generatedProtobufName, remoteErrorMessage));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidProtoFileName = "OGM001717: Invalid Proto file name <%s>. Proto file name should match the pattern: *.proto";
    protected String invalidProtoFileName$str() {
        return invalidProtoFileName;
    }
    @Override
    public final HibernateException invalidProtoFileName(final String protoFileName) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), invalidProtoFileName$str(), protoFileName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String expectedCacheConfiguratiosNotDefined = "OGM001718: The remote cache configurations '%s' were expected to exist but are not defined on the server";
    protected String expectedCacheConfiguratiosNotDefined$str() {
        return expectedCacheConfiguratiosNotDefined;
    }
    @Override
    public final HibernateException expectedCacheConfiguratiosNotDefined(final java.util.Set<String> cacheConfigurationNames) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), expectedCacheConfiguratiosNotDefined$str(), new StringSetFormatter(cacheConfigurationNames)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorAtCachesStart = "OGM001719: Error during caches start phase";
    protected String errorAtCachesStart$str() {
        return errorAtCachesStart;
    }
    @Override
    public final HibernateException errorAtCachesStart(final Exception cause) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), errorAtCachesStart$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingFromClauseInNativeQuery = "OGM001720: Missing from clause in native query: <%s>";
    protected String missingFromClauseInNativeQuery$str() {
        return missingFromClauseInNativeQuery;
    }
    @Override
    public final HibernateException missingFromClauseInNativeQuery(final String nativeQuery) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), missingFromClauseInNativeQuery$str(), nativeQuery));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleEntitiesInFromClause = "OGM001721: Infinispan queries can only target a single entity type. Found %s for query: %s";
    protected String multipleEntitiesInFromClause$str() {
        return multipleEntitiesInFromClause;
    }
    @Override
    public final HibernateException multipleEntitiesInFromClause(final String[] split, final String nativeQuery) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), multipleEntitiesInFromClause$str(), Arrays.toString(split), nativeQuery));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void version(final String arg0) {
        super.log.logf(FQCN, INFO, null, version$str(), arg0);
    }
    private static final String version = "OGM000001: Hibernate OGM %1$s";
    protected String version$str() {
        return version;
    }
    @Override
    public final void persistenceXmlNotFoundInClassPath(final String arg0) {
        super.log.logf(FQCN, WARN, null, persistenceXmlNotFoundInClassPath$str(), arg0);
    }
    private static final String persistenceXmlNotFoundInClassPath = "OGM000002: Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s";
    protected String persistenceXmlNotFoundInClassPath$str() {
        return persistenceXmlNotFoundInClassPath;
    }
    private static final String cannotInstantiateGridDialect = "OGM000011: Cannot instantiate GridDialect class [%1$s]";
    protected String cannotInstantiateGridDialect$str() {
        return cannotInstantiateGridDialect;
    }
    @Override
    public final HibernateException cannotInstantiateGridDialect(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotInstantiateGridDialect$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String gridDialectHasNoProperConstructor = "OGM000014: %1$s has no constructor accepting org.hibernate.ogm.datastore.spi.DatastoreProvider";
    protected String gridDialectHasNoProperConstructor$str() {
        return gridDialectHasNoProperConstructor;
    }
    @Override
    public final HibernateException gridDialectHasNoProperConstructor(final Class<?> arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), gridDialectHasNoProperConstructor$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedDatastoreProvider = "OGM000015: Expected DatastoreProvider %2$s but found %1$s";
    protected String unexpectedDatastoreProvider$str() {
        return unexpectedDatastoreProvider;
    }
    @Override
    public final HibernateException unexpectedDatastoreProvider(final Class<?> arg0, final Class<?> arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unexpectedDatastoreProvider$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void useDatastoreProvider(final Class<?> arg0) {
        super.log.logf(FQCN, INFO, null, useDatastoreProvider$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0));
    }
    private static final String useDatastoreProvider = "OGM000016: NoSQL Datastore provider: %1$s";
    protected String useDatastoreProvider$str() {
        return useDatastoreProvider;
    }
    @Override
    public final void useGridDialect(final Class<?> arg0) {
        super.log.logf(FQCN, INFO, null, useGridDialect$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0));
    }
    private static final String useGridDialect = "OGM000017: Grid Dialect: %1$s";
    protected String useGridDialect$str() {
        return useGridDialect;
    }
    private static final String jtaTransactionBeginFailed = "OGM000018: JTA transaction begin failed";
    protected String jtaTransactionBeginFailed$str() {
        return jtaTransactionBeginFailed;
    }
    @Override
    public final TransactionException jtaTransactionBeginFailed(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaTransactionBeginFailed$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jtaCommitFailed = "OGM000019: JTA transaction commit failed";
    protected String jtaCommitFailed$str() {
        return jtaCommitFailed;
    }
    @Override
    public final TransactionException jtaCommitFailed(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaCommitFailed$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jtaRollbackFailed = "OGM000020: JTA transaction rollback failed";
    protected String jtaRollbackFailed$str() {
        return jtaRollbackFailed;
    }
    @Override
    public final TransactionException jtaRollbackFailed(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaRollbackFailed$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToMarkTransactionForRollback = "OGM000021: Unable to mark JTA transaction for rollback";
    protected String unableToMarkTransactionForRollback$str() {
        return unableToMarkTransactionForRollback;
    }
    @Override
    public final TransactionException unableToMarkTransactionForRollback(final Exception arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), unableToMarkTransactionForRollback$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jtaCouldNotDetermineStatus = "OGM000022: Could not determine transaction status";
    protected String jtaCouldNotDetermineStatus$str() {
        return jtaCouldNotDetermineStatus;
    }
    @Override
    public final TransactionException jtaCouldNotDetermineStatus(final SystemException arg0) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), jtaCouldNotDetermineStatus$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToSetTimeout = "OGM000023: Unable to set transaction timeout to '%1$s'";
    protected String unableToSetTimeout$str() {
        return unableToSetTimeout;
    }
    @Override
    public final TransactionException unableToSetTimeout(final SystemException arg0, final int arg1) {
        final TransactionException result = new TransactionException(String.format(getLoggingLocale(), unableToSetTimeout$str(), arg1), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String querySyntaxException = "OGM000024: Syntax error in query: [%1$s]";
    protected String querySyntaxException$str() {
        return querySyntaxException;
    }
    @Override
    public final HibernateException querySyntaxException(final Exception arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), querySyntaxException$str(), arg1), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void interruptedBatchIndexing() {
        super.log.logf(FQCN, ERROR, null, interruptedBatchIndexing$str());
    }
    private static final String interruptedBatchIndexing = "OGM000025: Batch indexing was interrupted";
    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }
    private static final String illegalDiscrimantorType = "OGM000026: Illegal discriminator type: '%1$s'";
    protected String illegalDiscrimantorType$str() {
        return illegalDiscrimantorType;
    }
    @Override
    public final HibernateException illegalDiscrimantorType(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), illegalDiscrimantorType$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToConvertStringToDiscriminator = "OGM000027: Could not convert string to discriminator object";
    protected String unableToConvertStringToDiscriminator$str() {
        return unableToConvertStringToDiscriminator;
    }
    @Override
    public final HibernateException unableToConvertStringToDiscriminator(final Exception arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToConvertStringToDiscriminator$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void createdQuery(final String arg0, final Object arg1) {
        super.log.logf(FQCN, DEBUG, null, createdQuery$str(), arg0, arg1);
    }
    private static final String createdQuery = "OGM000028: Created query object '%2$s' from HQL/JP-QL query '%1$s'.";
    protected String createdQuery$str() {
        return createdQuery;
    }
    @Override
    public final void unsupportedIndexerConfigurationOption(final String arg0) {
        super.log.logf(FQCN, WARN, null, unsupportedIndexerConfigurationOption$str(), arg0);
    }
    private static final String unsupportedIndexerConfigurationOption = "OGM000031: OgmMassIndexer doesn't support the configuration option '%s'. Its setting will be ignored.";
    protected String unsupportedIndexerConfigurationOption$str() {
        return unsupportedIndexerConfigurationOption;
    }
    private static final String mappingSubtypeNotInterface = "OGM000032: Unable to support mapping subtypes that are not interfaces: %1$s";
    protected String mappingSubtypeNotInterface$str() {
        return mappingSubtypeNotInterface;
    }
    @Override
    public final HibernateException mappingSubtypeNotInterface(final Class<?> arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), mappingSubtypeNotInterface$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateNewProxyInstance = "OGM000033: Unable to create new proxy instance";
    protected String cannotCreateNewProxyInstance$str() {
        return cannotCreateNewProxyInstance;
    }
    @Override
    public final HibernateException cannotCreateNewProxyInstance(final Exception arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreateNewProxyInstance$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotConvertAnnotation = "OGM000034: Annotation cannot be converted using %1$s";
    protected String cannotConvertAnnotation$str() {
        return cannotConvertAnnotation;
    }
    @Override
    public final HibernateException cannotConvertAnnotation(final Class<? extends org.hibernate.ogm.options.spi.AnnotationConverter<?>> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotConvertAnnotation$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadContext = "OGM000036: Unable to load %1$s method from %2$s ";
    protected String unableToLoadContext$str() {
        return unableToLoadContext;
    }
    @Override
    public final HibernateException unableToLoadContext(final String arg0, final Class<?> arg1, final Exception arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToLoadContext$str(), arg0, new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1)), arg2);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateGlobalContextProxy = "OGM000037: Unable to create global context proxy for type %1$s";
    protected String cannotCreateGlobalContextProxy$str() {
        return cannotCreateGlobalContextProxy;
    }
    @Override
    public final HibernateException cannotCreateGlobalContextProxy(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreateGlobalContextProxy$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreateEntityContextProxy = "OGM000038: Unable to create entity context proxy for type %1$s";
    protected String cannotCreateEntityContextProxy$str() {
        return cannotCreateEntityContextProxy;
    }
    @Override
    public final HibernateException cannotCreateEntityContextProxy(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreateEntityContextProxy$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotCreatePropertyContextProxy = "OGM000039: Unable to create property context proxy for type %1$s";
    protected String cannotCreatePropertyContextProxy$str() {
        return cannotCreatePropertyContextProxy;
    }
    @Override
    public final HibernateException cannotCreatePropertyContextProxy(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotCreatePropertyContextProxy$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getPropertyDoesNotExistException = "OGM000041: The given propery %1$s#%2$s with element type %3$s does not exist.";
    protected String getPropertyDoesNotExistException$str() {
        return getPropertyDoesNotExistException;
    }
    @Override
    public final HibernateException getPropertyDoesNotExistException(final String arg0, final String arg1, final ElementType arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getPropertyDoesNotExistException$str(), arg0, arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getUnsupportedElementTypeException = "OGM000042: The given element type %1$s is neither FIELD nor METHOD.";
    protected String getUnsupportedElementTypeException$str() {
        return getUnsupportedElementTypeException;
    }
    @Override
    public final HibernateException getUnsupportedElementTypeException(final ElementType arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getUnsupportedElementTypeException$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiateType = "OGM000043: Cannot instantiate type %1$s. Does it define a default constructor?";
    protected String unableToInstantiateType$str() {
        return unableToInstantiateType;
    }
    @Override
    public final HibernateException unableToInstantiateType(final Class<?> arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToInstantiateType$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadClass = "OGM000044: Cannot load class %2$s specified via configuration property '%1$s'";
    protected String unableToLoadClass$str() {
        return unableToLoadClass;
    }
    @Override
    public final HibernateException unableToLoadClass(final String arg0, final String arg1, final Exception arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToLoadClass$str(), arg0, arg1), arg2);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedClassType = "OGM000045: Type %2$s specified via configuration property '%1$s' is not a sub-type of expected type %3$s";
    protected String unexpectedClassType$str() {
        return unexpectedClassType;
    }
    @Override
    public final HibernateException unexpectedClassType(final String arg0, final Class<?> arg1, final Class<?> arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unexpectedClassType$str(), arg0, new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg2)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedInstanceType = "OGM000046: Object %2$s of type %3$s specified via configuration property '%1$s' is not of the expected type %4$s";
    protected String unexpectedInstanceType$str() {
        return unexpectedInstanceType;
    }
    @Override
    public final HibernateException unexpectedInstanceType(final String arg0, final String arg1, final Class<?> arg2, final Class<?> arg3) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unexpectedInstanceType$str(), arg0, arg1, new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg2), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg3)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String ambigiousOptionConfiguration = "OGM000047: Either an option configurator may be specified via configuration property '%1$s' or OgmConfiguration#configureOptions() may be called, but not both at the same time.";
    protected String ambigiousOptionConfiguration$str() {
        return ambigiousOptionConfiguration;
    }
    @Override
    public final HibernateException ambigiousOptionConfiguration(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), ambigiousOptionConfiguration$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownAssociationStorageStrategy = "OGM000048: Unknown association storage strategy: [%s]. Supported values are: %s";
    protected String unknownAssociationStorageStrategy$str() {
        return unknownAssociationStorageStrategy;
    }
    @Override
    public final HibernateException unknownAssociationStorageStrategy(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unknownAssociationStorageStrategy$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String illegalPortValue = "OGM000049: The value set for the configuration property 'hibernate.ogm.datastore.port' must be a number between 1 and 65535. Found '%s'.";
    protected String illegalPortValue$str() {
        return illegalPortValue;
    }
    @Override
    public final HibernateException illegalPortValue(final int arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), illegalPortValue$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAnInteger = "OGM000050: The value set for the configuration property '%1$s' must be an integer number. Found '%2$s'.";
    protected String notAnInteger$str() {
        return notAnInteger;
    }
    @Override
    public final HibernateException notAnInteger(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), notAnInteger$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownEnumerationValue = "OGM000051: Unknown value given for configuration property '%1$s'; Found '%2$s', but supported values are: %3$s";
    protected String unknownEnumerationValue$str() {
        return unknownEnumerationValue;
    }
    @Override
    public final HibernateException unknownEnumerationValue(final String arg0, final String arg1, final String arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unknownEnumerationValue$str(), arg0, arg1, arg2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingConfigurationProperty = "OGM000052: Missing value for property '%s'";
    protected String missingConfigurationProperty$str() {
        return missingConfigurationProperty;
    }
    @Override
    public final HibernateException missingConfigurationProperty(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), missingConfigurationProperty$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedPropertyType = "OGM000053: Value of unsupported type given for configuration property '%1$s': '%2$s'";
    protected String unsupportedPropertyType$str() {
        return unsupportedPropertyType;
    }
    @Override
    public final HibernateException unsupportedPropertyType(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unsupportedPropertyType$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String closedOperationQueue = "OGM000054: It is not possible to add or poll operations from a closed queue";
    protected String closedOperationQueue$str() {
        return closedOperationQueue;
    }
    @Override
    public final HibernateException closedOperationQueue() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), closedOperationQueue$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConfigurationUrl = "OGM000055: Invalid URL given for configuration property '%1$s': %2$s; The specified resource could not be found.";
    protected String invalidConfigurationUrl$str() {
        return invalidConfigurationUrl;
    }
    @Override
    public final HibernateException invalidConfigurationUrl(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), invalidConfigurationUrl$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotRetrieveEntityForRetrievalOfGeneratedProperties = "OGM000056: Unable to load record for retrieval of generated properties; Entity type: %1$s, id: %2$s";
    protected String couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str() {
        return couldNotRetrieveEntityForRetrievalOfGeneratedProperties;
    }
    @Override
    public final HibernateException couldNotRetrieveEntityForRetrievalOfGeneratedProperties(final String arg0, final Serializable arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), couldNotRetrieveEntityForRetrievalOfGeneratedProperties$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mustNotBeNull = "OGM000057: '%s' must not be null";
    protected String mustNotBeNull$str() {
        return mustNotBeNull;
    }
    @Override
    public final IllegalArgumentException mustNotBeNull(final String arg0) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), mustNotBeNull$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String parameterMustNotBeNull = "OGM000058: Parameter '%s' must not be null";
    protected String parameterMustNotBeNull$str() {
        return parameterMustNotBeNull;
    }
    @Override
    public final IllegalArgumentException parameterMustNotBeNull(final String arg0) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterMustNotBeNull$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToFindGridType = "OGM000059: Unable to find a GridType for %s";
    protected String unableToFindGridType$str() {
        return unableToFindGridType;
    }
    @Override
    public final HibernateException unableToFindGridType(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToFindGridType$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void dialectDoesNotSupportSequences(final Class<?> arg0, final String arg1) {
        super.log.logf(FQCN, WARN, null, dialectDoesNotSupportSequences$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), arg1);
    }
    private static final String dialectDoesNotSupportSequences = "OGM000060: Sequence id generator used for entity '%2$s' is not supported by grid dialect %1$s, falling back to table-based id generation. Consider to use @TableGenerator rather than @SequenceGenerator.";
    protected String dialectDoesNotSupportSequences$str() {
        return dialectDoesNotSupportSequences;
    }
    @Override
    public final void catalogOptionNotSupportedForTableGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, catalogOptionNotSupportedForTableGenerator$str(), arg0);
    }
    private static final String catalogOptionNotSupportedForTableGenerator = "OGM000061: The option '@TableGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String catalogOptionNotSupportedForTableGenerator$str() {
        return catalogOptionNotSupportedForTableGenerator;
    }
    @Override
    public final void schemaOptionNotSupportedForTableGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, schemaOptionNotSupportedForTableGenerator$str(), arg0);
    }
    private static final String schemaOptionNotSupportedForTableGenerator = "OGM000062: The option '@TableGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String schemaOptionNotSupportedForTableGenerator$str() {
        return schemaOptionNotSupportedForTableGenerator;
    }
    @Override
    public final void catalogOptionNotSupportedForSequenceGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, catalogOptionNotSupportedForSequenceGenerator$str(), arg0);
    }
    private static final String catalogOptionNotSupportedForSequenceGenerator = "OGM000063: The option '@SequenceGenerator#catalog()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String catalogOptionNotSupportedForSequenceGenerator$str() {
        return catalogOptionNotSupportedForSequenceGenerator;
    }
    @Override
    public final void schemaOptionNotSupportedForSequenceGenerator(final String arg0) {
        super.log.logf(FQCN, WARN, null, schemaOptionNotSupportedForSequenceGenerator$str(), arg0);
    }
    private static final String schemaOptionNotSupportedForSequenceGenerator = "OGM000064: The option '@SequenceGenerator#schema()' is not supported by Hibernate OGM. Its value %s is going to be ignored.";
    protected String schemaOptionNotSupportedForSequenceGenerator$str() {
        return schemaOptionNotSupportedForSequenceGenerator;
    }
    private static final String getIdentityGenerationStrategyNotSupportedException = "OGM000065: Id generation strategy IDENTITY configured for entity %1$s is not supported by the current grid dialect.";
    protected String getIdentityGenerationStrategyNotSupportedException$str() {
        return getIdentityGenerationStrategyNotSupportedException;
    }
    @Override
    public final HibernateException getIdentityGenerationStrategyNotSupportedException(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getIdentityGenerationStrategyNotSupportedException$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void usingNonAtomicOptimisticLocking(final String arg0) {
        super.log.logf(FQCN, WARN, null, usingNonAtomicOptimisticLocking$str(), arg0);
    }
    private static final String usingNonAtomicOptimisticLocking = "OGM000066: Entity type %s uses an optimistic locking strategy which is not supported by the current grid dialect in an atomic manner. There will be two datastore round-trips for version checking and updating the data.";
    protected String usingNonAtomicOptimisticLocking$str() {
        return usingNonAtomicOptimisticLocking;
    }
    private static final String mustNotInsertSameEntityTwice = "OGM000067: Trying to insert an already existing entity: %s";
    protected String mustNotInsertSameEntityTwice$str() {
        return mustNotInsertSameEntityTwice;
    }
    @Override
    public final EntityAlreadyExistsException mustNotInsertSameEntityTwice(final String arg0, final Exception arg1) {
        final EntityAlreadyExistsException result = new EntityAlreadyExistsException(String.format(getLoggingLocale(), mustNotInsertSameEntityTwice$str(), arg0), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotConfigureProperty = "OGM000068: Could not configure property %1$s#%2$s";
    protected String couldNotConfigureProperty$str() {
        return couldNotConfigureProperty;
    }
    @Override
    public final HibernateException couldNotConfigureProperty(final String arg0, final String arg1, final Exception arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), couldNotConfigureProperty$str(), arg0, arg1), arg2);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedLockMode = "OGM000069: Grid dialect %1$s does not support lock mode %2$s";
    protected String unsupportedLockMode$str() {
        return unsupportedLockMode;
    }
    @Override
    public final HibernateException unsupportedLockMode(final Class<? extends org.hibernate.ogm.dialect.spi.GridDialect> arg0, final LockMode arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unsupportedLockMode$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noValidDatastoreProviderShortName(final String arg0, final String arg1) {
        super.log.logf(FQCN, WARN, null, noValidDatastoreProviderShortName$str(), arg0, arg1);
    }
    private static final String noValidDatastoreProviderShortName = "OGM000070: '%1$s' is no valid datastore provider short name. Valid values are: %2$s";
    protected String noValidDatastoreProviderShortName$str() {
        return noValidDatastoreProviderShortName;
    }
    private static final String unableToStartDatastoreProvider = "OGM000071: Unable to start datastore provider";
    protected String unableToStartDatastoreProvider$str() {
        return unableToStartDatastoreProvider;
    }
    @Override
    public final ServiceException unableToStartDatastoreProvider(final Exception arg0) {
        final ServiceException result = new ServiceException(String.format(getLoggingLocale(), unableToStartDatastoreProvider$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToConfigureDatastoreProvider = "OGM000072: Unable to configure datastore provider";
    protected String unableToConfigureDatastoreProvider$str() {
        return unableToConfigureDatastoreProvider;
    }
    @Override
    public final ServiceException unableToConfigureDatastoreProvider(final Exception arg0) {
        final ServiceException result = new ServiceException(String.format(getLoggingLocale(), unableToConfigureDatastoreProvider$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotLoadLuceneParserBackend = "OGM000073: Couldn't load the Lucene-based query parser backend. Make sure the dependency org.hibernate.hql:hibernate-hql-lucene is part of the classpath.";
    protected String cannotLoadLuceneParserBackend$str() {
        return cannotLoadLuceneParserBackend;
    }
    @Override
    public final HibernateException cannotLoadLuceneParserBackend(final Exception arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotLoadLuceneParserBackend$str()), arg0);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unableToCloseSessionButSwallowingError(final Exception arg0) {
        super.log.logf(FQCN, INFO, arg0, unableToCloseSessionButSwallowingError$str());
    }
    private static final String unableToCloseSessionButSwallowingError = "OGM000074: Could not close session; swallowing exception as transaction completed";
    protected String unableToCloseSessionButSwallowingError$str() {
        return unableToCloseSessionButSwallowingError;
    }
    @Override
    public final void jbossTransactionManagerDetected() {
        super.log.logf(FQCN, INFO, null, jbossTransactionManagerDetected$str());
    }
    private static final String jbossTransactionManagerDetected = "OGM000075: JBoss Transaction Manager (com.arjuna.ats.jta.TransactionManager) detected on classpath. Using JBossStandAloneJtaPlatform as JTAPlatform implementation";
    protected String jbossTransactionManagerDetected$str() {
        return jbossTransactionManagerDetected;
    }
    @Override
    public final void noJtaPlatformDetected() {
        super.log.logf(FQCN, INFO, null, noJtaPlatformDetected$str());
    }
    private static final String noJtaPlatformDetected = "OGM000076: No explicit or implicit defined JTAPlatform. Using NoJtaPlatform";
    protected String noJtaPlatformDetected$str() {
        return noJtaPlatformDetected;
    }
    private static final String parameterSringMustNotBeEmpty = "OGM000077: Parameter '%s' must not be an empty string";
    protected String parameterSringMustNotBeEmpty$str() {
        return parameterSringMustNotBeEmpty;
    }
    @Override
    public final IllegalArgumentException parameterSringMustNotBeEmpty(final String arg0) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), parameterSringMustNotBeEmpty$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String getUnknownAliasException = "OGM000078: Unrecognized alias in query:  %s";
    protected String getUnknownAliasException$str() {
        return getUnknownAliasException;
    }
    @Override
    public final HibernateException getUnknownAliasException(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), getUnknownAliasException$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToParseHost = "OGM000079: Unable to parse hibernate.ogm.datastore.host %s\nProperty should be a comma separated list of host:port\ne.g. www.example.com, www2.example.com:123, 192.0.2.1, 192.0.2.2:123, 2001:db8::ff00:42:8329, [2001:db8::ff00:42:8329]:123";
    protected String unableToParseHost$str() {
        return unableToParseHost;
    }
    @Override
    public final HibernateException unableToParseHost(final String arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), unableToParseHost$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String errorOnEntityBatchLoad = "OGM000080: Could not load an entity batch: %s";
    protected String errorOnEntityBatchLoad$str() {
        return errorOnEntityBatchLoad;
    }
    @Override
    public final HibernateException errorOnEntityBatchLoad(final String arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), errorOnEntityBatchLoad$str(), arg0), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notALong = "OGM000081: The value set for the configuration property '%1$s' must be a long number. Found '%2$s'.";
    protected String notALong$str() {
        return notALong;
    }
    @Override
    public final HibernateException notALong(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), notALong$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String entityTupleNotFound = "OGM000082: The entity at the inverse side of the association '%1$s' cannot be found in the session: %2$s";
    protected String entityTupleNotFound$str() {
        return entityTupleNotFound;
    }
    @Override
    public final HibernateException entityTupleNotFound(final String arg0, final EntityKey arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), entityTupleNotFound$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failureWhenUsingAttributeConverter = "OGM000083: Failure when using JPA AttributeConverter [%1$s]. Is the datastore type of the converter a supported type for your datastore?";
    protected String failureWhenUsingAttributeConverter$str() {
        return failureWhenUsingAttributeConverter;
    }
    @Override
    public final PersistenceException failureWhenUsingAttributeConverter(final Class<?> arg0, final Exception arg1) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), failureWhenUsingAttributeConverter$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindTypeForAttributeConverter = "OGM000084: Unable to find basic type support for [%2$s] when using JPA AttributeConverter [%1$s].Is the datastore type of the converter a supported type for your datastore?";
    protected String cannotFindTypeForAttributeConverter$str() {
        return cannotFindTypeForAttributeConverter;
    }
    @Override
    public final PersistenceException cannotFindTypeForAttributeConverter(final Class<?> arg0, final Class<?> arg1) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotFindTypeForAttributeConverter$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg1)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotFindEntityEntryForEntity = "OGM000085: Unable to find an entity entry for the entity '%1$s'";
    protected String cannotFindEntityEntryForEntity$str() {
        return cannotFindEntityEntryForEntity;
    }
    @Override
    public final PersistenceException cannotFindEntityEntryForEntity(final Object arg0) {
        final PersistenceException result = new PersistenceException(String.format(getLoggingLocale(), cannotFindEntityEntryForEntity$str(), arg0));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String transactionIdIsNotAvailable = "OGM000086: Transaction identifier not available";
    protected String transactionIdIsNotAvailable$str() {
        return transactionIdIsNotAvailable;
    }
    @Override
    public final HibernateException transactionIdIsNotAvailable() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), transactionIdIsNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tupleContextNotAvailable = "OGM000087: The tuple context is not available, probably because we are dealing with more than a single entity type";
    protected String tupleContextNotAvailable$str() {
        return tupleContextNotAvailable;
    }
    @Override
    public final HibernateException tupleContextNotAvailable() {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), tupleContextNotAvailable$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void usingDeprecatedDatastoreProviderName(final String arg0, final String arg1) {
        super.log.logf(FQCN, WARN, null, usingDeprecatedDatastoreProviderName$str(), arg0, arg1);
    }
    private static final String usingDeprecatedDatastoreProviderName = "OGM000088: Configuration is referring to deprecated datastore provider name '%1$s'. Please use the new form '%2$s' instead.";
    protected String usingDeprecatedDatastoreProviderName$str() {
        return usingDeprecatedDatastoreProviderName;
    }
    private static final String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass = "OGM000089: %1$s does not support queries on polymorphic entities using TABLE_PER_CLASS inheritance strategy. You should try using SINGLE_TABLE instead. Entities: %2$s";
    protected String queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str() {
        return queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass;
    }
    @Override
    public final HibernateException queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass(final String arg0, final java.util.Collection<String> arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), queriesOnPolymorphicEntitiesAreNotSupportedWithTablePerClass$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleEntitiesOutputNotSupported = "OGM000090: Returning multiple entities is not supported. Procedure '%1$s' expects results of type %2$s";
    protected String multipleEntitiesOutputNotSupported$str() {
        return multipleEntitiesOutputNotSupported;
    }
    @Override
    public final HibernateException multipleEntitiesOutputNotSupported(final String arg0, final java.util.Collection<?> arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), multipleEntitiesOutputNotSupported$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String addEntityNotAllowedInNativeQueriesUsingProjection = "OGM000091: Projection and addEntity are not allowed in the same query on <%1$s> %2$s";
    protected String addEntityNotAllowedInNativeQueriesUsingProjection$str() {
        return addEntityNotAllowedInNativeQueriesUsingProjection;
    }
    @Override
    public final HibernateException addEntityNotAllowedInNativeQueriesUsingProjection(final String arg0, final String arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), addEntityNotAllowedInNativeQueriesUsingProjection$str(), arg0, arg1));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExecuteStoredProcedure = "OGM000092: Cannot execute stored procedure '%s'.";
    protected String cannotExecuteStoredProcedure$str() {
        return cannotExecuteStoredProcedure;
    }
    @Override
    public final HibernateException cannotExecuteStoredProcedure(final String arg0, final Throwable arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotExecuteStoredProcedure$str(), arg0), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String procedureWithResolvedNameDoesNotExist = "OGM000093: Procedure with resolved name '%s' does not exist.";
    protected String procedureWithResolvedNameDoesNotExist$str() {
        return procedureWithResolvedNameDoesNotExist;
    }
    @Override
    public final HibernateException procedureWithResolvedNameDoesNotExist(final String arg0, final Exception arg1) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), procedureWithResolvedNameDoesNotExist$str(), arg0), arg1);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String dialectDoesNotSupportPositionalParametersForStoredProcedures = "OGM000094: Dialect %s does not support positional parameters when calling stored procedures";
    protected String dialectDoesNotSupportPositionalParametersForStoredProcedures$str() {
        return dialectDoesNotSupportPositionalParametersForStoredProcedures;
    }
    @Override
    public final HibernateException dialectDoesNotSupportPositionalParametersForStoredProcedures(final Class<?> arg0) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), dialectDoesNotSupportPositionalParametersForStoredProcedures$str(), new org.hibernate.ogm.util.impl.ClassObjectFormatter(arg0)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSetStoredProcedureParameter = "OGM000095: Cannot set stored procedure '%s' parameter '%s' with value '%s'.";
    protected String cannotSetStoredProcedureParameter$str() {
        return cannotSetStoredProcedureParameter;
    }
    @Override
    public final HibernateException cannotSetStoredProcedureParameter(final String arg0, final String arg1, final Object arg2, final Exception arg3) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotSetStoredProcedureParameter$str(), arg0, arg1, arg2), arg3);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotExtractStoredProcedureResultSet = "OGM000096: Cannot extract stored procedure '%s' result set '%s'.";
    protected String cannotExtractStoredProcedureResultSet$str() {
        return cannotExtractStoredProcedureResultSet;
    }
    @Override
    public final HibernateException cannotExtractStoredProcedureResultSet(final String arg0, final Object arg1, final Exception arg2) {
        final HibernateException result = new HibernateException(String.format(getLoggingLocale(), cannotExtractStoredProcedureResultSet$str(), arg0, arg1), arg2);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
