/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.infinispan.persistencestrategy.counter;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.ExecutionException;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.infinispan.logging.impl.Log;
import org.hibernate.ogm.datastore.infinispan.logging.impl.LoggerFactory;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.infinispan.counter.EmbeddedCounterManagerFactory;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.manager.EmbeddedCacheManager;

public abstract class ClusteredCounterHandler {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    protected final EmbeddedCacheManager cacheManager;

    public ClusteredCounterHandler(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected StrongCounter getCounterOrCreateIt(String counterName, int initialValue) {
        CounterManager counterManager = EmbeddedCounterManagerFactory.asCounterManager((EmbeddedCacheManager)this.cacheManager);
        if (!counterManager.isDefined(counterName)) {
            LOG.tracef("Counter %s is not defined, creating it", counterName);
            this.validateGlobalConfiguration();
            counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue((long)initialValue).storage(Storage.PERSISTENT).build());
        }
        StrongCounter strongCounter = counterManager.getStrongCounter(counterName);
        return strongCounter;
    }

    private void validateGlobalConfiguration() {
        boolean globalConfigIsEnabled = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration().globalState().enabled();
        if (!globalConfigIsEnabled) {
            throw LOG.counterCannotBeCreatedWithoutGlobalConfiguration();
        }
    }

    protected Number nextValue(NextValueRequest request, StrongCounter strongCounter) {
        try {
            Long newValue = (Long)strongCounter.addAndGet((long)request.getIncrement()).get();
            return newValue - (long)request.getIncrement();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new HibernateException("Interrupting Operation " + e.getMessage(), (Throwable)e);
        }
    }

    public abstract Number nextValue(NextValueRequest var1);
}

