/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.common.impl.VersionChecker;
import org.hibernate.ogm.model.key.spi.IdSourceKey;

public class SerializableIdSourceKey
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    private String table;
    private String columnName;
    private Object columnValue;

    public SerializableIdSourceKey() {
    }

    SerializableIdSourceKey(IdSourceKey key) {
        this.columnName = key.getColumnName();
        this.columnValue = key.getColumnValue();
        this.table = key.getTable();
    }

    public String getTable() {
        return this.table;
    }

    public String getColumnNames() {
        return this.columnName;
    }

    public Object getColumnValues() {
        return this.columnValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.columnValue == null ? 0 : this.columnValue.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableIdSourceKey other = (SerializableIdSourceKey)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.columnValue == null ? other.columnValue != null : !this.columnValue.equals(other.columnValue)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public String toString() {
        return "SerializableIdSourceKey [columnName='" + this.columnName + "', columnValues='" + this.columnValue + "']";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.table);
        out.writeObject(new String[]{this.columnName});
        out.writeObject(new Object[]{this.columnValue});
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        VersionChecker.readAndCheckVersion(in, 1, SerializableIdSourceKey.class);
        this.table = in.readUTF();
        this.columnName = ((String[])in.readObject())[0];
        this.columnValue = ((Object[])in.readObject())[0];
    }
}

