/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.sf.ehcache.CacheManager;
import org.hibernate.ogm.datastore.ehcache.impl.Cache;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableAssociationKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableEntityKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableIdSourceKey;
import org.hibernate.ogm.dialect.query.spi.ClosableIterator;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.TransactionContext;
import org.hibernate.ogm.dialect.spi.TuplesSupplier;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;

public class OnePerKindCacheManager
extends LocalCacheManager<SerializableEntityKey, SerializableAssociationKey, SerializableIdSourceKey> {
    private final Cache<SerializableEntityKey> entityCache;
    private final Cache<SerializableAssociationKey> associationCache;
    private final Cache<SerializableIdSourceKey> idSourceCache;

    public OnePerKindCacheManager(CacheManager cacheManager) {
        super(cacheManager);
        this.entityCache = new Cache(cacheManager.getCache("ENTITIES"));
        this.associationCache = new Cache(cacheManager.getCache("ASSOCIATIONS"));
        this.idSourceCache = new Cache(cacheManager.getCache("IDENTIFIERS"));
    }

    @Override
    public Cache<SerializableEntityKey> getEntityCache(EntityKeyMetadata keyMetadata) {
        return this.entityCache;
    }

    @Override
    public Cache<SerializableAssociationKey> getAssociationCache(AssociationKeyMetadata keyMetadata) {
        return this.associationCache;
    }

    @Override
    public Cache<SerializableIdSourceKey> getIdSourceCache(IdSourceKeyMetadata keyMetadata) {
        return this.idSourceCache;
    }

    @Override
    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        consumer.consume((TuplesSupplier)new OnePerKindTuplesSupplier(this.entityCache, entityKeyMetadatas));
    }

    private static class OnePerKindTupleIterator
    implements ClosableIterator<Tuple> {
        private final Cache<SerializableEntityKey> entityCache;
        private final EntityKeyMetadata[] entityKeyMetadatas;
        private final Iterator<SerializableEntityKey> iterator;
        private SerializableEntityKey next;
        private boolean hasNext = false;

        public OnePerKindTupleIterator(Iterator<SerializableEntityKey> iterator, Cache<SerializableEntityKey> entityCache, EntityKeyMetadata[] entityKeyMetadatas2Iterator, EntityKeyMetadata ... entityKeyMetadatas) {
            this.iterator = iterator;
            this.entityCache = entityCache;
            this.entityKeyMetadatas = entityKeyMetadatas;
            this.next = this.next(iterator);
        }

        private SerializableEntityKey next(Iterator<SerializableEntityKey> iterator) {
            SerializableEntityKey next = null;
            this.hasNext = false;
            while (iterator.hasNext()) {
                next = iterator.next();
                if (!this.isValidKey(next)) continue;
                this.hasNext = true;
                break;
            }
            if (this.hasNext) {
                return next;
            }
            return null;
        }

        private boolean isValidKey(SerializableEntityKey key) {
            for (EntityKeyMetadata entityKeyMetadata : this.entityKeyMetadatas) {
                if (!entityKeyMetadata.getTable().equals(key.getTable())) continue;
                return true;
            }
            return false;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public Tuple next() {
            if (this.hasNext) {
                Tuple current = OnePerKindCacheManager.createTuple(this.entityCache.get(this.next));
                this.next = this.next(this.iterator);
                return current;
            }
            throw new NoSuchElementException();
        }

        public void close() {
        }
    }

    private static class OnePerKindTuplesSupplier
    implements TuplesSupplier {
        private final EntityKeyMetadata[] entityKeyMetadatas;
        private final Cache<SerializableEntityKey> entityCache;
        private final Iterator<SerializableEntityKey> keys;

        public OnePerKindTuplesSupplier(Cache<SerializableEntityKey> entityCache, EntityKeyMetadata ... entityKeyMetadatas) {
            this.entityCache = entityCache;
            this.entityKeyMetadatas = entityKeyMetadatas;
            this.keys = entityCache.getKeys().iterator();
        }

        public ClosableIterator<Tuple> get(TransactionContext transactionContext) {
            return new OnePerKindTupleIterator(this.keys, this.entityCache, this.entityKeyMetadatas, new EntityKeyMetadata[0]);
        }
    }
}

