/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache;

import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Element;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableMapAssociationSnapshot;
import org.hibernate.ogm.datastore.ehcache.impl.Cache;
import org.hibernate.ogm.datastore.ehcache.impl.EhcacheDatastoreProvider;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.common.impl.SerializableRowKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.KeyProvider;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.DuplicateInsertPreventionStrategy;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.TupleAlreadyExistsException;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.persister.entity.Lockable;

public class EhcacheDialect<EK, AK, ISK>
extends BaseGridDialect {
    EhcacheDatastoreProvider datastoreProvider;

    public EhcacheDialect(EhcacheDatastoreProvider datastoreProvider) {
        this.datastoreProvider = datastoreProvider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        return null;
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Cache<EK> entityCache = this.getCacheManager().getEntityCache(key.getMetadata());
        Element element = entityCache.get(this.getKeyProvider().getEntityCacheKey(key));
        if (element != null) {
            return this.createTuple(element);
        }
        return null;
    }

    private Tuple createTuple(Element element) {
        return new Tuple((TupleSnapshot)new MapTupleSnapshot((Map)element.getObjectValue()));
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        return new Tuple((TupleSnapshot)new MapTupleSnapshot(new HashMap()));
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        Cache<EK> entityCache = this.getCacheManager().getEntityCache(key.getMetadata());
        Map entityRecord = ((MapTupleSnapshot)tuple.getSnapshot()).getMap();
        if (entityRecord.isEmpty()) {
            MapHelpers.applyTupleOpsOnMap((Tuple)tuple, (Map)entityRecord);
            Element previous = entityCache.putIfAbsent(new Element(this.getKeyProvider().getEntityCacheKey(key), (Object)entityRecord));
            if (previous != null) {
                throw new TupleAlreadyExistsException(key.getMetadata(), tuple, null);
            }
        } else {
            MapHelpers.applyTupleOpsOnMap((Tuple)tuple, (Map)entityRecord);
            entityCache.put(new Element(this.getKeyProvider().getEntityCacheKey(key), (Object)entityRecord));
        }
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.getCacheManager().getEntityCache(key.getMetadata()).remove(this.getKeyProvider().getEntityCacheKey(key));
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<AK> associationCache = this.getCacheManager().getAssociationCache(key.getMetadata());
        Element element = associationCache.get(this.getKeyProvider().getAssociationCacheKey(key));
        if (element == null) {
            return null;
        }
        Map associationRows = (Map)element.getObjectValue();
        return new Association((AssociationSnapshot)new SerializableMapAssociationSnapshot(associationRows));
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<AK> associationCache = this.getCacheManager().getAssociationCache(key.getMetadata());
        HashMap<SerializableRowKey, Map<String, Object>> association = new HashMap<SerializableRowKey, Map<String, Object>>();
        associationCache.put(new Element(this.getKeyProvider().getAssociationCacheKey(key), association));
        return new Association((AssociationSnapshot)new SerializableMapAssociationSnapshot(association));
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        Map<SerializableRowKey, Map<String, Object>> associationRows = ((SerializableMapAssociationSnapshot)association.getSnapshot()).getUnderlyingMap();
        for (AssociationOperation action : association.getOperations()) {
            switch (action.getType()) {
                case CLEAR: {
                    associationRows.clear();
                    break;
                }
                case PUT: {
                    associationRows.put(new SerializableRowKey(action.getKey()), MapHelpers.associationRowToMap((Tuple)action.getValue()));
                    break;
                }
                case REMOVE: {
                    associationRows.remove(new SerializableRowKey(action.getKey()));
                }
            }
        }
        Cache<AK> associationCache = this.getCacheManager().getAssociationCache(key.getMetadata());
        associationCache.put(new Element(this.getKeyProvider().getAssociationCacheKey(key), associationRows));
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        this.getCacheManager().getAssociationCache(key.getMetadata()).remove(this.getKeyProvider().getAssociationCacheKey(key));
    }

    public Number nextValue(NextValueRequest request) {
        ISK key;
        Cache<ISK> cache = this.getCacheManager().getIdSourceCache(request.getKey().getMetadata());
        Element previousValue = cache.get(key = this.getKeyProvider().getIdSourceCacheKey(request.getKey()));
        if (previousValue == null) {
            previousValue = cache.putIfAbsent(new Element(key, (Object)request.getInitialValue()));
        }
        if (previousValue != null) {
            while (!cache.replace(previousValue, new Element(key, (Object)(((Number)previousValue.getObjectValue()).longValue() + (long)request.getIncrement())))) {
                previousValue = cache.get(key);
            }
            return ((Number)previousValue.getObjectValue()).longValue() + (long)request.getIncrement();
        }
        return request.getInitialValue();
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public void forEachTuple(ModelConsumer consumer, TupleContext tupleContext, EntityKeyMetadata entityKeyMetadata) {
        this.getCacheManager().forEachTuple(new EntityKeyProcessor(consumer), entityKeyMetadata);
    }

    public DuplicateInsertPreventionStrategy getDuplicateInsertPreventionStrategy(EntityKeyMetadata entityKeyMetadata) {
        return DuplicateInsertPreventionStrategy.NATIVE;
    }

    private LocalCacheManager<EK, AK, ISK> getCacheManager() {
        return this.datastoreProvider.getCacheManager();
    }

    private KeyProvider<EK, AK, ISK> getKeyProvider() {
        return this.datastoreProvider.getKeyProvider();
    }

    private class EntityKeyProcessor
    implements LocalCacheManager.KeyProcessor<EK> {
        private final ModelConsumer consumer;

        private EntityKeyProcessor(ModelConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void processKey(EK key, Cache<EK> cache) {
            Element element = cache.get(key);
            this.consumer.consume(EhcacheDialect.this.createTuple(element));
        }
    }
}

