/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import org.hibernate.ogm.datastore.ehcache.impl.Cache;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableSerializableAssociationKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableSerializableEntityKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.table.impl.PerTableSerializableIdSourceKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.util.impl.CollectionHelper;

public class PerTableCacheManager
extends LocalCacheManager<PerTableSerializableEntityKey, PerTableSerializableAssociationKey, PerTableSerializableIdSourceKey> {
    private static final String ASSOCIATIONS_CACHE_PREFIX = "associations_";
    private final ConcurrentMap<String, Cache<PerTableSerializableEntityKey>> entityCaches;
    private final ConcurrentMap<String, Cache<PerTableSerializableAssociationKey>> associationCaches;
    private final ConcurrentMap<String, Cache<PerTableSerializableIdSourceKey>> idSourceCaches;

    public PerTableCacheManager(CacheManager cacheManager, Set<EntityKeyMetadata> entityTypes, Set<AssociationKeyMetadata> associationTypes, Set<IdSourceKeyMetadata> idSourceTypes) {
        super(cacheManager);
        this.entityCaches = PerTableCacheManager.initializeEntityCaches(cacheManager, entityTypes);
        this.associationCaches = PerTableCacheManager.initializeAssociationCaches(cacheManager, associationTypes);
        this.idSourceCaches = PerTableCacheManager.initializeIdSourceCaches(cacheManager, idSourceTypes);
    }

    private static ConcurrentMap<String, Cache<PerTableSerializableEntityKey>> initializeEntityCaches(CacheManager embeddedCacheManager, Set<EntityKeyMetadata> entityTypes) {
        ConcurrentHashMap entityCaches = CollectionHelper.newConcurrentHashMap((int)entityTypes.size());
        for (EntityKeyMetadata entityKeyMetadata : entityTypes) {
            String cacheName = entityKeyMetadata.getTable();
            entityCaches.put(cacheName, new Cache(PerTableCacheManager.getCache(embeddedCacheManager, cacheName, "ENTITIES")));
        }
        return entityCaches;
    }

    private static ConcurrentMap<String, Cache<PerTableSerializableAssociationKey>> initializeAssociationCaches(CacheManager embeddedCacheManager, Set<AssociationKeyMetadata> associationTypes) {
        ConcurrentHashMap associationCaches = CollectionHelper.newConcurrentHashMap((int)associationTypes.size());
        for (AssociationKeyMetadata associationKeyMetadata : associationTypes) {
            String cacheName = PerTableCacheManager.getCacheName(associationKeyMetadata);
            associationCaches.put(cacheName, new Cache(PerTableCacheManager.getCache(embeddedCacheManager, cacheName, "ASSOCIATIONS")));
        }
        return associationCaches;
    }

    private static ConcurrentMap<String, Cache<PerTableSerializableIdSourceKey>> initializeIdSourceCaches(CacheManager embeddedCacheManager, Set<IdSourceKeyMetadata> idSourceTypes) {
        ConcurrentHashMap idSourceCaches = CollectionHelper.newConcurrentHashMap((int)idSourceTypes.size());
        for (IdSourceKeyMetadata idSourceKeyMetadata : idSourceTypes) {
            String cacheName = idSourceKeyMetadata.getName();
            if (idSourceCaches.containsKey(cacheName)) continue;
            idSourceCaches.put(cacheName, new Cache(PerTableCacheManager.getCache(embeddedCacheManager, cacheName, "IDENTIFIERS")));
        }
        return idSourceCaches;
    }

    private static net.sf.ehcache.Cache getCache(CacheManager embeddedCacheManager, String cacheName, String templateName) {
        net.sf.ehcache.Cache cache = embeddedCacheManager.getCache(cacheName);
        if (cache == null) {
            CacheConfiguration configuration = ((CacheConfiguration)embeddedCacheManager.getConfiguration().getCacheConfigurations().get(templateName)).clone();
            configuration.setName(cacheName);
            cache = new net.sf.ehcache.Cache(configuration);
            embeddedCacheManager.addCache(cache);
        }
        return cache;
    }

    @Override
    public Cache<PerTableSerializableEntityKey> getEntityCache(EntityKeyMetadata keyMetadata) {
        return (Cache)this.entityCaches.get(keyMetadata.getTable());
    }

    @Override
    public Cache<PerTableSerializableAssociationKey> getAssociationCache(AssociationKeyMetadata keyMetadata) {
        return (Cache)this.associationCaches.get(PerTableCacheManager.getCacheName(keyMetadata));
    }

    @Override
    public Cache<PerTableSerializableIdSourceKey> getIdSourceCache(IdSourceKeyMetadata keyMetadata) {
        return (Cache)this.idSourceCaches.get(keyMetadata.getName());
    }

    private static String getCacheName(AssociationKeyMetadata keyMetadata) {
        return ASSOCIATIONS_CACHE_PREFIX + keyMetadata.getTable();
    }

    @Override
    public void forEachTuple(LocalCacheManager.KeyProcessor<PerTableSerializableEntityKey> processor, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            Cache<PerTableSerializableEntityKey> entityCache = this.getEntityCache(entityKeyMetadata);
            for (PerTableSerializableEntityKey key : entityCache.getKeys()) {
                processor.processKey(key, entityCache);
            }
        }
    }
}

