/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.persistencestrategy.common.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.common.impl.VersionChecker;
import org.hibernate.ogm.model.key.spi.RowKey;

public class SerializableRowKey
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int VERSION = 1;
    private String[] columnNames;
    private Object[] columnValues;

    public SerializableRowKey() {
    }

    public SerializableRowKey(RowKey key) {
        this.columnNames = key.getColumnNames();
        this.columnValues = key.getColumnValues();
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.columnNames);
        result = 31 * result + Arrays.hashCode(this.columnValues);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializableRowKey other = (SerializableRowKey)obj;
        if (!Arrays.equals(this.columnNames, other.columnNames)) {
            return false;
        }
        return Arrays.equals(this.columnValues, other.columnValues);
    }

    public String toString() {
        return "SerializableRowKey [columnNames=" + Arrays.toString(this.columnNames) + ", columnValues=" + Arrays.toString(this.columnValues) + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.columnNames);
        out.writeObject(this.columnValues);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        VersionChecker.readAndCheckVersion(in, 1, SerializableRowKey.class);
        this.columnNames = (String[])in.readObject();
        this.columnValues = (Object[])in.readObject();
    }
}

