/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.impl;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.ehcache.EhcacheDialect;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableAssociationKey;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableEntityKey;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableIdSourceKey;
import org.hibernate.ogm.datastore.ehcache.impl.Cache;
import org.hibernate.ogm.datastore.ehcache.impl.configuration.EhcacheConfiguration;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class EhcacheDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private JtaPlatform jtaPlatform;
    private CacheManager cacheManager;
    private Cache<SerializableEntityKey> entityCache;
    private Cache<SerializableAssociationKey> associationCache;
    private Cache<SerializableIdSourceKey> identifierCache;
    private final EhcacheConfiguration config = new EhcacheConfiguration();

    public void configure(Map map) {
        this.config.initialize(map);
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return EhcacheDialect.class;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.jtaPlatform = (JtaPlatform)serviceRegistryImplementor.getService(JtaPlatform.class);
    }

    public void start() {
        Configuration configuration = ConfigurationFactory.parseConfiguration((URL)this.config.getUrl());
        if (this.jtaPlatform != null) {
            OgmTransactionManagerLookupDelegate.transactionManager = this.jtaPlatform.retrieveTransactionManager();
            FactoryConfiguration transactionManagerLookupParameter = new FactoryConfiguration();
            transactionManagerLookupParameter.setClass(OgmTransactionManagerLookupDelegate.class.getName());
            configuration.addTransactionManagerLookup(transactionManagerLookupParameter);
        }
        this.cacheManager = CacheManager.create((URL)this.config.getUrl());
        this.entityCache = new Cache(this.cacheManager.getCache("ENTITIES"));
        this.associationCache = new Cache(this.cacheManager.getCache("ASSOCIATIONS"));
        this.identifierCache = new Cache(this.cacheManager.getCache("IDENTIFIERS"));
    }

    public void stop() {
        this.cacheManager.shutdown();
    }

    public Cache<SerializableEntityKey> getEntityCache() {
        return this.entityCache;
    }

    public Cache<SerializableAssociationKey> getAssociationCache() {
        return this.associationCache;
    }

    public Cache<SerializableIdSourceKey> getIdentifierCache() {
        return this.identifierCache;
    }

    public static class OgmTransactionManagerLookupDelegate
    implements TransactionManagerLookup {
        private static TransactionManager transactionManager;

        public TransactionManager getTransactionManager() {
            return transactionManager;
        }

        public void init() {
        }

        public void register(EhcacheXAResource resource, boolean forRecovery) {
        }

        public void unregister(EhcacheXAResource resource, boolean forRecovery) {
        }

        public void setProperties(Properties properties) {
        }
    }
}

