/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Element;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableAssociationKey;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableEntityKey;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableIdSourceKey;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableMapAssociationSnapshot;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableRowKey;
import org.hibernate.ogm.datastore.ehcache.impl.Cache;
import org.hibernate.ogm.datastore.ehcache.impl.EhcacheDatastoreProvider;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.persister.entity.Lockable;

public class EhcacheDialect
extends BaseGridDialect {
    EhcacheDatastoreProvider datastoreProvider;

    public EhcacheDialect(EhcacheDatastoreProvider datastoreProvider) {
        this.datastoreProvider = datastoreProvider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        throw new UnsupportedOperationException("LockMode " + lockMode + " is not supported by the Ehcache GridDialect");
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Cache<SerializableEntityKey> entityCache = this.datastoreProvider.getEntityCache();
        Element element = entityCache.get(new SerializableEntityKey(key));
        if (element != null) {
            return this.createTuple(element);
        }
        return null;
    }

    private Tuple createTuple(Element element) {
        return new Tuple((TupleSnapshot)new MapTupleSnapshot((Map)element.getObjectValue()));
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        Cache<SerializableEntityKey> entityCache = this.datastoreProvider.getEntityCache();
        HashMap tuple = new HashMap();
        entityCache.put(new Element((Serializable)new SerializableEntityKey(key), tuple));
        return new Tuple((TupleSnapshot)new MapTupleSnapshot(tuple));
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        Map entityRecord = ((MapTupleSnapshot)tuple.getSnapshot()).getMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, (Map)entityRecord);
        Cache<SerializableEntityKey> entityCache = this.datastoreProvider.getEntityCache();
        entityCache.put(new Element((Object)new SerializableEntityKey(key), (Object)entityRecord));
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.datastoreProvider.getEntityCache().remove(new SerializableEntityKey(key));
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<SerializableAssociationKey> associationCache = this.datastoreProvider.getAssociationCache();
        Element element = associationCache.get(new SerializableAssociationKey(key));
        if (element == null) {
            return null;
        }
        Map associationRows = (Map)element.getObjectValue();
        return new Association((AssociationSnapshot)new SerializableMapAssociationSnapshot(associationRows));
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<SerializableAssociationKey> associationCache = this.datastoreProvider.getAssociationCache();
        HashMap<SerializableRowKey, Map<String, Object>> association = new HashMap<SerializableRowKey, Map<String, Object>>();
        associationCache.put(new Element((Object)new SerializableAssociationKey(key), association));
        return new Association((AssociationSnapshot)new SerializableMapAssociationSnapshot(association));
    }

    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        Map<SerializableRowKey, Map<String, Object>> associationRows = ((SerializableMapAssociationSnapshot)association.getSnapshot()).getUnderlyingMap();
        for (AssociationOperation action : association.getOperations()) {
            switch (action.getType()) {
                case CLEAR: {
                    associationRows.clear();
                }
                case PUT_NULL: 
                case PUT: {
                    associationRows.put(new SerializableRowKey(action.getKey()), MapHelpers.tupleToMap((Tuple)action.getValue()));
                    break;
                }
                case REMOVE: {
                    associationRows.remove(new SerializableRowKey(action.getKey()));
                }
            }
        }
        Cache<SerializableAssociationKey> associationCache = this.datastoreProvider.getAssociationCache();
        associationCache.put(new Element((Object)new SerializableAssociationKey(key), associationRows));
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        this.datastoreProvider.getAssociationCache().remove(new SerializableAssociationKey(key));
    }

    public Number nextValue(NextValueRequest request) {
        SerializableIdSourceKey key;
        Cache<SerializableIdSourceKey> cache = this.datastoreProvider.getIdentifierCache();
        Element previousValue = cache.get(key = new SerializableIdSourceKey(request.getKey()));
        if (previousValue == null) {
            previousValue = cache.putIfAbsent(new Element((Serializable)key, (Serializable)Integer.valueOf(request.getInitialValue())));
        }
        if (previousValue != null) {
            while (!cache.replace(previousValue, new Element((Serializable)key, (Serializable)Integer.valueOf((Integer)previousValue.getObjectValue() + request.getIncrement())))) {
                previousValue = cache.get(key);
            }
            return (Integer)previousValue.getObjectValue() + request.getIncrement();
        }
        return request.getInitialValue();
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        return false;
    }

    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        Cache<SerializableEntityKey> entityCache = this.datastoreProvider.getEntityCache();
        for (SerializableEntityKey key : entityCache.getKeys()) {
            for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
                if (!key.getTable().equals(entityKeyMetadata.getTable())) continue;
                Element element = entityCache.get(key);
                consumer.consume(this.createTuple(element));
            }
        }
    }
}

