/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.ehcache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.ogm.datastore.ehcache.impl.EhcacheDatastoreProvider;
import org.hibernate.ogm.datastore.impl.EmptyTupleSnapshot;
import org.hibernate.ogm.datastore.impl.MapHelpers;
import org.hibernate.ogm.datastore.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.type.GridType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.Type;

public class EhcacheDialect
implements GridDialect {
    EhcacheDatastoreProvider datastoreProvider;

    public EhcacheDialect(EhcacheDatastoreProvider datastoreProvider) {
        this.datastoreProvider = datastoreProvider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        throw new UnsupportedOperationException("LockMode " + lockMode + " is not supported by the Ehcache GridDialect");
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Cache entityCache = this.getEntityCache();
        Element element = entityCache.get((Serializable)key);
        if (element != null) {
            return new Tuple((TupleSnapshot)new MapTupleSnapshot((Map)((Object)element.getValue())));
        }
        return null;
    }

    public Tuple createTuple(EntityKey key) {
        Cache entityCache = this.getEntityCache();
        HashMap tuple = new HashMap();
        entityCache.put(new Element((Serializable)key, tuple));
        return new Tuple((TupleSnapshot)new MapTupleSnapshot(tuple));
    }

    public void updateTuple(Tuple tuple, EntityKey key) {
        Map entityRecord = ((MapTupleSnapshot)tuple.getSnapshot()).getMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, (Map)entityRecord);
    }

    public void removeTuple(EntityKey key) {
        this.getEntityCache().remove((Serializable)key);
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache associationCache = this.getAssociationCache();
        Element element = associationCache.get((Serializable)key);
        if (element == null) {
            return null;
        }
        return new Association((AssociationSnapshot)new MapAssociationSnapshot((Map)((Object)element.getValue())));
    }

    public Association createAssociation(AssociationKey key) {
        Cache associationCache = this.getAssociationCache();
        HashMap association = new HashMap();
        associationCache.put(new Element((Object)key, association));
        return new Association((AssociationSnapshot)new MapAssociationSnapshot(association));
    }

    public void updateAssociation(Association association, AssociationKey key) {
        MapHelpers.updateAssociation((Association)association, (AssociationKey)key);
    }

    public void removeAssociation(AssociationKey key) {
        this.getAssociationCache().remove((Serializable)key);
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple(EmptyTupleSnapshot.SINGLETON);
    }

    public void nextValue(RowKey key, IntegralDataTypeHolder value, int increment, int initialValue) {
        Cache cache = this.getIdentifierCache();
        Element previousValue = cache.get((Serializable)key);
        if (previousValue == null) {
            previousValue = cache.putIfAbsent(new Element((Serializable)key, (Serializable)Integer.valueOf(initialValue)));
        }
        if (previousValue != null) {
            while (!cache.replace(previousValue, new Element((Serializable)key, (Serializable)Integer.valueOf((Integer)previousValue.getValue() + increment)))) {
                previousValue = cache.get((Serializable)key);
            }
            value.initialize((long)((Integer)previousValue.getValue() + increment));
        } else {
            value.initialize((long)initialValue);
        }
    }

    public GridType overrideType(Type type) {
        return null;
    }

    private Cache getIdentifierCache() {
        return this.datastoreProvider.getCacheManager().getCache("IDENTIFIERS");
    }

    private Cache getEntityCache() {
        return this.datastoreProvider.getCacheManager().getCache("ENTITIES");
    }

    private Cache getAssociationCache() {
        return this.datastoreProvider.getCacheManager().getCache("ASSOCIATIONS");
    }
}

