/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.transaction.manager.TransactionManagerLookup;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.ehcache.EhcacheDialect;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class EhcacheDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    public static final String EHCACHE_CONFIG = "hibernate.ogm.ehcache.configuration_resourcename";
    private Map cfg;
    private JtaPlatform jtaPlatform;
    private CacheManager cacheManager;

    public void configure(Map map) {
        this.cfg = map;
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return EhcacheDialect.class;
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistryImplementor) {
        this.jtaPlatform = (JtaPlatform)serviceRegistryImplementor.getService(JtaPlatform.class);
    }

    public void start() {
        URL url;
        String configUrl = (String)this.cfg.get(EHCACHE_CONFIG);
        if (configUrl != null) {
            try {
                url = new URL(configUrl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            url = this.getClass().getResource("/org/hibernate/ogm/datastore/ehcache/default-ehcache.xml");
        }
        Configuration configuration = ConfigurationFactory.parseConfiguration((URL)url);
        if (this.jtaPlatform != null) {
            OgmTransactionManagerLookupDelegate.transactionManager = this.jtaPlatform.retrieveTransactionManager();
            FactoryConfiguration transactionManagerLookupParameter = new FactoryConfiguration();
            transactionManagerLookupParameter.setClass(OgmTransactionManagerLookupDelegate.class.getName());
            configuration.addTransactionManagerLookup(transactionManagerLookupParameter);
        }
        this.cacheManager = CacheManager.create((URL)url);
    }

    public void stop() {
        this.cacheManager.shutdown();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public static class OgmTransactionManagerLookupDelegate
    implements TransactionManagerLookup {
        private static TransactionManager transactionManager;

        public TransactionManager getTransactionManager() {
            return transactionManager;
        }

        public void register(EhcacheXAResource resource) {
        }

        public void unregister(EhcacheXAResource resource) {
        }

        public void setProperties(Properties properties) {
        }
    }
}

