/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils;

import com.arjuna.ats.arjuna.coordinator.TxControl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.test.utils.GridDialectType;
import org.hibernate.ogm.test.utils.HashMapTestHelper;
import org.hibernate.ogm.test.utils.TestableGridDialect;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class TestHelper {
    private static final Log log = LoggerFactory.make();
    private static final TestableGridDialect helper = TestHelper.createStoreSpecificHelper();

    public static boolean assertNumberOfEntities(int numberOfEntities, EntityManager em) {
        return TestHelper.assertNumberOfEntities(numberOfEntities, (Session)em.unwrap(Session.class));
    }

    private static TestableGridDialect createStoreSpecificHelper() {
        for (GridDialectType gridType : GridDialectType.values()) {
            Class<?> classForName = gridType.loadTestableGridDialectClass();
            if (classForName == null) continue;
            try {
                TestableGridDialect attempt = (TestableGridDialect)classForName.newInstance();
                log.debugf("Using TestGridDialect %s", classForName);
                return attempt;
            }
            catch (Exception e) {
                log.errorf((Throwable)e, "Could not load TestGridDialect by name from %s", (Object)gridType);
            }
        }
        return new HashMapTestHelper();
    }

    public static GridDialectType getCurrentDialectType() {
        return GridDialectType.valueFromHelperClass(helper.getClass());
    }

    public static boolean assertNumberOfEntities(int numberOfEntities, Session session) {
        return TestHelper.assertNumberOfEntities(numberOfEntities, session.getSessionFactory());
    }

    public static boolean assertNumberOfEntities(int numberOfEntities, SessionFactory sessionFactory) {
        return helper.assertNumberOfEntities(numberOfEntities, sessionFactory);
    }

    public static Map extractEntityTuple(SessionFactory sessionFactory, EntityKey key) {
        return helper.extractEntityTuple(sessionFactory, key);
    }

    public static boolean assertNumberOfAssociations(int numberOfAssociations, SessionFactory sessionFactory) {
        boolean result = helper.assertNumberOfAssociations(numberOfAssociations, sessionFactory);
        return result;
    }

    public static boolean backendSupportsTransactions() {
        return helper.backendSupportsTransactions();
    }

    public static <T> T get(Session session, Class<T> clazz, Serializable id) {
        return (T)session.get(clazz, id);
    }

    public static void dropSchemaAndDatabase(Session session) {
        if (session != null) {
            TestHelper.dropSchemaAndDatabase(session.getSessionFactory());
        }
    }

    public static void dropSchemaAndDatabase(EntityManagerFactory emf) {
        TestHelper.dropSchemaAndDatabase(((HibernateEntityManagerFactory)emf).getSessionFactory());
    }

    public static void dropSchemaAndDatabase(SessionFactory sessionFactory) {
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            try {
                helper.dropSchemaAndDatabase(sessionFactory);
            }
            catch (Exception e) {
                log.warn((Object)"Exception while dropping schema and database in test", (Throwable)e);
            }
        }
    }

    public static Map<String, String> getEnvironmentProperties() {
        HashMap environmentProperties = helper.getEnvironmentProperties();
        return environmentProperties == null ? new HashMap(0) : environmentProperties;
    }

    public static void initializeHelpers() {
    }

    static {
        TxControl.setDefaultTimeout((int)7200);
    }
}

