/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.utils;

import java.io.Serializable;
import java.util.Map;
import net.sf.ehcache.Cache;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.ehcache.impl.EhcacheDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.test.utils.TestableGridDialect;

public class EhcacheTestHelper
implements TestableGridDialect {
    @Override
    public boolean assertNumberOfEntities(int numberOfEntities, SessionFactory sessionFactory) {
        return EhcacheTestHelper.getEntityCache(sessionFactory).getSize() == numberOfEntities;
    }

    @Override
    public boolean assertNumberOfAssociations(int numberOfAssociations, SessionFactory sessionFactory) {
        return EhcacheTestHelper.getAssociationCache(sessionFactory).getSize() == numberOfAssociations;
    }

    @Override
    public Map<String, Object> extractEntityTuple(SessionFactory sessionFactory, EntityKey key) {
        return (Map)((Object)EhcacheTestHelper.getEntityCache(sessionFactory).get((Serializable)key).getValue());
    }

    private static Cache getEntityCache(SessionFactory sessionFactory) {
        EhcacheDatastoreProvider castProvider = EhcacheTestHelper.getProvider(sessionFactory);
        return castProvider.getCacheManager().getCache("ENTITIES");
    }

    private static EhcacheDatastoreProvider getProvider(SessionFactory sessionFactory) {
        DatastoreProvider provider = (DatastoreProvider)((SessionFactoryImplementor)sessionFactory).getServiceRegistry().getService(DatastoreProvider.class);
        if (!EhcacheDatastoreProvider.class.isInstance(provider)) {
            throw new RuntimeException("Not testing with Ehcache, cannot extract underlying cache");
        }
        return (EhcacheDatastoreProvider)EhcacheDatastoreProvider.class.cast(provider);
    }

    private static Cache getAssociationCache(SessionFactory sessionFactory) {
        EhcacheDatastoreProvider castProvider = EhcacheTestHelper.getProvider(sessionFactory);
        return castProvider.getCacheManager().getCache("ASSOCIATIONS");
    }

    @Override
    public boolean backendSupportsTransactions() {
        return false;
    }

    @Override
    public void dropSchemaAndDatabase(SessionFactory sessionFactory) {
    }

    @Override
    public Map<String, String> getEnvironmentProperties() {
        return null;
    }
}

