/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.type.descriptor;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.type.descriptor.CalendarTimeZoneDateTimeTypeDescriptor;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CalendarTimeZoneDateTimeTypeDescriptorTest {
    private Calendar one;
    private Calendar another;
    private boolean exceptedEquality;

    public CalendarTimeZoneDateTimeTypeDescriptorTest(Calendar one, Calendar another, boolean exceptedEquality) {
        this.one = one;
        this.another = another;
        this.exceptedEquality = exceptedEquality;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        GregorianCalendar past = new GregorianCalendar();
        past.set(5, 28);
        past.set(2, 12);
        past.set(1, 1976);
        ((Calendar)past).setTimeZone(TimeZone.getTimeZone("Africa/Casablanca"));
        GregorianCalendar pastGMT = (GregorianCalendar)((Calendar)past).clone();
        ((Calendar)pastGMT).setTimeZone(TimeZone.getDefault());
        Object[][] data = new Object[][]{{null, null, true}, {GregorianCalendar.getInstance(), null, false}, {null, GregorianCalendar.getInstance(), false}, {past, past, true}, {past, new GregorianCalendar(), false}, {past, pastGMT, false}};
        return Arrays.asList(data);
    }

    @Test
    public void testCalendarTimeZoneDateTimeObjects() {
        CalendarTimeZoneDateTimeTypeDescriptor calendarTimeZoneDateTimeTypeDescriptor = new CalendarTimeZoneDateTimeTypeDescriptor();
        Assertions.assertThat((boolean)calendarTimeZoneDateTimeTypeDescriptor.areEqual(this.one, this.another)).isEqualTo(this.exceptedEquality);
    }
}

