/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.queries;

import java.util.List;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.queries.Helicopter;
import org.hibernate.ogm.test.queries.Hypothesis;
import org.hibernate.ogm.test.utils.SessionFactoryRule;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SimpleQueriesTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @ClassRule
    public static final SessionFactoryRule sessions = new SessionFactoryRule(Hypothesis.class, Helicopter.class);

    @Test
    public void testSimpleQueries() throws Exception {
        Session session = sessions.openSession();
        this.assertQuery(session, 4, session.createQuery("from Hypothesis"));
        this.assertQuery(session, 4, session.createQuery("from org.hibernate.ogm.test.queries.Hypothesis"));
        this.assertQuery(session, 1, session.createQuery("from Helicopter"));
        this.assertQuery(session, 5, session.createQuery("from java.lang.Object"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailingQuery() {
        Session session = sessions.openSession();
        this.thrown.expect(HibernateException.class);
        this.thrown.expectMessage("OGM000024");
        try {
            this.assertQuery(session, 4, session.createQuery("from Object"));
        }
        finally {
            session.close();
        }
    }

    @Test
    public void testConstantParameterQueries() throws Exception {
        Session session = sessions.openSession();
        this.assertQuery(session, 1, session.createQuery("from Hypothesis h where h.description = 'stuff works'"));
        session.close();
    }

    @Test
    public void testParametricQueries() throws Exception {
        Session session = sessions.openSession();
        Query query = session.createQuery("from Hypothesis h where h.description = :myParam").setString("myParam", "stuff works");
        this.assertQuery(session, 1, query);
        session.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertQuery(Session session, int expectedSize, Query testedQuery) {
        Transaction transaction = session.beginTransaction();
        List list = testedQuery.list();
        try {
            ((ListAssert)Assertions.assertThat((List)list).as("Query failed")).hasSize(expectedSize);
        }
        finally {
            transaction.commit();
            session.clear();
        }
    }

    @BeforeClass
    public static void setUp() throws Exception {
        Session session = sessions.openSession();
        Transaction transaction = session.beginTransaction();
        Hypothesis socrates = new Hypothesis();
        socrates.setId("13");
        socrates.setDescription("There are more than two dimensions over the shadows we see out of the cave");
        socrates.setPosition(1);
        session.persist((Object)socrates);
        Hypothesis peano = new Hypothesis();
        peano.setId("14");
        peano.setDescription("Peano's curve and then Hilbert's space filling curve proof the connection from mono-dimensional to bi-dimensional space");
        peano.setPosition(2);
        session.persist((Object)peano);
        Hypothesis sanne = new Hypothesis();
        sanne.setId("15");
        sanne.setDescription("Hilbert's proof of connection to 2 dimensions can be induced to reason on N dimensions");
        sanne.setPosition(3);
        session.persist((Object)sanne);
        Hypothesis shortOne = new Hypothesis();
        shortOne.setId("16");
        shortOne.setDescription("stuff works");
        shortOne.setPosition(4);
        session.persist((Object)shortOne);
        Helicopter helicopter = new Helicopter();
        helicopter.setName("No creative clue ");
        session.persist((Object)helicopter);
        transaction.commit();
        session.close();
    }
}

