/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.id;

import javax.persistence.EntityManager;
import org.fest.assertions.Assertions;
import org.hibernate.ogm.test.id.Music;
import org.hibernate.ogm.test.id.Video;
import org.hibernate.ogm.test.utils.jpa.JpaTestCase;
import org.junit.Test;

public class TableIdGeneratorTest
extends JpaTestCase {
    @Test
    public void testTableIdGeneratorInJTA() throws Exception {
        this.getTransactionManager().begin();
        EntityManager em = this.getFactory().createEntityManager();
        Music music = new Music();
        music.setName("Variations Sur Marilou");
        music.setComposer("Gainsbourg");
        em.persist((Object)music);
        Video video = new Video();
        video.setDirector("Wes Craven");
        video.setName("Scream");
        em.persist((Object)video);
        this.getTransactionManager().commit();
        em.clear();
        this.getTransactionManager().begin();
        music = (Music)em.find(Music.class, (Object)music.getId());
        Assertions.assertThat((Object)music).isNotNull();
        Assertions.assertThat((String)music.getName()).isEqualTo((Object)"Variations Sur Marilou");
        em.remove((Object)music);
        video = (Video)em.find(Video.class, (Object)video.getId());
        Assertions.assertThat((Object)video).isNotNull();
        Assertions.assertThat((String)video.getName()).isEqualTo((Object)"Scream");
        em.remove((Object)video);
        this.getTransactionManager().commit();
        em.close();
    }

    @Override
    public Class<?>[] getEntities() {
        return new Class[]{Music.class, Video.class};
    }
}

