/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.hibernatecore;

import javax.naming.Reference;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactory;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactoryObjectFactory;
import org.hibernate.ogm.test.hibernatecore.Contact;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;
import org.junit.Test;

public class JNDIReferenceTest
extends OgmTestCase {
    @Test
    public void testGetReferenceImplementation() throws Exception {
        Session session = this.openSession();
        SessionFactory factory = session.getSessionFactory();
        Assertions.assertThat(factory.getClass()).isEqualTo(OgmSessionFactory.class);
        Reference reference = factory.getReference();
        Assertions.assertThat((String)reference.getClassName()).isEqualTo((Object)OgmSessionFactory.class.getName());
        Assertions.assertThat((String)reference.getFactoryClassName()).isEqualTo((Object)OgmSessionFactoryObjectFactory.class.getName());
        Assertions.assertThat((Object)reference.get(0)).isNotNull();
        Assertions.assertThat((String)reference.getFactoryClassLocation()).isNull();
        OgmSessionFactoryObjectFactory objFactory = new OgmSessionFactoryObjectFactory();
        SessionFactory factoryFromRegistry = (SessionFactory)objFactory.getObjectInstance((Object)reference, null, null, null);
        Assertions.assertThat(factoryFromRegistry.getClass()).isEqualTo(OgmSessionFactory.class);
        Assertions.assertThat((Object)factoryFromRegistry.getReference()).isEqualTo((Object)factory.getReference());
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Contact.class};
    }
}

