/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.test.embeddable;

import java.io.Serializable;
import org.fest.assertions.Assertions;
import org.fest.assertions.ObjectAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.ogm.test.embeddable.Account;
import org.hibernate.ogm.test.embeddable.Address;
import org.hibernate.ogm.test.simpleentity.OgmTestCase;

public class EmbeddableTest
extends OgmTestCase {
    public void testEmbeddable() throws Exception {
        Session session = this.openSession();
        Transaction transaction = session.beginTransaction();
        Account account = new Account();
        account.setLogin("emmanuel");
        account.setPassword("like I would tell ya");
        account.setHomeAddress(new Address());
        Address address = account.getHomeAddress();
        address.setCity("Paris");
        address.setCountry("France");
        address.setStreet1("1 avenue des Champs Elysees");
        address.setZipCode("75007");
        session.persist((Object)account);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Account loadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((ObjectAssert)Assertions.assertThat((Object)loadedAccount).as("Cannot load persisted object")).isNotNull();
        Address loadedAddress = loadedAccount.getHomeAddress();
        ((ObjectAssert)Assertions.assertThat((Object)loadedAddress).as("Embeddable should not be null")).isNotNull();
        ((StringAssert)Assertions.assertThat((String)loadedAddress.getCity()).as("persist and load fails for embeddable")).isEqualTo((Object)address.getCity());
        ((StringAssert)Assertions.assertThat((String)loadedAddress.getZipCode()).as("@Column support for embeddable does not work")).isEqualTo((Object)address.getZipCode());
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        loadedAddress.setCountry("USA");
        session.merge((Object)loadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Account secondLoadedAccount = (Account)session.get(Account.class, (Serializable)((Object)account.getLogin()));
        ((StringAssert)Assertions.assertThat((String)loadedAccount.getHomeAddress().getCity()).as("Merge fails for embeddable")).isEqualTo((Object)secondLoadedAccount.getHomeAddress().getCity());
        session.delete((Object)secondLoadedAccount);
        transaction.commit();
        session.clear();
        transaction = session.beginTransaction();
        Assertions.assertThat((Object)session.get(Account.class, (Serializable)((Object)account.getLogin()))).isNull();
        transaction.commit();
        session.close();
    }

    @Override
    protected Class<?>[] getAnnotatedClasses() {
        return new Class[]{Account.class};
    }
}

