/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.ehcache;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.ogm.datastore.ehcache.impl.EhcacheDatastoreProvider;
import org.hibernate.ogm.dialect.ehcache.EhcacheDialect;
import org.hibernate.ogm.grid.RowKey;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EhcacheDialectTest {
    private static final int LOOPS = 2500;
    private static final int THREADS = 10;
    private EhcacheDialect dialect;

    @Before
    public void setup() {
        EhcacheDatastoreProvider datastoreProvider = new EhcacheDatastoreProvider();
        datastoreProvider.configure(new HashMap());
        datastoreProvider.start();
        this.dialect = new EhcacheDialect(datastoreProvider);
    }

    @Test
    public void testIsThreadSafe() throws InterruptedException {
        final RowKey test = new RowKey("test", null, null);
        Thread[] threads = new Thread[10];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(new Runnable(){

                @Override
                public void run() {
                    IdentifierGeneratorHelper.BigIntegerHolder value = new IdentifierGeneratorHelper.BigIntegerHolder();
                    for (int i = 0; i < 2500; ++i) {
                        EhcacheDialectTest.this.dialect.nextValue(test, (IntegralDataTypeHolder)value, 1, 1);
                    }
                }
            });
            threads[i].start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        IdentifierGeneratorHelper.BigIntegerHolder value = new IdentifierGeneratorHelper.BigIntegerHolder();
        this.dialect.nextValue(test, (IntegralDataTypeHolder)value, 0, 1);
        Assert.assertThat((Object)value.makeValue().intValue(), (Matcher)CoreMatchers.equalTo((Object)25000));
    }
}

