/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.object;

import java.util.EnumSet;
import java.util.Objects;
import org.heigit.bigspatialdata.oshdb.api.object.OSHDBMapReducible;
import org.heigit.bigspatialdata.oshdb.osh.OSHEntity;
import org.heigit.bigspatialdata.oshdb.osm.OSMEntity;
import org.heigit.bigspatialdata.oshdb.osm.OSMRelation;
import org.heigit.bigspatialdata.oshdb.osm.OSMWay;
import org.heigit.bigspatialdata.oshdb.util.OSHDBTimestamp;
import org.heigit.bigspatialdata.oshdb.util.celliterator.CellIterator;
import org.heigit.bigspatialdata.oshdb.util.celliterator.ContributionType;
import org.heigit.bigspatialdata.oshdb.util.celliterator.LazyEvaluatedObject;
import org.locationtech.jts.geom.Geometry;

public class OSMContribution
implements OSHDBMapReducible {
    private final CellIterator.IterateAllEntry data;

    public OSMContribution(CellIterator.IterateAllEntry data) {
        this.data = data;
    }

    public OSMContribution(OSMContribution other, Geometry reclippedGeometryBefore, Geometry reclippedGeometryAfter) {
        this.data = new CellIterator.IterateAllEntry(other.data.timestamp, other.data.osmEntity, other.data.previousOsmEntity, other.data.oshEntity, new LazyEvaluatedObject((Object)reclippedGeometryAfter), new LazyEvaluatedObject((Object)reclippedGeometryBefore), other.data.unclippedGeometry, other.data.unclippedPreviousGeometry, other.data.activities, other.data.changeset);
    }

    public OSHDBTimestamp getTimestamp() {
        return this.data.timestamp;
    }

    public Geometry getGeometryBefore() {
        return (Geometry)this.data.previousGeometry.get();
    }

    public Geometry getGeometryUnclippedBefore() {
        return (Geometry)this.data.unclippedPreviousGeometry.get();
    }

    public Geometry getGeometryAfter() {
        return (Geometry)this.data.geometry.get();
    }

    public Geometry getGeometryUnclippedAfter() {
        return (Geometry)this.data.unclippedGeometry.get();
    }

    public OSMEntity getEntityBefore() {
        return this.data.previousOsmEntity;
    }

    public OSMEntity getEntityAfter() {
        return this.data.osmEntity;
    }

    public OSHEntity getOSHEntity() {
        return this.data.oshEntity;
    }

    public boolean is(ContributionType contributionType) {
        return this.data.activities.contains(contributionType);
    }

    public EnumSet<ContributionType> getContributionTypes() {
        return this.data.activities.get();
    }

    public int getContributorUserId() {
        OSMEntity entity = this.getEntityAfter();
        OSHDBTimestamp contributionTimestamp = this.getTimestamp();
        if (contributionTimestamp.equals((Object)entity.getTimestamp()) || this.getEntityBefore() == null || this.getEntityBefore().getVersion() != this.getEntityAfter().getVersion()) {
            return entity.getUserId();
        }
        int userId = -1;
        if (entity instanceof OSMWay) {
            userId = ((OSMWay)entity).getRefEntities(contributionTimestamp).filter(Objects::nonNull).filter(n -> n.getTimestamp().equals((Object)contributionTimestamp)).findFirst().map(OSMEntity::getUserId).orElse(-1);
        } else if (entity instanceof OSMRelation) {
            userId = ((OSMRelation)entity).getMemberEntities(contributionTimestamp).filter(Objects::nonNull).filter(e -> e.getTimestamp().equals((Object)contributionTimestamp)).findFirst().map(OSMEntity::getUserId).orElseGet(() -> ((OSMRelation)entity).getMemberEntities(contributionTimestamp).filter(Objects::nonNull).filter(e -> e instanceof OSMWay).map(e -> (OSMWay)e).flatMap(w -> w.getRefEntities(contributionTimestamp)).filter(Objects::nonNull).filter(n -> n.getTimestamp().equals((Object)contributionTimestamp)).findFirst().map(OSMEntity::getUserId).orElse(-1));
        }
        return userId;
    }

    public long getChangesetId() {
        return this.data.changeset;
    }
}

