/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.mapreducer.backend;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBDatabase;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBiFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBinaryOperator;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableSupplier;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducer;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.Kernels;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.MapReducerJdbc;
import org.heigit.bigspatialdata.oshdb.api.object.OSHDBMapReducible;
import org.heigit.bigspatialdata.oshdb.api.object.OSMContribution;
import org.heigit.bigspatialdata.oshdb.api.object.OSMEntitySnapshot;
import org.heigit.bigspatialdata.oshdb.util.celliterator.CellIterator;
import org.jetbrains.annotations.NotNull;
import org.json.simple.parser.ParseException;

public class MapReducerJdbcMultithread<X>
extends MapReducerJdbc<X> {
    public MapReducerJdbcMultithread(OSHDBDatabase oshdb, Class<? extends OSHDBMapReducible> forClass) {
        super(oshdb, forClass);
    }

    private MapReducerJdbcMultithread(MapReducerJdbcMultithread obj) {
        super(obj);
    }

    @Override
    @NotNull
    protected MapReducer<X> copy() {
        return new MapReducerJdbcMultithread<X>(this);
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    private <S> S reduce(Kernels.CellProcessor<S> processor, SerializableSupplier<S> identitySupplier, SerializableBinaryOperator<S> combiner) throws ParseException, SQLException, IOException {
        this.executionStartTimeMillis = System.currentTimeMillis();
        CellIterator cellIterator = new CellIterator(this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), this.getTagInterpreter(), this.getPreFilter(), this.getFilter(), false);
        ArrayList cellIdRanges = new ArrayList();
        this.getCellIdRanges().forEach(cellIdRanges::add);
        return (S)cellIdRanges.parallelStream().filter((? super T ignored) -> this.isActive()).flatMap(this::getOshCellsStream).filter((? super T ignored) -> this.isActive()).map((? super T oshCell) -> processor.apply(oshCell, cellIterator)).reduce(identitySupplier.get(), combiner);
    }

    private Stream<X> stream(Kernels.CellProcessor<Stream<X>> processor) throws ParseException, SQLException, IOException {
        this.executionStartTimeMillis = System.currentTimeMillis();
        CellIterator cellIterator = new CellIterator(this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), this.getTagInterpreter(), this.getPreFilter(), this.getFilter(), false);
        ArrayList cellIdRanges = new ArrayList();
        this.getCellIdRanges().forEach(cellIdRanges::add);
        return cellIdRanges.parallelStream().filter((? super T ignored) -> this.isActive()).flatMap(this::getOshCellsStream).filter((? super T ignored) -> this.isActive()).flatMap((? super T oshCell) -> (Stream)processor.apply(oshCell, cellIterator));
    }

    @Override
    protected <R, S> S mapReduceCellsOSMContribution(SerializableFunction<OSMContribution, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        return this.reduce(Kernels.getOSMContributionCellReducer(mapper, identitySupplier, accumulator, this), identitySupplier, combiner);
    }

    @Override
    protected <R, S> S flatMapReduceCellsOSMContributionGroupedById(SerializableFunction<List<OSMContribution>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        return this.reduce(Kernels.getOSMContributionGroupingCellReducer(mapper, identitySupplier, accumulator, this), identitySupplier, combiner);
    }

    @Override
    protected <R, S> S mapReduceCellsOSMEntitySnapshot(SerializableFunction<OSMEntitySnapshot, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        return this.reduce(Kernels.getOSMEntitySnapshotCellReducer(mapper, identitySupplier, accumulator, this), identitySupplier, combiner);
    }

    @Override
    protected <R, S> S flatMapReduceCellsOSMEntitySnapshotGroupedById(SerializableFunction<List<OSMEntitySnapshot>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        return this.reduce(Kernels.getOSMEntitySnapshotGroupingCellReducer(mapper, identitySupplier, accumulator, this), identitySupplier, combiner);
    }

    @Override
    protected Stream<X> mapStreamCellsOSMContribution(SerializableFunction<OSMContribution, X> mapper) throws Exception {
        return this.stream(Kernels.getOSMContributionCellStreamer(mapper, this));
    }

    @Override
    protected Stream<X> flatMapStreamCellsOSMContributionGroupedById(SerializableFunction<List<OSMContribution>, Iterable<X>> mapper) throws Exception {
        return this.stream(Kernels.getOSMContributionGroupingCellStreamer(mapper, this));
    }

    @Override
    protected Stream<X> mapStreamCellsOSMEntitySnapshot(SerializableFunction<OSMEntitySnapshot, X> mapper) throws Exception {
        return this.stream(Kernels.getOSMEntitySnapshotCellStreamer(mapper, this));
    }

    @Override
    protected Stream<X> flatMapStreamCellsOSMEntitySnapshotGroupedById(SerializableFunction<List<OSMEntitySnapshot>, Iterable<X>> mapper) throws Exception {
        return this.stream(Kernels.getOSMEntitySnapshotGroupingCellStreamer(mapper, this));
    }
}

