/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.mapreducer.backend;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBDatabase;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBJdbc;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducer;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.Kernels;
import org.heigit.bigspatialdata.oshdb.api.object.OSHDBMapReducible;
import org.heigit.bigspatialdata.oshdb.grid.GridOSHEntity;
import org.heigit.bigspatialdata.oshdb.index.XYGridTree;
import org.heigit.bigspatialdata.oshdb.osm.OSMType;
import org.heigit.bigspatialdata.oshdb.util.TableNames;
import org.heigit.bigspatialdata.oshdb.util.exceptions.OSHDBTimeoutException;

abstract class MapReducerJdbc<X>
extends MapReducer<X>
implements Kernels.CancelableProcessStatus {
    protected long executionStartTimeMillis;

    MapReducerJdbc(OSHDBDatabase oshdb, Class<? extends OSHDBMapReducible> forClass) {
        super(oshdb, forClass);
    }

    MapReducerJdbc(MapReducerJdbc obj) {
        super(obj);
    }

    @Override
    public boolean isActive() {
        if (this.timeout != null && System.currentTimeMillis() - this.executionStartTimeMillis > this.timeout) {
            throw new OSHDBTimeoutException();
        }
        return true;
    }

    protected ResultSet getOshCellsRawDataFromDb(XYGridTree.CellIdRange cellIdRange) throws SQLException {
        String sqlQuery = this.typeFilter.stream().map((? super T osmType) -> TableNames.forOSMType((OSMType)osmType).map((? super T tn) -> tn.toString(this.oshdb.prefix()))).filter(Optional::isPresent).map(Optional::get).map((? super T tn) -> "(select data from " + tn + " where level = ?1 and id between ?2 and ?3)").collect(Collectors.joining(" union all "));
        PreparedStatement pstmt = ((OSHDBJdbc)this.oshdb).getConnection().prepareStatement(sqlQuery);
        pstmt.setInt(1, cellIdRange.getStart().getZoomLevel());
        pstmt.setLong(2, cellIdRange.getStart().getId());
        pstmt.setLong(3, cellIdRange.getEnd().getId());
        return pstmt.executeQuery();
    }

    protected GridOSHEntity readOshCellRawData(ResultSet oshCellsRawData) throws IOException, ClassNotFoundException, SQLException {
        return (GridOSHEntity)new ObjectInputStream(oshCellsRawData.getBinaryStream(1)).readObject();
    }

    @Nonnull
    protected Stream<GridOSHEntity> getOshCellsStream(XYGridTree.CellIdRange cellIdRange) {
        try {
            if (this.typeFilter.isEmpty()) {
                return Stream.empty();
            }
            final ResultSet oshCellsRawData = this.getOshCellsRawDataFromDb(cellIdRange);
            if (!oshCellsRawData.next()) {
                return Stream.empty();
            }
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<GridOSHEntity>(){

                @Override
                public boolean hasNext() {
                    try {
                        return !oshCellsRawData.isClosed();
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public GridOSHEntity next() {
                    try {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        GridOSHEntity data = MapReducerJdbc.this.readOshCellRawData(oshCellsRawData);
                        if (!oshCellsRawData.next()) {
                            oshCellsRawData.close();
                        }
                        return data;
                    }
                    catch (IOException | ClassNotFoundException | SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
            }, 0), false);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

