/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.mapreducer.backend;

import com.google.common.collect.Streams;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCompute;
import org.apache.ignite.binary.BinaryObject;
import org.apache.ignite.cache.affinity.Affinity;
import org.apache.ignite.cache.query.Query;
import org.apache.ignite.cache.query.QueryCursor;
import org.apache.ignite.cache.query.ScanQuery;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.compute.ComputeTaskFuture;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteClosure;
import org.apache.ignite.lang.IgniteFutureTimeoutException;
import org.apache.ignite.lang.IgniteRunnable;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBDatabase;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBIgnite;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBiFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBinaryOperator;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableSupplier;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducer;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.Kernels;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.OSHDBIgniteMapReduceComputeTask;
import org.heigit.bigspatialdata.oshdb.api.object.OSHDBMapReducible;
import org.heigit.bigspatialdata.oshdb.api.object.OSMContribution;
import org.heigit.bigspatialdata.oshdb.api.object.OSMEntitySnapshot;
import org.heigit.bigspatialdata.oshdb.grid.GridOSHEntity;
import org.heigit.bigspatialdata.oshdb.index.XYGridTree;
import org.heigit.bigspatialdata.oshdb.osm.OSMType;
import org.heigit.bigspatialdata.oshdb.util.CellId;
import org.heigit.bigspatialdata.oshdb.util.OSHDBBoundingBox;
import org.heigit.bigspatialdata.oshdb.util.OSHDBTimestamp;
import org.heigit.bigspatialdata.oshdb.util.TableNames;
import org.heigit.bigspatialdata.oshdb.util.celliterator.CellIterator;
import org.heigit.bigspatialdata.oshdb.util.exceptions.OSHDBTimeoutException;
import org.heigit.bigspatialdata.oshdb.util.taginterpreter.TagInterpreter;
import org.jetbrains.annotations.NotNull;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReducerIgniteScanQuery<X>
extends MapReducer<X> {
    private static final int SCAN_QUERY_PAGE_SIZE = 16;

    public MapReducerIgniteScanQuery(OSHDBDatabase oshdb, Class<? extends OSHDBMapReducible> forClass) {
        super(oshdb, forClass);
    }

    private MapReducerIgniteScanQuery(MapReducerIgniteScanQuery obj) {
        super(obj);
    }

    static boolean cellKeyInRange(Long cellKey, Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel) {
        CellId cellId = CellId.fromLevelId((long)cellKey);
        int level = cellId.getZoomLevel();
        long id = cellId.getId();
        if (!cellIdRangesByLevel.containsKey(level)) {
            return false;
        }
        Map.Entry<Long, XYGridTree.CellIdRange> cellIdRangeEntry = cellIdRangesByLevel.get(level).floorEntry(id);
        if (cellIdRangeEntry == null) {
            return false;
        }
        XYGridTree.CellIdRange cellIdRange = cellIdRangeEntry.getValue();
        return cellIdRange.getStart().getId() <= id && cellIdRange.getEnd().getId() >= id;
    }

    @Override
    @NotNull
    protected MapReducer<X> copy() {
        return new MapReducerIgniteScanQuery<X>(this);
    }

    @Override
    public boolean isCancelable() {
        return true;
    }

    @Override
    protected <R, S> S mapReduceCellsOSMContribution(SerializableFunction<OSMContribution, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return (S)this.typeFilter.stream().map((Function<OSMType, Object> & Serializable)osmType -> {
            String cacheName = ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix());
            return MapReducerIgniteScanQuery.mapReduceOnIgniteCache((OSHDBIgnite)this.oshdb, cacheName, identitySupplier, combiner, new MapReduceCellsOSMContributionOnIgniteCacheComputeJob(tagInterpreter, cacheName, this.getCellIdRangesByLevel(), (SortedSet<OSHDBTimestamp>)this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), this.getPreFilter(), this.getFilter(), mapper, identitySupplier, accumulator, combiner));
        }).reduce(identitySupplier.get(), combiner);
    }

    @Override
    protected <R, S> S flatMapReduceCellsOSMContributionGroupedById(SerializableFunction<List<OSMContribution>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return (S)this.typeFilter.stream().map((Function<OSMType, Object> & Serializable)osmType -> {
            String cacheName = ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix());
            return MapReducerIgniteScanQuery.mapReduceOnIgniteCache((OSHDBIgnite)this.oshdb, cacheName, identitySupplier, combiner, new FlatMapReduceCellsOSMContributionOnIgniteCacheComputeJob(tagInterpreter, cacheName, this.getCellIdRangesByLevel(), (SortedSet<OSHDBTimestamp>)this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), this.getPreFilter(), this.getFilter(), mapper, identitySupplier, accumulator, combiner));
        }).reduce(identitySupplier.get(), combiner);
    }

    @Override
    protected <R, S> S mapReduceCellsOSMEntitySnapshot(SerializableFunction<OSMEntitySnapshot, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return (S)this.typeFilter.stream().map((Function<OSMType, Object> & Serializable)osmType -> {
            String cacheName = ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix());
            return MapReducerIgniteScanQuery.mapReduceOnIgniteCache((OSHDBIgnite)this.oshdb, cacheName, identitySupplier, combiner, new MapReduceCellsOSMEntitySnapshotOnIgniteCacheComputeJob(tagInterpreter, cacheName, this.getCellIdRangesByLevel(), (SortedSet<OSHDBTimestamp>)this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), this.getPreFilter(), this.getFilter(), mapper, identitySupplier, accumulator, combiner));
        }).reduce(identitySupplier.get(), combiner);
    }

    @Override
    protected <R, S> S flatMapReduceCellsOSMEntitySnapshotGroupedById(SerializableFunction<List<OSMEntitySnapshot>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return (S)this.typeFilter.stream().map((Function<OSMType, Object> & Serializable)osmType -> {
            String cacheName = ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix());
            return MapReducerIgniteScanQuery.mapReduceOnIgniteCache((OSHDBIgnite)this.oshdb, cacheName, identitySupplier, combiner, new FlatMapReduceCellsOSMEntitySnapshotOnIgniteCacheComputeJob(tagInterpreter, cacheName, this.getCellIdRangesByLevel(), (SortedSet<OSHDBTimestamp>)this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), this.getPreFilter(), this.getFilter(), mapper, identitySupplier, accumulator, combiner));
        }).reduce(identitySupplier.get(), combiner);
    }

    @Override
    protected Stream<X> mapStreamCellsOSMContribution(SerializableFunction<OSMContribution, X> mapper) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return this.typeFilter.stream().map((Function<OSMType, Stream> & Serializable)osmType -> MapReducerIgniteScanQuery.mapStreamOnIgniteCache((OSHDBIgnite)this.oshdb, ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix()), this.getCellIdRangesByLevel(), new CellIterator(this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), tagInterpreter, this.getPreFilter(), this.getFilter(), false), Kernels.getOSMContributionCellStreamer(mapper))).flatMap((? super T x) -> x);
    }

    @Override
    protected Stream<X> flatMapStreamCellsOSMContributionGroupedById(SerializableFunction<List<OSMContribution>, Iterable<X>> mapper) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return this.typeFilter.stream().map((Function<OSMType, Stream> & Serializable)osmType -> MapReducerIgniteScanQuery.mapStreamOnIgniteCache((OSHDBIgnite)this.oshdb, ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix()), this.getCellIdRangesByLevel(), new CellIterator(this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), tagInterpreter, this.getPreFilter(), this.getFilter(), false), Kernels.getOSMContributionGroupingCellStreamer(mapper))).flatMap((? super T x) -> x);
    }

    @Override
    protected Stream<X> mapStreamCellsOSMEntitySnapshot(SerializableFunction<OSMEntitySnapshot, X> mapper) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return this.typeFilter.stream().map((Function<OSMType, Stream> & Serializable)osmType -> MapReducerIgniteScanQuery.mapStreamOnIgniteCache((OSHDBIgnite)this.oshdb, ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix()), this.getCellIdRangesByLevel(), new CellIterator(this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), tagInterpreter, this.getPreFilter(), this.getFilter(), false), Kernels.getOSMEntitySnapshotCellStreamer(mapper))).flatMap((? super T x) -> x);
    }

    @Override
    protected Stream<X> flatMapStreamCellsOSMEntitySnapshotGroupedById(SerializableFunction<List<OSMEntitySnapshot>, Iterable<X>> mapper) throws Exception {
        TagInterpreter tagInterpreter = this.getTagInterpreter();
        return this.typeFilter.stream().map((Function<OSMType, Stream> & Serializable)osmType -> MapReducerIgniteScanQuery.mapStreamOnIgniteCache((OSHDBIgnite)this.oshdb, ((TableNames)TableNames.forOSMType((OSMType)osmType).get()).toString(this.oshdb.prefix()), this.getCellIdRangesByLevel(), new CellIterator(this.tstamps.get(), this.bboxFilter, this.getPolyFilter(), tagInterpreter, this.getPreFilter(), this.getFilter(), false), Kernels.getOSMEntitySnapshotGroupingCellStreamer(mapper))).flatMap((? super T x) -> x);
    }

    private Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> getCellIdRangesByLevel() {
        HashMap<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel = new HashMap<Integer, TreeMap<Long, XYGridTree.CellIdRange>>();
        for (XYGridTree.CellIdRange cellIdRange : this.getCellIdRanges()) {
            int level = cellIdRange.getStart().getZoomLevel();
            if (!cellIdRangesByLevel.containsKey(level)) {
                cellIdRangesByLevel.put(level, new TreeMap());
            }
            ((TreeMap)cellIdRangesByLevel.get(level)).put(cellIdRange.getStart().getId(), cellIdRange);
        }
        return cellIdRangesByLevel;
    }

    private static <V, R, M, S, P extends Geometry> S mapReduceOnIgniteCache(OSHDBIgnite oshdb, String cacheName, SerializableSupplier<S> identitySupplier, SerializableBinaryOperator<S> combiner, MapReduceCellsOnIgniteCacheComputeJob<V, R, M, S, P> computeJob) {
        Object ret;
        Ignite ignite = oshdb.getIgnite();
        Affinity affinity = ignite.affinity(cacheName);
        ArrayList<Integer> allPartitions = new ArrayList<Integer>(affinity.partitions());
        for (int i = 0; i < affinity.partitions(); ++i) {
            allPartitions.add(i);
        }
        Map partPerNodes = affinity.mapPartitionsToNodes(allPartitions);
        HashMap<UUID, List<Integer>> nodesToPart = new HashMap<UUID, List<Integer>>();
        for (Map.Entry entry : partPerNodes.entrySet()) {
            List nodeParts = nodesToPart.computeIfAbsent(((ClusterNode)entry.getValue()).id(), k -> new ArrayList());
            nodeParts.add(entry.getKey());
        }
        IgniteCompute compute = ignite.compute(ignite.cluster().forNodeIds(nodesToPart.keySet()));
        computeJob.setNodesToPart(nodesToPart);
        IgniteRunnable onClose = oshdb.onClose().orElse((IgniteRunnable & Serializable)() -> {});
        ComputeTaskFuture result = compute.executeAsync(new OSHDBIgniteMapReduceComputeTask(computeJob, identitySupplier, combiner, onClose), null);
        if (!oshdb.timeoutInMilliseconds().isPresent()) {
            ret = result.get();
        } else {
            try {
                ret = result.get(oshdb.timeoutInMilliseconds().getAsLong());
            }
            catch (IgniteFutureTimeoutException e) {
                result.cancel();
                throw new OSHDBTimeoutException();
            }
        }
        return (S)ret;
    }

    private static <X> Stream<X> mapStreamOnIgniteCache(OSHDBIgnite oshdb, String cacheName, Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel, CellIterator cellIterator, Kernels.CellProcessor<Stream<X>> cellProcessor) {
        QueryCursor cursor = oshdb.getIgnite().cache(cacheName).withKeepBinary().query((Query)new ScanQuery((IgniteBiPredicate & Serializable)(key, cell) -> MapReducerIgniteScanQuery.cellKeyInRange(key, cellIdRangesByLevel)).setPageSize(16), (IgniteClosure & Serializable)cacheEntry -> {
            Object data = cacheEntry.getValue();
            GridOSHEntity oshEntityCell = data instanceof BinaryObject ? (GridOSHEntity)((BinaryObject)data).deserialize() : (GridOSHEntity)data;
            return ((Stream)cellProcessor.apply(oshEntityCell, cellIterator)).collect(Collectors.toList());
        });
        return ((Stream)Streams.stream((Iterable)cursor).onClose(() -> ((QueryCursor)cursor).close())).flatMap(Collection::stream);
    }

    private static class FlatMapReduceCellsOSMEntitySnapshotOnIgniteCacheComputeJob<R, S, P extends Geometry>
    extends MapReduceCellsOnIgniteCacheComputeJob<List<OSMEntitySnapshot>, R, Iterable<R>, S, P> {
        FlatMapReduceCellsOSMEntitySnapshotOnIgniteCacheComputeJob(TagInterpreter tagInterpreter, String cacheName, Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel, SortedSet<OSHDBTimestamp> tstamps, OSHDBBoundingBox bbox, P poly, CellIterator.OSHEntityFilter preFilter, CellIterator.OSMEntityFilter filter, SerializableFunction<List<OSMEntitySnapshot>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) {
            super(tagInterpreter, cacheName, cellIdRangesByLevel, tstamps, bbox, poly, preFilter, filter, mapper, identitySupplier, accumulator, combiner);
        }

        @Override
        public S execute(Ignite node) {
            return super.execute(node, Kernels.getOSMEntitySnapshotGroupingCellReducer(this.mapper, this.identitySupplier, this.accumulator, this));
        }
    }

    private static class MapReduceCellsOSMEntitySnapshotOnIgniteCacheComputeJob<R, S, P extends Geometry>
    extends MapReduceCellsOnIgniteCacheComputeJob<OSMEntitySnapshot, R, R, S, P> {
        MapReduceCellsOSMEntitySnapshotOnIgniteCacheComputeJob(TagInterpreter tagInterpreter, String cacheName, Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel, SortedSet<OSHDBTimestamp> tstamps, OSHDBBoundingBox bbox, P poly, CellIterator.OSHEntityFilter preFilter, CellIterator.OSMEntityFilter filter, SerializableFunction<OSMEntitySnapshot, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) {
            super(tagInterpreter, cacheName, cellIdRangesByLevel, tstamps, bbox, poly, preFilter, filter, mapper, identitySupplier, accumulator, combiner);
        }

        @Override
        public S execute(Ignite node) {
            return super.execute(node, Kernels.getOSMEntitySnapshotCellReducer(this.mapper, this.identitySupplier, this.accumulator, this));
        }
    }

    private static class FlatMapReduceCellsOSMContributionOnIgniteCacheComputeJob<R, S, P extends Geometry>
    extends MapReduceCellsOnIgniteCacheComputeJob<List<OSMContribution>, R, Iterable<R>, S, P> {
        FlatMapReduceCellsOSMContributionOnIgniteCacheComputeJob(TagInterpreter tagInterpreter, String cacheName, Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel, SortedSet<OSHDBTimestamp> tstamps, OSHDBBoundingBox bbox, P poly, CellIterator.OSHEntityFilter preFilter, CellIterator.OSMEntityFilter filter, SerializableFunction<List<OSMContribution>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) {
            super(tagInterpreter, cacheName, cellIdRangesByLevel, tstamps, bbox, poly, preFilter, filter, mapper, identitySupplier, accumulator, combiner);
        }

        @Override
        public S execute(Ignite node) {
            return super.execute(node, Kernels.getOSMContributionGroupingCellReducer(this.mapper, this.identitySupplier, this.accumulator, this));
        }
    }

    private static class MapReduceCellsOSMContributionOnIgniteCacheComputeJob<R, S, P extends Geometry>
    extends MapReduceCellsOnIgniteCacheComputeJob<OSMContribution, R, R, S, P> {
        MapReduceCellsOSMContributionOnIgniteCacheComputeJob(TagInterpreter tagInterpreter, String cacheName, Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel, SortedSet<OSHDBTimestamp> tstamps, OSHDBBoundingBox bbox, P poly, CellIterator.OSHEntityFilter preFilter, CellIterator.OSMEntityFilter filter, SerializableFunction<OSMContribution, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) {
            super(tagInterpreter, cacheName, cellIdRangesByLevel, tstamps, bbox, poly, preFilter, filter, mapper, identitySupplier, accumulator, combiner);
        }

        @Override
        public S execute(Ignite node) {
            return super.execute(node, Kernels.getOSMContributionCellReducer(this.mapper, this.identitySupplier, this.accumulator, this));
        }
    }

    private static abstract class MapReduceCellsOnIgniteCacheComputeJob<V, R, M, S, P extends Geometry>
    implements OSHDBIgniteMapReduceComputeTask.CancelableIgniteMapReduceJob<S> {
        private static final Logger LOG = LoggerFactory.getLogger(MapReduceCellsOnIgniteCacheComputeJob.class);
        private boolean notCanceled = true;
        Map<UUID, List<Integer>> nodesToPart;
        final String cacheName;
        final Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel;
        final CellIterator cellIterator;
        final SerializableFunction<V, M> mapper;
        final SerializableSupplier<S> identitySupplier;
        final SerializableBiFunction<S, R, S> accumulator;
        final SerializableBinaryOperator<S> combiner;

        @Override
        public void cancel() {
            LOG.info("compute job canceled");
            this.notCanceled = false;
        }

        @Override
        public boolean isActive() {
            return this.notCanceled;
        }

        MapReduceCellsOnIgniteCacheComputeJob(TagInterpreter tagInterpreter, String cacheName, Map<Integer, TreeMap<Long, XYGridTree.CellIdRange>> cellIdRangesByLevel, SortedSet<OSHDBTimestamp> tstamps, OSHDBBoundingBox bbox, P poly, CellIterator.OSHEntityFilter preFilter, CellIterator.OSMEntityFilter filter, SerializableFunction<V, M> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) {
            this.cacheName = cacheName;
            this.cellIdRangesByLevel = cellIdRangesByLevel;
            this.cellIterator = new CellIterator(tstamps, bbox, poly, tagInterpreter, preFilter, filter, false);
            this.mapper = mapper;
            this.identitySupplier = identitySupplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
        }

        void setNodesToPart(Map<UUID, List<Integer>> nodesToPart) {
            this.nodesToPart = nodesToPart;
        }

        boolean cellKeyInRange(Long cellKey) {
            return MapReducerIgniteScanQuery.cellKeyInRange(cellKey, this.cellIdRangesByLevel);
        }

        S execute(Ignite node, Kernels.CellProcessor<S> cellProcessor) {
            IgniteCache cache = node.cache(this.cacheName).withKeepBinary();
            List<Integer> myPartitions = this.nodesToPart.get(node.cluster().localNode().id());
            Collections.shuffle(myPartitions);
            return (S)myPartitions.parallelStream().filter(ignored -> this.isActive()).map(part -> {
                try (QueryCursor cursor = cache.query((Query)new ScanQuery((IgniteBiPredicate & Serializable)(key, cell) -> this.isActive() && this.cellKeyInRange((Long)key)).setPartition(part), (IgniteClosure & Serializable)cacheEntry -> {
                    if (!this.isActive()) {
                        return this.identitySupplier.get();
                    }
                    Object data = cacheEntry.getValue();
                    GridOSHEntity oshEntityCell = data instanceof BinaryObject ? (GridOSHEntity)((BinaryObject)data).deserialize() : (GridOSHEntity)data;
                    return cellProcessor.apply(oshEntityCell, this.cellIterator);
                });){
                    Object accExternal = this.identitySupplier.get();
                    for (Object entry : cursor) {
                        accExternal = this.combiner.apply(accExternal, entry);
                    }
                    Iterator<Object> iterator = accExternal;
                    return iterator;
                }
            }).reduce(this.identitySupplier.get(), this.combiner);
        }
    }
}

