/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.mapreducer.backend;

import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBiFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableSupplier;
import org.heigit.bigspatialdata.oshdb.api.object.OSMContribution;
import org.heigit.bigspatialdata.oshdb.api.object.OSMEntitySnapshot;
import org.heigit.bigspatialdata.oshdb.grid.GridOSHEntity;
import org.heigit.bigspatialdata.oshdb.util.celliterator.CellIterator;

class Kernels
implements Serializable {
    private static final CancelableProcessStatus NC = new NonCancelableProcessStatus();

    Kernels() {
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMContributionCellReducer(SerializableFunction<OSMContribution, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator) {
        return Kernels.getOSMContributionCellReducer(mapper, identitySupplier, accumulator, NC);
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMContributionCellReducer(SerializableFunction<OSMContribution, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> {
            AtomicReference accInternal = new AtomicReference(identitySupplier.get());
            cellIterator.iterateByContribution(oshEntityCell).filter(ignored -> process.isActive()).forEach(contribution -> {
                OSMContribution osmContribution = new OSMContribution((CellIterator.IterateAllEntry)contribution);
                accInternal.set(accumulator.apply(accInternal.get(), mapper.apply(osmContribution)));
            });
            return accInternal.get();
        };
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMContributionGroupingCellReducer(SerializableFunction<List<OSMContribution>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator) {
        return Kernels.getOSMContributionGroupingCellReducer(mapper, identitySupplier, accumulator, NC);
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMContributionGroupingCellReducer(SerializableFunction<List<OSMContribution>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> {
            AtomicReference accInternal = new AtomicReference(identitySupplier.get());
            ArrayList contributions = new ArrayList();
            cellIterator.iterateByContribution(oshEntityCell).filter(ignored -> process.isActive()).forEach(contribution -> {
                OSMContribution thisContribution = new OSMContribution((CellIterator.IterateAllEntry)contribution);
                if (contributions.size() > 0 && thisContribution.getEntityAfter().getId() != ((OSMContribution)contributions.get(contributions.size() - 1)).getEntityAfter().getId()) {
                    for (Object r : (Iterable)mapper.apply(contributions)) {
                        accInternal.set(accumulator.apply(accInternal.get(), r));
                    }
                    contributions.clear();
                }
                contributions.add(thisContribution);
            });
            if (contributions.size() > 0) {
                for (Object r : (Iterable)mapper.apply(contributions)) {
                    accInternal.set(accumulator.apply(accInternal.get(), r));
                }
            }
            return accInternal.get();
        };
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMEntitySnapshotCellReducer(SerializableFunction<OSMEntitySnapshot, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator) {
        return Kernels.getOSMEntitySnapshotCellReducer(mapper, identitySupplier, accumulator, NC);
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMEntitySnapshotCellReducer(SerializableFunction<OSMEntitySnapshot, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> {
            AtomicReference accInternal = new AtomicReference(identitySupplier.get());
            cellIterator.iterateByTimestamps(oshEntityCell).filter(ignored -> process.isActive()).forEach(data -> {
                OSMEntitySnapshot snapshot = new OSMEntitySnapshot((CellIterator.IterateByTimestampEntry)data);
                accInternal.set(accumulator.apply(accInternal.get(), mapper.apply(snapshot)));
            });
            return accInternal.get();
        };
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMEntitySnapshotGroupingCellReducer(SerializableFunction<List<OSMEntitySnapshot>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator) {
        return Kernels.getOSMEntitySnapshotGroupingCellReducer(mapper, identitySupplier, accumulator, NC);
    }

    @Nonnull
    static <R, S> CellProcessor<S> getOSMEntitySnapshotGroupingCellReducer(SerializableFunction<List<OSMEntitySnapshot>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> {
            AtomicReference accInternal = new AtomicReference(identitySupplier.get());
            ArrayList osmEntitySnapshots = new ArrayList();
            cellIterator.iterateByTimestamps(oshEntityCell).filter(ignored -> process.isActive()).forEach(data -> {
                OSMEntitySnapshot thisSnapshot = new OSMEntitySnapshot((CellIterator.IterateByTimestampEntry)data);
                if (osmEntitySnapshots.size() > 0 && thisSnapshot.getEntity().getId() != ((OSMEntitySnapshot)osmEntitySnapshots.get(osmEntitySnapshots.size() - 1)).getEntity().getId()) {
                    for (Object r : (Iterable)mapper.apply(osmEntitySnapshots)) {
                        accInternal.set(accumulator.apply(accInternal.get(), r));
                    }
                    osmEntitySnapshots.clear();
                }
                osmEntitySnapshots.add(thisSnapshot);
            });
            if (osmEntitySnapshots.size() > 0) {
                for (Object r : (Iterable)mapper.apply(osmEntitySnapshots)) {
                    accInternal.set(accumulator.apply(accInternal.get(), r));
                }
            }
            return accInternal.get();
        };
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMContributionCellStreamer(SerializableFunction<OSMContribution, S> mapper) {
        return Kernels.getOSMContributionCellStreamer(mapper, NC);
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMContributionCellStreamer(SerializableFunction<OSMContribution, S> mapper, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> cellIterator.iterateByContribution(oshEntityCell).filter(ignored -> process.isActive()).map(OSMContribution::new).map(mapper);
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMContributionGroupingCellStreamer(SerializableFunction<List<OSMContribution>, Iterable<S>> mapper) {
        return Kernels.getOSMContributionGroupingCellStreamer(mapper, NC);
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMContributionGroupingCellStreamer(SerializableFunction<List<OSMContribution>, Iterable<S>> mapper, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> {
            ArrayList contributions = new ArrayList();
            LinkedList result = new LinkedList();
            cellIterator.iterateByContribution(oshEntityCell).filter(ignored -> process.isActive()).map(OSMContribution::new).forEach(contribution -> {
                if (contributions.size() > 0 && contribution.getEntityAfter().getId() != ((OSMContribution)contributions.get(contributions.size() - 1)).getEntityAfter().getId()) {
                    Iterables.addAll((Collection)result, (Iterable)((Iterable)mapper.apply(contributions)));
                    contributions.clear();
                }
                contributions.add(contribution);
            });
            if (contributions.size() > 0) {
                Iterables.addAll(result, (Iterable)((Iterable)mapper.apply(contributions)));
            }
            return result.stream();
        };
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMEntitySnapshotCellStreamer(SerializableFunction<OSMEntitySnapshot, S> mapper) {
        return Kernels.getOSMEntitySnapshotCellStreamer(mapper, NC);
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMEntitySnapshotCellStreamer(SerializableFunction<OSMEntitySnapshot, S> mapper, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> cellIterator.iterateByTimestamps(oshEntityCell).filter(ignored -> process.isActive()).map(OSMEntitySnapshot::new).map(mapper);
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMEntitySnapshotGroupingCellStreamer(SerializableFunction<List<OSMEntitySnapshot>, Iterable<S>> mapper) {
        return Kernels.getOSMEntitySnapshotGroupingCellStreamer(mapper, NC);
    }

    @Nonnull
    static <S> CellProcessor<Stream<S>> getOSMEntitySnapshotGroupingCellStreamer(SerializableFunction<List<OSMEntitySnapshot>, Iterable<S>> mapper, CancelableProcessStatus process) {
        return (oshEntityCell, cellIterator) -> {
            ArrayList snapshots = new ArrayList();
            LinkedList result = new LinkedList();
            cellIterator.iterateByTimestamps(oshEntityCell).filter(ignored -> process.isActive()).map(OSMEntitySnapshot::new).forEach(contribution -> {
                if (snapshots.size() > 0 && contribution.getEntity().getId() != ((OSMEntitySnapshot)snapshots.get(snapshots.size() - 1)).getEntity().getId()) {
                    Iterables.addAll((Collection)result, (Iterable)((Iterable)mapper.apply(snapshots)));
                    snapshots.clear();
                }
                snapshots.add(contribution);
            });
            if (snapshots.size() > 0) {
                Iterables.addAll(result, (Iterable)((Iterable)mapper.apply(snapshots)));
            }
            return result.stream();
        };
    }

    private static class NonCancelableProcessStatus
    implements CancelableProcessStatus,
    Serializable {
        private NonCancelableProcessStatus() {
        }

        @Override
        public boolean isActive() {
            return true;
        }
    }

    static interface CancelableProcessStatus {
        public boolean isActive();
    }

    static interface CellProcessor<S>
    extends SerializableBiFunction<GridOSHEntity, CellIterator, S> {
    }
}

