/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.mapreducer;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.tdunning.math.stats.TDigest;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.DoubleUnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBDatabase;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBJdbc;
import org.heigit.bigspatialdata.oshdb.api.generic.NumberUtils;
import org.heigit.bigspatialdata.oshdb.api.generic.WeightedValue;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBiFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBinaryOperator;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableConsumer;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializablePredicate;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableSupplier;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.GeometrySplitter;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapAggregatable;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapAggregator;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapFunction;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducerAggregations;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducerSettings;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.Mappable;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.PayloadWithWeight;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.TDigestReducer;
import org.heigit.bigspatialdata.oshdb.api.object.OSHDBMapReducible;
import org.heigit.bigspatialdata.oshdb.api.object.OSMContribution;
import org.heigit.bigspatialdata.oshdb.api.object.OSMEntitySnapshot;
import org.heigit.bigspatialdata.oshdb.index.XYGridTree;
import org.heigit.bigspatialdata.oshdb.osh.OSHEntity;
import org.heigit.bigspatialdata.oshdb.osm.OSMEntity;
import org.heigit.bigspatialdata.oshdb.osm.OSMType;
import org.heigit.bigspatialdata.oshdb.util.OSHDBBoundingBox;
import org.heigit.bigspatialdata.oshdb.util.OSHDBTag;
import org.heigit.bigspatialdata.oshdb.util.OSHDBTagKey;
import org.heigit.bigspatialdata.oshdb.util.OSHDBTimestamp;
import org.heigit.bigspatialdata.oshdb.util.celliterator.CellIterator;
import org.heigit.bigspatialdata.oshdb.util.exceptions.OSHDBInvalidTimestampException;
import org.heigit.bigspatialdata.oshdb.util.exceptions.OSHDBKeytablesNotFoundException;
import org.heigit.bigspatialdata.oshdb.util.geometry.Geo;
import org.heigit.bigspatialdata.oshdb.util.geometry.OSHDBGeometryBuilder;
import org.heigit.bigspatialdata.oshdb.util.taginterpreter.DefaultTagInterpreter;
import org.heigit.bigspatialdata.oshdb.util.taginterpreter.TagInterpreter;
import org.heigit.bigspatialdata.oshdb.util.tagtranslator.OSMTag;
import org.heigit.bigspatialdata.oshdb.util.tagtranslator.OSMTagInterface;
import org.heigit.bigspatialdata.oshdb.util.tagtranslator.OSMTagKey;
import org.heigit.bigspatialdata.oshdb.util.tagtranslator.TagTranslator;
import org.heigit.bigspatialdata.oshdb.util.time.ISODateTimeParser;
import org.heigit.bigspatialdata.oshdb.util.time.OSHDBTimestampList;
import org.heigit.bigspatialdata.oshdb.util.time.OSHDBTimestamps;
import org.heigit.bigspatialdata.oshdb.util.time.TimestampFormatter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.json.simple.parser.ParseException;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MapReducer<X>
implements MapReducerSettings<MapReducer<X>>,
Mappable<X>,
MapReducerAggregations<X>,
MapAggregatable<MapAggregator<? extends Comparable<?>, X>, X>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MapReducer.class);
    protected OSHDBDatabase oshdb;
    protected transient OSHDBJdbc keytables;
    protected Long timeout = null;
    Class<? extends OSHDBMapReducible> forClass;
    Grouping grouping = Grouping.NONE;
    private transient TagTranslator tagTranslator = null;
    private TagInterpreter tagInterpreter = null;
    protected OSHDBTimestampList tstamps = new OSHDBTimestamps("2008-01-01", TimestampFormatter.getInstance().date(new Date()), OSHDBTimestamps.Interval.MONTHLY);
    protected OSHDBBoundingBox bboxFilter = new OSHDBBoundingBox(-180, -90, 180, 90);
    private Geometry polyFilter = null;
    protected EnumSet<OSMType> typeFilter = EnumSet.of(OSMType.NODE, OSMType.WAY, OSMType.RELATION);
    private final List<SerializablePredicate<OSHEntity>> preFilters = new ArrayList<SerializablePredicate<OSHEntity>>();
    private final List<SerializablePredicate<OSMEntity>> filters = new ArrayList<SerializablePredicate<OSMEntity>>();
    final List<MapFunction> mappers = new LinkedList<MapFunction>();

    public boolean isCancelable() {
        return false;
    }

    protected MapReducer(OSHDBDatabase oshdb, Class<? extends OSHDBMapReducible> forClass) {
        this.oshdb = oshdb;
        this.forClass = forClass;
    }

    protected MapReducer(MapReducer<?> obj) {
        this.oshdb = obj.oshdb;
        this.keytables = obj.keytables;
        this.forClass = obj.forClass;
        this.grouping = obj.grouping;
        this.tagTranslator = obj.tagTranslator;
        this.tagInterpreter = obj.tagInterpreter;
        this.tstamps = obj.tstamps;
        this.bboxFilter = obj.bboxFilter;
        this.polyFilter = obj.polyFilter;
        this.typeFilter = obj.typeFilter.clone();
        this.preFilters.addAll(obj.preFilters);
        this.filters.addAll(obj.filters);
        this.mappers.addAll(obj.mappers);
    }

    @NotNull
    protected abstract MapReducer<X> copy();

    @Contract(pure=true)
    public MapReducer<X> keytables(OSHDBJdbc keytables) {
        if (keytables != this.oshdb && this.oshdb instanceof OSHDBJdbc) {
            Connection c = ((OSHDBJdbc)this.oshdb).getConnection();
            boolean oshdbContainsKeytables = true;
            try {
                new TagTranslator(c);
            }
            catch (OSHDBKeytablesNotFoundException e) {
                oshdbContainsKeytables = false;
            }
            if (oshdbContainsKeytables) {
                LOG.warn("It looks like as if the current OSHDB comes with keytables included. Usually this means that you should use this file's keytables and should not set the keytables manually.");
            }
        }
        MapReducer<X> ret = this.copy();
        ret.keytables = keytables;
        return ret;
    }

    @Contract(pure=true)
    public MapReducer<X> tagInterpreter(TagInterpreter tagInterpreter) {
        MapReducer<X> ret = this.copy();
        ret.tagInterpreter = tagInterpreter;
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> areaOfInterest(@NotNull OSHDBBoundingBox bboxFilter) {
        MapReducer<X> ret = this.copy();
        if (this.polyFilter == null) {
            ret.bboxFilter = OSHDBBoundingBox.intersect((OSHDBBoundingBox)bboxFilter, (OSHDBBoundingBox)ret.bboxFilter);
        } else {
            ret.polyFilter = Geo.clip((Geometry)ret.polyFilter, (OSHDBBoundingBox)bboxFilter);
            ret.bboxFilter = OSHDBGeometryBuilder.boundingBoxOf((Envelope)ret.polyFilter.getEnvelopeInternal());
        }
        return ret;
    }

    @Override
    @Contract(pure=true)
    public <P extends Geometry> MapReducer<X> areaOfInterest(@NotNull P polygonFilter) {
        MapReducer<X> ret = this.copy();
        ret.polyFilter = this.polyFilter == null ? Geo.clip(polygonFilter, (OSHDBBoundingBox)ret.bboxFilter) : Geo.clip(polygonFilter, ret.getPolyFilter());
        ret.bboxFilter = OSHDBGeometryBuilder.boundingBoxOf((Envelope)ret.polyFilter.getEnvelopeInternal());
        return ret;
    }

    @Contract(pure=true)
    public MapReducer<X> timestamps(OSHDBTimestampList tstamps) {
        MapReducer<X> ret = this.copy();
        ret.tstamps = tstamps;
        return ret;
    }

    @Contract(pure=true)
    public MapReducer<X> timestamps(String isoDateStart, String isoDateEnd, OSHDBTimestamps.Interval interval) {
        return this.timestamps((OSHDBTimestampList)new OSHDBTimestamps(isoDateStart, isoDateEnd, interval));
    }

    @Contract(pure=true)
    public MapReducer<X> timestamps(String isoDate) {
        if (this.forClass.equals(OSMContribution.class)) {
            LOG.warn("OSMContributionView requires two or more timestamps, but only one was supplied.");
        }
        return this.timestamps(isoDate, isoDate, new String[0]);
    }

    @Contract(pure=true)
    public MapReducer<X> timestamps(String isoDateStart, String isoDateEnd) {
        return this.timestamps(isoDateStart, isoDateEnd, new String[0]);
    }

    @Contract(pure=true)
    public MapReducer<X> timestamps(String isoDateFirst, String isoDateSecond, String ... isoDateMore) {
        TreeSet<OSHDBTimestamp> timestamps = new TreeSet<OSHDBTimestamp>();
        try {
            timestamps.add(new OSHDBTimestamp(ISODateTimeParser.parseISODateTime((String)isoDateFirst).toEpochSecond()));
            timestamps.add(new OSHDBTimestamp(ISODateTimeParser.parseISODateTime((String)isoDateSecond).toEpochSecond()));
            for (String isoDate : isoDateMore) {
                timestamps.add(new OSHDBTimestamp(ISODateTimeParser.parseISODateTime((String)isoDate).toEpochSecond()));
            }
        }
        catch (Exception e) {
            LOG.error("unable to parse ISO date string: " + e.getMessage());
        }
        return this.timestamps((OSHDBTimestampList & Serializable)() -> timestamps);
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmType(Set<OSMType> typeFilter) {
        MapReducer<X> ret = this.copy();
        ret.typeFilter = (typeFilter = Sets.intersection(ret.typeFilter, typeFilter)).isEmpty() ? EnumSet.noneOf(OSMType.class) : EnumSet.copyOf(typeFilter);
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmEntityFilter(SerializablePredicate<OSMEntity> f) {
        MapReducer<X> ret = this.copy();
        ret.filters.add(f);
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmTag(String key) {
        return this.osmTag(new OSMTagKey(key));
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmTag(OSMTagInterface tag) {
        if (tag instanceof OSMTag) {
            return this.osmTag((OSMTag)tag);
        }
        if (tag instanceof OSMTagKey) {
            return this.osmTag((OSMTagKey)tag);
        }
        throw new UnsupportedOperationException("Unknown object implementing OSMTagInterface.");
    }

    @Contract(pure=true)
    private MapReducer<X> osmTag(OSMTagKey key) {
        MapReducer<X> ret = this.copy();
        OSHDBTagKey keyId = this.getTagTranslator().getOSHDBTagKeyOf(key);
        if (!keyId.isPresentInKeytables()) {
            LOG.warn("Tag key {} not found. No data will match this filter.", (Object)key.toString());
            ret.preFilters.add(ignored -> false);
            ret.filters.add(ignored -> false);
            return ret;
        }
        ret.preFilters.add(oshEntitiy -> oshEntitiy.hasTagKey(keyId));
        ret.filters.add(osmEntity -> osmEntity.hasTagKey(keyId));
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmTag(String key, String value) {
        return this.osmTag(new OSMTag(key, value));
    }

    @Contract(pure=true)
    private MapReducer<X> osmTag(OSMTag tag) {
        MapReducer<X> ret = this.copy();
        OSHDBTag keyValueId = this.getTagTranslator().getOSHDBTagOf(tag);
        if (!keyValueId.isPresentInKeytables()) {
            LOG.warn("Tag {}={} not found. No data will match this filter.", (Object)tag.getKey(), (Object)tag.getValue());
            ret.preFilters.add(ignored -> false);
            ret.filters.add(ignored -> false);
            return ret;
        }
        OSHDBTagKey keyId = new OSHDBTagKey(keyValueId.getKey());
        ret.preFilters.add(oshEntitiy -> oshEntitiy.hasTagKey(keyId));
        ret.filters.add(osmEntity -> osmEntity.hasTagValue(keyValueId.getKey(), keyValueId.getValue()));
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmTag(String key, Collection<String> values) {
        MapReducer<X> ret = this.copy();
        OSHDBTagKey oshdbKey = this.getTagTranslator().getOSHDBTagKeyOf(key);
        int keyId = oshdbKey.toInt();
        if (!oshdbKey.isPresentInKeytables() || values.size() == 0) {
            LOG.warn((values.size() > 0 ? "Tag key {} not found." : "Empty tag value list.") + " No data will match this filter.", (Object)key);
            ret.preFilters.add(ignored -> false);
            ret.filters.add(ignored -> false);
            return ret;
        }
        HashSet<Integer> valueIds = new HashSet<Integer>();
        for (String value : values) {
            OSHDBTag keyValueId = this.getTagTranslator().getOSHDBTagOf(key, value);
            if (!keyValueId.isPresentInKeytables()) {
                LOG.warn("Tag {}={} not found. No data will match this tag value.", (Object)key, (Object)value);
                continue;
            }
            valueIds.add(keyValueId.getValue());
        }
        ret.preFilters.add(oshEntitiy -> oshEntitiy.hasTagKey(keyId));
        ret.filters.add(osmEntity -> {
            int[] tags = osmEntity.getRawTags();
            for (int i = 0; i < tags.length && tags[i] <= keyId; i += 2) {
                if (tags[i] != keyId) continue;
                return valueIds.contains(tags[i + 1]);
            }
            return false;
        });
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmTag(String key, Pattern valuePattern) {
        MapReducer<X> ret = this.copy();
        OSHDBTagKey oshdbKey = this.getTagTranslator().getOSHDBTagKeyOf(key);
        int keyId = oshdbKey.toInt();
        if (!oshdbKey.isPresentInKeytables()) {
            LOG.warn("Tag key {} not found. No data will match this filter.", (Object)key);
            ret.preFilters.add(ignored -> false);
            ret.filters.add(ignored -> false);
            return ret;
        }
        ret.preFilters.add(oshEntitiy -> oshEntitiy.hasTagKey(keyId));
        ret.filters.add(osmEntity -> {
            int[] tags = osmEntity.getRawTags();
            for (int i = 0; i < tags.length; i += 2) {
                if (tags[i] > keyId) {
                    return false;
                }
                if (tags[i] != keyId) continue;
                String value = this.getTagTranslator().getOSMTagOf(keyId, tags[i + 1]).getValue();
                return valuePattern.matcher(value).matches();
            }
            return false;
        });
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> osmTag(Collection<? extends OSMTagInterface> tags) {
        MapReducer<X> ret = this.copy();
        if (tags.isEmpty()) {
            LOG.warn("Empty tag list. No data will match this filter.");
            ret.preFilters.add(ignored -> false);
            ret.filters.add(ignored -> false);
            return ret;
        }
        HashSet<Integer> preKeyIds = new HashSet<Integer>();
        HashSet<Integer> keyIds = new HashSet<Integer>();
        HashSet<OSHDBTag> keyValueIds = new HashSet<OSHDBTag>();
        for (OSMTagInterface oSMTagInterface : tags) {
            if (oSMTagInterface instanceof OSMTag) {
                OSMTag keyValue = (OSMTag)oSMTagInterface;
                OSHDBTag keyValueId = this.getTagTranslator().getOSHDBTagOf(keyValue);
                if (!keyValueId.isPresentInKeytables()) {
                    LOG.warn("Tag {}={} not found. No data will match this tag value.", (Object)keyValue.getKey(), (Object)keyValue.getValue());
                    continue;
                }
                preKeyIds.add(keyValueId.getKey());
                keyValueIds.add(keyValueId);
                continue;
            }
            OSHDBTagKey keyId = this.getTagTranslator().getOSHDBTagKeyOf((OSMTagKey)oSMTagInterface);
            preKeyIds.add(keyId.toInt());
            keyIds.add(keyId.toInt());
        }
        ret.preFilters.add(oshEntitiy -> {
            for (int key : oshEntitiy.getRawTagKeys()) {
                if (!preKeyIds.contains(key)) continue;
                return true;
            }
            return false;
        });
        ret.filters.add(osmEntity -> {
            for (OSHDBTag oshdbTag : osmEntity.getTags()) {
                if (!keyIds.contains(oshdbTag.getKey()) && !keyValueIds.contains(oshdbTag)) continue;
                return true;
            }
            return false;
        });
        return ret;
    }

    @Override
    @Contract(pure=true)
    public <R> MapReducer<R> map(SerializableFunction<X, R> mapper) {
        MapReducer<X> ret = this.copy();
        ret.mappers.add(new MapFunction(mapper, false));
        return ret;
    }

    @Override
    @Contract(pure=true)
    public <R> MapReducer<R> flatMap(SerializableFunction<X, Iterable<R>> flatMapper) {
        MapReducer<X> ret = this.copy();
        ret.mappers.add(new MapFunction(flatMapper, true));
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapReducer<X> filter(SerializablePredicate<X> f) {
        return this.flatMap(data -> f.test(data) ? Collections.singletonList(data) : Collections.emptyList());
    }

    @Contract(pure=true)
    public MapReducer<List<X>> groupByEntity() throws UnsupportedOperationException {
        if (!this.mappers.isEmpty()) {
            throw new UnsupportedOperationException("groupByEntity() must be called before any `map` or `flatMap` transformation functions have been set");
        }
        if (this.grouping != Grouping.NONE) {
            throw new UnsupportedOperationException("A grouping is already active on this MapReducer");
        }
        MapReducer<List<X>> ret = this.copy();
        ret.grouping = Grouping.BY_ID;
        return ret;
    }

    @Contract(pure=true)
    public <U extends Comparable<U> & Serializable> MapAggregator<U, X> aggregateBy(SerializableFunction<X, U> indexer, Collection<U> zerofill) {
        return new MapAggregator<U, X>(this, indexer, zerofill);
    }

    @Override
    @Contract(pure=true)
    public <U extends Comparable<U> & Serializable> MapAggregator<U, X> aggregateBy(SerializableFunction<X, U> indexer) {
        return this.aggregateBy(indexer, Collections.emptyList());
    }

    @Contract(pure=true)
    public MapAggregator<OSHDBTimestamp, X> aggregateByTimestamp() throws UnsupportedOperationException {
        SerializableFunction indexer;
        if (this.grouping != Grouping.NONE) {
            throw new UnsupportedOperationException("automatic aggregateByTimestamp() cannot be used together with the groupByEntity() functionality -> try using aggregateByTimestamp(customTimestampIndex) instead");
        }
        if (this.forClass.equals(OSMContribution.class)) {
            TreeSet timestamps = new TreeSet(this.tstamps.get());
            indexer = data -> timestamps.floor(((OSMContribution)data).getTimestamp());
        } else if (this.forClass.equals(OSMEntitySnapshot.class)) {
            indexer = data -> ((OSMEntitySnapshot)data).getTimestamp();
        } else {
            throw new UnsupportedOperationException("automatic aggregateByTimestamp() only implemented for OSMContribution and OSMEntitySnapshot -> try using aggregateByTimestamp(customTimestampIndex) instead");
        }
        if (this.mappers.size() > 0) {
            MapReducer<X> ret = this.copy();
            LinkedList<MapFunction> mappers = new LinkedList<MapFunction>(ret.mappers);
            ret.mappers.clear();
            Mappable mapAggregator = new MapAggregator<OSHDBTimestamp, X>(ret, indexer, this.getZerofillTimestamps());
            for (MapFunction action : mappers) {
                if (action.isFlatMapper()) {
                    mapAggregator = mapAggregator.flatMap((SerializableFunction)action);
                    continue;
                }
                mapAggregator = mapAggregator.map((SerializableFunction)action);
            }
            return mapAggregator;
        }
        return new MapAggregator(this, indexer, this.getZerofillTimestamps());
    }

    public MapAggregator<OSHDBTimestamp, X> aggregateByTimestamp(SerializableFunction<X, OSHDBTimestamp> indexer) throws UnsupportedOperationException {
        TreeSet timestamps = new TreeSet(this.tstamps.get());
        OSHDBTimestamp minTime = (OSHDBTimestamp)timestamps.first();
        OSHDBTimestamp maxTime = (OSHDBTimestamp)timestamps.last();
        return new MapAggregator(this, data -> {
            OSHDBTimestamp aggregationTimestamp = (OSHDBTimestamp)indexer.apply(data);
            if (aggregationTimestamp == null || aggregationTimestamp.compareTo(minTime) < 0 || aggregationTimestamp.compareTo(maxTime) > 0) {
                throw new OSHDBInvalidTimestampException("Aggregation timestamp outside of time query interval.");
            }
            return timestamps.floor(aggregationTimestamp);
        }, this.getZerofillTimestamps());
    }

    @Contract(pure=true)
    public <U extends Comparable<U> & Serializable, P extends Geometry> MapAggregator<U, X> aggregateByGeometry(Map<U, P> geometries) throws UnsupportedOperationException {
        Mappable ret;
        if (this.grouping != Grouping.NONE) {
            throw new UnsupportedOperationException("aggregateByGeometry() cannot be used together with the groupByEntity() functionality");
        }
        GeometrySplitter gs = new GeometrySplitter(geometries);
        if (this.mappers.size() > 0) {
            throw new UnsupportedOperationException("please call aggregateByGeometry before setting any map or flatMap functions");
        }
        if (this.forClass.equals(OSMContribution.class)) {
            ret = ((MapReducer)this.flatMap(x -> gs.splitOSMContribution((OSMContribution)x).entrySet())).aggregateBy(Map.Entry::getKey, geometries.keySet()).map(Map.Entry::getValue);
        } else if (this.forClass.equals(OSMEntitySnapshot.class)) {
            ret = ((MapReducer)this.flatMap(x -> gs.splitOSMEntitySnapshot((OSMEntitySnapshot)x).entrySet())).aggregateBy(Map.Entry::getKey, geometries.keySet()).map(Map.Entry::getValue);
        } else {
            throw new UnsupportedOperationException("aggregateByGeometry not implemented for objects of type: " + this.forClass.toString());
        }
        return ret;
    }

    @Override
    @Contract(pure=true)
    public <S> S reduce(SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, X, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        this.checkTimeout();
        switch (this.grouping) {
            case NONE: {
                if (this.mappers.stream().noneMatch(MapFunction::isFlatMapper)) {
                    SerializableFunction mapper = this.getMapper();
                    if (this.forClass.equals(OSMContribution.class)) {
                        SerializableFunction contributionMapper = data -> mapper.apply(data);
                        return this.mapReduceCellsOSMContribution(contributionMapper, identitySupplier, accumulator, combiner);
                    }
                    if (this.forClass.equals(OSMEntitySnapshot.class)) {
                        SerializableFunction snapshotMapper = data -> mapper.apply(data);
                        return this.mapReduceCellsOSMEntitySnapshot(snapshotMapper, identitySupplier, accumulator, combiner);
                    }
                    throw new UnsupportedOperationException("Unimplemented data view: " + this.forClass.toString());
                }
                SerializableFunction flatMapper = this.getFlatMapper();
                if (this.forClass.equals(OSMContribution.class)) {
                    return this.flatMapReduceCellsOSMContributionGroupedById(inputList -> {
                        LinkedList outputList = new LinkedList();
                        inputList.stream().map(flatMapper::apply).forEach((? super T data) -> Iterables.addAll((Collection)outputList, (Iterable)data));
                        return outputList;
                    }, identitySupplier, accumulator, combiner);
                }
                if (this.forClass.equals(OSMEntitySnapshot.class)) {
                    return this.flatMapReduceCellsOSMEntitySnapshotGroupedById(inputList -> {
                        LinkedList outputList = new LinkedList();
                        inputList.stream().map(flatMapper::apply).forEach((? super T data) -> Iterables.addAll((Collection)outputList, (Iterable)data));
                        return outputList;
                    }, identitySupplier, accumulator, combiner);
                }
                throw new UnsupportedOperationException("Unimplemented data view: " + this.forClass.toString());
            }
            case BY_ID: {
                SerializableFunction flatMapper;
                if (this.mappers.stream().noneMatch(MapFunction::isFlatMapper)) {
                    SerializableFunction mapper = this.getMapper();
                    flatMapper = data -> Collections.singletonList(mapper.apply(data));
                } else {
                    flatMapper = this.getFlatMapper();
                }
                if (this.forClass.equals(OSMContribution.class)) {
                    SerializableFunction contributionFlatMapper = data -> (Iterable)flatMapper.apply(data);
                    return this.flatMapReduceCellsOSMContributionGroupedById(contributionFlatMapper, identitySupplier, accumulator, combiner);
                }
                if (this.forClass.equals(OSMEntitySnapshot.class)) {
                    SerializableFunction snapshotFlatMapper = data -> (Iterable)flatMapper.apply(data);
                    return this.flatMapReduceCellsOSMEntitySnapshotGroupedById(snapshotFlatMapper, identitySupplier, accumulator, combiner);
                }
                throw new UnsupportedOperationException("Unimplemented data view: " + this.forClass.toString());
            }
        }
        throw new UnsupportedOperationException("Unsupported grouping: " + this.grouping.toString());
    }

    @Override
    @Contract(pure=true)
    public X reduce(SerializableSupplier<X> identitySupplier, SerializableBinaryOperator<X> accumulator) throws Exception {
        return this.reduce(identitySupplier, accumulator::apply, accumulator);
    }

    @Override
    @Contract(pure=true)
    public Number sum() throws Exception {
        return this.makeNumeric().reduce(() -> 0, NumberUtils::add);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> R sum(SerializableFunction<X, R> mapper) throws Exception {
        return (R)((Number)((MapReducer)this.map((SerializableFunction)mapper)).reduce(() -> 0, NumberUtils::add));
    }

    @Override
    @Contract(pure=true)
    public Integer count() throws Exception {
        return (Integer)this.sum(ignored -> 1);
    }

    @Override
    @Contract(pure=true)
    public Set<X> uniq() throws Exception {
        return (Set)this.reduce(MapReducer::uniqIdentitySupplier, MapReducer::uniqAccumulator, MapReducer::uniqCombiner);
    }

    @Override
    @Contract(pure=true)
    public <R> Set<R> uniq(SerializableFunction<X, R> mapper) throws Exception {
        return ((MapReducer)this.map((SerializableFunction)mapper)).uniq();
    }

    @Override
    @Contract(pure=true)
    public Integer countUniq() throws Exception {
        return this.uniq().size();
    }

    @Override
    @Contract(pure=true)
    public Double average() throws Exception {
        return this.makeNumeric().average(n -> n);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> Double average(SerializableFunction<X, R> mapper) throws Exception {
        return this.weightedAverage(data -> new WeightedValue<Number>((Number)mapper.apply(data), 1.0));
    }

    @Override
    @Contract(pure=true)
    public Double weightedAverage(SerializableFunction<X, WeightedValue> mapper) throws Exception {
        PayloadWithWeight runningSums = (PayloadWithWeight)((MapReducer)this.map(mapper)).reduce(PayloadWithWeight::identitySupplier, PayloadWithWeight::accumulator, PayloadWithWeight::combiner);
        return (Double)runningSums.num / runningSums.weight;
    }

    @Override
    @Contract(pure=true)
    public Double estimatedMedian() throws Exception {
        return this.estimatedQuantile(0.5);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> Double estimatedMedian(SerializableFunction<X, R> mapper) throws Exception {
        return this.estimatedQuantile((SerializableFunction)mapper, 0.5);
    }

    @Override
    @Contract(pure=true)
    public Double estimatedQuantile(double q) throws Exception {
        return this.makeNumeric().estimatedQuantile(n -> n, q);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> Double estimatedQuantile(SerializableFunction<X, R> mapper, double q) throws Exception {
        return this.estimatedQuantiles((SerializableFunction)mapper).applyAsDouble(q);
    }

    @Override
    @Contract(pure=true)
    public List<Double> estimatedQuantiles(Iterable<Double> q) throws Exception {
        return this.makeNumeric().estimatedQuantiles(n -> n, (Iterable)q);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> List<Double> estimatedQuantiles(SerializableFunction<X, R> mapper, Iterable<Double> q) throws Exception {
        return Streams.stream(q).mapToDouble(Double::doubleValue).map((DoubleUnaryOperator)this.estimatedQuantiles((SerializableFunction)mapper)).boxed().collect(Collectors.toList());
    }

    @Override
    @Contract(pure=true)
    public DoubleUnaryOperator estimatedQuantiles() throws Exception {
        return this.makeNumeric().estimatedQuantiles(n -> n);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> DoubleUnaryOperator estimatedQuantiles(SerializableFunction<X, R> mapper) throws Exception {
        TDigest digest = this.digest(mapper);
        return arg_0 -> ((TDigest)digest).quantile(arg_0);
    }

    @Contract(pure=true)
    private <R extends Number> TDigest digest(SerializableFunction<X, R> mapper) throws Exception {
        return (TDigest)((MapReducer)this.map((SerializableFunction)mapper)).reduce(TDigestReducer::identitySupplier, TDigestReducer::accumulator, TDigestReducer::combiner);
    }

    @Deprecated
    public void forEach(SerializableConsumer<X> action) throws Exception {
        ((MapReducer)this.map(data -> {
            action.accept(data);
            return null;
        })).reduce(() -> null, (ignored, ignored2) -> null);
    }

    @Override
    @Contract(pure=true)
    public List<X> collect() throws Exception {
        return (List)this.reduce(MapReducer::collectIdentitySupplier, MapReducer::collectAccumulator, MapReducer::collectCombiner);
    }

    @Override
    @Contract(pure=true)
    public Stream<X> stream() throws Exception {
        try {
            return this.streamInternal();
        }
        catch (UnsupportedOperationException e) {
            LOG.info("stream not directly supported by chosen backend, falling back to .collect().stream()");
            return this.collect().stream();
        }
    }

    @Contract(pure=true)
    private Stream<X> streamInternal() throws Exception {
        this.checkTimeout();
        switch (this.grouping) {
            case NONE: {
                if (this.mappers.stream().noneMatch(MapFunction::isFlatMapper)) {
                    SerializableFunction mapper = this.getMapper();
                    if (this.forClass.equals(OSMContribution.class)) {
                        SerializableFunction contributionMapper = data -> mapper.apply(data);
                        return this.mapStreamCellsOSMContribution(contributionMapper);
                    }
                    if (this.forClass.equals(OSMEntitySnapshot.class)) {
                        SerializableFunction snapshotMapper = data -> mapper.apply(data);
                        return this.mapStreamCellsOSMEntitySnapshot(snapshotMapper);
                    }
                    throw new UnsupportedOperationException("Unimplemented data view: " + this.forClass.toString());
                }
                SerializableFunction flatMapper = this.getFlatMapper();
                if (this.forClass.equals(OSMContribution.class)) {
                    return this.flatMapStreamCellsOSMContributionGroupedById(inputList -> {
                        LinkedList outputList = new LinkedList();
                        inputList.stream().map(flatMapper::apply).forEach((? super T data) -> Iterables.addAll((Collection)outputList, (Iterable)data));
                        return outputList;
                    });
                }
                if (this.forClass.equals(OSMEntitySnapshot.class)) {
                    return this.flatMapStreamCellsOSMEntitySnapshotGroupedById(inputList -> {
                        LinkedList outputList = new LinkedList();
                        inputList.stream().map(flatMapper::apply).forEach((? super T data) -> Iterables.addAll((Collection)outputList, (Iterable)data));
                        return outputList;
                    });
                }
                throw new UnsupportedOperationException("Unimplemented data view: " + this.forClass.toString());
            }
            case BY_ID: {
                SerializableFunction flatMapper;
                if (this.mappers.stream().noneMatch(MapFunction::isFlatMapper)) {
                    SerializableFunction mapper = this.getMapper();
                    flatMapper = data -> Collections.singletonList(mapper.apply(data));
                } else {
                    flatMapper = this.getFlatMapper();
                }
                if (this.forClass.equals(OSMContribution.class)) {
                    SerializableFunction contributionFlatMapper = data -> (Iterable)flatMapper.apply(data);
                    return this.flatMapStreamCellsOSMContributionGroupedById(contributionFlatMapper);
                }
                if (this.forClass.equals(OSMEntitySnapshot.class)) {
                    SerializableFunction snapshotFlatMapper = data -> (Iterable)flatMapper.apply(data);
                    return this.flatMapStreamCellsOSMEntitySnapshotGroupedById(snapshotFlatMapper);
                }
                throw new UnsupportedOperationException("Unimplemented data view: " + this.forClass.toString());
            }
        }
        throw new UnsupportedOperationException("Unsupported grouping: " + this.grouping.toString());
    }

    protected Stream<X> mapStreamCellsOSMContribution(SerializableFunction<OSMContribution, X> mapper) throws Exception {
        throw new UnsupportedOperationException("Stream function not yet implemented");
    }

    protected Stream<X> flatMapStreamCellsOSMContributionGroupedById(SerializableFunction<List<OSMContribution>, Iterable<X>> mapper) throws Exception {
        throw new UnsupportedOperationException("Stream function not yet implemented");
    }

    protected Stream<X> mapStreamCellsOSMEntitySnapshot(SerializableFunction<OSMEntitySnapshot, X> mapper) throws Exception {
        throw new UnsupportedOperationException("Stream function not yet implemented");
    }

    protected Stream<X> flatMapStreamCellsOSMEntitySnapshotGroupedById(SerializableFunction<List<OSMEntitySnapshot>, Iterable<X>> mapper) throws Exception {
        throw new UnsupportedOperationException("Stream function not yet implemented");
    }

    protected <R, S> S mapReduceCellsOSMContribution(SerializableFunction<OSMContribution, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        throw new UnsupportedOperationException("Reduce function not yet implemented");
    }

    protected <R, S> S flatMapReduceCellsOSMContributionGroupedById(SerializableFunction<List<OSMContribution>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        throw new UnsupportedOperationException("Reduce function not yet implemented");
    }

    protected <R, S> S mapReduceCellsOSMEntitySnapshot(SerializableFunction<OSMEntitySnapshot, R> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        throw new UnsupportedOperationException("Reduce function not yet implemented");
    }

    protected <R, S> S flatMapReduceCellsOSMEntitySnapshotGroupedById(SerializableFunction<List<OSMEntitySnapshot>, Iterable<R>> mapper, SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, R, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        throw new UnsupportedOperationException("Reduce function not yet implemented");
    }

    protected TagInterpreter getTagInterpreter() throws ParseException, SQLException, IOException {
        if (this.tagInterpreter == null) {
            this.tagInterpreter = new DefaultTagInterpreter(this.getTagTranslator());
        }
        return this.tagInterpreter;
    }

    protected TagTranslator getTagTranslator() {
        if (this.tagTranslator == null) {
            try {
                if (this.keytables == null) {
                    throw new OSHDBKeytablesNotFoundException();
                }
                this.tagTranslator = new TagTranslator(this.keytables.getConnection());
            }
            catch (OSHDBKeytablesNotFoundException e) {
                LOG.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        return this.tagTranslator;
    }

    protected CellIterator.OSHEntityFilter getPreFilter() {
        return this.preFilters.isEmpty() ? (CellIterator.OSHEntityFilter & Serializable)oshEntity -> true : (CellIterator.OSHEntityFilter & Serializable)oshEntity -> {
            for (SerializablePredicate<OSHEntity> filter : this.preFilters) {
                if (filter.test((OSHEntity)oshEntity)) continue;
                return false;
            }
            return true;
        };
    }

    protected CellIterator.OSMEntityFilter getFilter() {
        return this.filters.isEmpty() ? (CellIterator.OSMEntityFilter & Serializable)osmEntity -> true : (CellIterator.OSMEntityFilter & Serializable)osmEntity -> {
            for (SerializablePredicate<OSMEntity> filter : this.filters) {
                if (filter.test((OSMEntity)osmEntity)) continue;
                return false;
            }
            return true;
        };
    }

    protected Iterable<XYGridTree.CellIdRange> getCellIdRanges() {
        XYGridTree grid = new XYGridTree(15);
        if (this.bboxFilter == null || this.bboxFilter.getMinLon() >= this.bboxFilter.getMaxLon() || this.bboxFilter.getMinLat() >= this.bboxFilter.getMaxLat()) {
            LOG.warn("area of interest not set or empty");
            return Collections.emptyList();
        }
        return grid.bbox2CellIdRanges(this.bboxFilter, true);
    }

    protected <P extends Geometry> P getPolyFilter() {
        return (P)this.polyFilter;
    }

    private SerializableFunction<Object, X> getMapper() {
        return data -> {
            Object result = data;
            for (MapFunction mapper : this.mappers) {
                if (mapper.isFlatMapper()) {
                    assert (false) : "flatMap callback requested in getMapper";
                    throw new UnsupportedOperationException("cannot flat map this");
                }
                result = mapper.apply(result);
            }
            return result;
        };
    }

    private SerializableFunction<Object, Iterable<X>> getFlatMapper() {
        return data -> {
            LinkedList<Object> results = new LinkedList<Object>();
            results.add(data);
            for (MapFunction mapper : this.mappers) {
                LinkedList newResults = new LinkedList();
                if (mapper.isFlatMapper()) {
                    results.forEach((? super T result) -> Iterables.addAll((Collection)newResults, (Iterable)((Iterable)mapper.apply(result))));
                } else {
                    results.forEach((? super T result) -> newResults.add(mapper.apply(result)));
                }
                results = newResults;
            }
            return results;
        };
    }

    Collection<OSHDBTimestamp> getZerofillTimestamps() {
        if (this.forClass.equals(OSMEntitySnapshot.class)) {
            return this.tstamps.get();
        }
        TreeSet<OSHDBTimestamp> result = new TreeSet<OSHDBTimestamp>(this.tstamps.get());
        result.remove(result.last());
        return result;
    }

    @Contract(pure=true)
    private MapReducer<Number> makeNumeric() {
        return this.map(MapReducer::checkAndMapToNumeric);
    }

    @Contract(pure=true)
    static Number checkAndMapToNumeric(Object x) {
        if (!Number.class.isInstance(x)) {
            throw new UnsupportedOperationException("Cannot convert to non-numeric values of type: " + x.getClass().toString());
        }
        return (Number)x;
    }

    private void checkTimeout() {
        if (this.oshdb.timeoutInMilliseconds().isPresent()) {
            if (!this.isCancelable()) {
                LOG.error("A query timeout was set but the database backend isn't cancelable");
            } else {
                this.timeout = this.oshdb.timeoutInMilliseconds().getAsLong();
            }
        }
    }

    @Contract(pure=true)
    static <T> List<T> collectIdentitySupplier() {
        return new LinkedList();
    }

    @Contract(pure=false)
    static <T> List<T> collectAccumulator(List<T> acc, T cur) {
        acc.add(cur);
        return acc;
    }

    @Contract(pure=true)
    static <T> List<T> collectCombiner(List<T> a, List<T> b) {
        ArrayList<T> combinedLists = new ArrayList<T>(a.size() + b.size());
        combinedLists.addAll(a);
        combinedLists.addAll(b);
        return combinedLists;
    }

    @Contract(pure=true)
    static <T> Set<T> uniqIdentitySupplier() {
        return new HashSet();
    }

    @Contract(pure=false)
    static <T> Set<T> uniqAccumulator(Set<T> acc, T cur) {
        acc.add(cur);
        return acc;
    }

    @Contract(pure=true)
    static <T> Set<T> uniqCombiner(Set<T> a, Set<T> b) {
        HashSet<T> result = new HashSet<T>((int)Math.ceil((double)Math.max(a.size(), b.size()) / 0.75));
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    static enum Grouping {
        NONE,
        BY_ID;

    }
}

