/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.mapreducer;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.tdunning.math.stats.TDigest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.heigit.bigspatialdata.oshdb.api.generic.NumberUtils;
import org.heigit.bigspatialdata.oshdb.api.generic.OSHDBCombinedIndex;
import org.heigit.bigspatialdata.oshdb.api.generic.WeightedValue;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBiConsumer;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBiFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableBinaryOperator;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableFunction;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializablePredicate;
import org.heigit.bigspatialdata.oshdb.api.generic.function.SerializableSupplier;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.GeometrySplitter;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducer;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducerAggregations;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducerSettings;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.Mappable;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.PayloadWithWeight;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.TDigestReducer;
import org.heigit.bigspatialdata.oshdb.api.object.OSMContribution;
import org.heigit.bigspatialdata.oshdb.api.object.OSMEntitySnapshot;
import org.heigit.bigspatialdata.oshdb.osm.OSMEntity;
import org.heigit.bigspatialdata.oshdb.osm.OSMType;
import org.heigit.bigspatialdata.oshdb.util.OSHDBBoundingBox;
import org.heigit.bigspatialdata.oshdb.util.OSHDBTimestamp;
import org.heigit.bigspatialdata.oshdb.util.exceptions.OSHDBInvalidTimestampException;
import org.heigit.bigspatialdata.oshdb.util.tagtranslator.OSMTagInterface;
import org.jetbrains.annotations.Contract;
import org.locationtech.jts.geom.Geometry;

public class MapAggregator<U extends Comparable<U> & Serializable, X>
implements Mappable<X>,
MapReducerSettings<MapAggregator<U, X>>,
MapReducerAggregations<X> {
    private MapReducer<IndexValuePair<U, X>> mapReducer;
    private final List<Collection<? extends Comparable>> zerofill;

    MapAggregator(MapReducer<X> mapReducer, SerializableFunction<X, U> indexer, Collection<U> zerofill) {
        this.mapReducer = mapReducer.map(data -> new IndexValuePair(indexer.apply(data), data));
        this.zerofill = new ArrayList<Collection<? extends Comparable>>(1);
        this.zerofill.add(zerofill);
    }

    private MapAggregator(MapAggregator<U, ?> obj, MapReducer<IndexValuePair<U, X>> mapReducer) {
        this.mapReducer = mapReducer;
        this.zerofill = new ArrayList<Collection<? extends Comparable>>(obj.zerofill);
    }

    @Contract(pure=true)
    private <R> MapAggregator<U, R> copyTransform(MapReducer<IndexValuePair<U, R>> mapReducer) {
        return new MapAggregator<U, X>(this, mapReducer);
    }

    @Contract(pure=true)
    private <V extends Comparable<V> & Serializable> MapAggregator<V, X> copyTransformKey(MapReducer<IndexValuePair<V, X>> mapReducer) {
        return new MapAggregator<U, X>(this, mapReducer);
    }

    @Contract(pure=true)
    public <V extends Comparable<V> & Serializable> MapAggregator<OSHDBCombinedIndex<U, V>, X> aggregateBy(SerializableFunction<X, V> indexer, Collection<V> zerofill) {
        MapAggregator<V, X> res = this.mapIndex((existingIndex, data) -> new OSHDBCombinedIndex<Comparable, Comparable>((Comparable)existingIndex, (Comparable)indexer.apply(data)));
        res.zerofill.add(zerofill);
        return res;
    }

    @Contract(pure=true)
    public <V extends Comparable<V> & Serializable> MapAggregator<OSHDBCombinedIndex<U, V>, X> aggregateBy(SerializableFunction<X, V> indexer) {
        return this.aggregateBy(indexer, Collections.emptyList());
    }

    @Contract(pure=true)
    public MapAggregator<OSHDBCombinedIndex<U, OSHDBTimestamp>, X> aggregateByTimestamp(SerializableFunction<X, OSHDBTimestamp> indexer) {
        TreeSet timestamps = new TreeSet(this.mapReducer.tstamps.get());
        OSHDBTimestamp minTime = (OSHDBTimestamp)timestamps.first();
        OSHDBTimestamp maxTime = (OSHDBTimestamp)timestamps.last();
        return this.aggregateBy(data -> {
            OSHDBTimestamp aggregationTimestamp = (OSHDBTimestamp)indexer.apply(data);
            if (aggregationTimestamp == null || aggregationTimestamp.compareTo(minTime) < 0 || aggregationTimestamp.compareTo(maxTime) > 0) {
                throw new OSHDBInvalidTimestampException("Aggregation timestamp outside of time query interval.");
            }
            return timestamps.floor(aggregationTimestamp);
        }, this.mapReducer.getZerofillTimestamps());
    }

    @Contract(pure=true)
    public <V extends Comparable<V> & Serializable, P extends Geometry> MapAggregator<OSHDBCombinedIndex<U, V>, X> aggregateByGeometry(Map<V, P> geometries) throws UnsupportedOperationException {
        Mappable ret;
        if (this.mapReducer.grouping != MapReducer.Grouping.NONE) {
            throw new UnsupportedOperationException("aggregateByGeometry() cannot be used together with the groupByEntity() functionality");
        }
        GeometrySplitter gs = new GeometrySplitter(geometries);
        if (this.mapReducer.mappers.size() > 1) {
            throw new UnsupportedOperationException("please call aggregateByGeometry before setting any map or flatMap functions");
        }
        if (this.mapReducer.forClass.equals(OSMContribution.class)) {
            ret = ((MapAggregator)this.flatMap(x -> gs.splitOSMContribution((OSMContribution)x).entrySet())).aggregateBy(Map.Entry::getKey, geometries.keySet()).map(Map.Entry::getValue);
        } else if (this.mapReducer.forClass.equals(OSMEntitySnapshot.class)) {
            ret = ((MapAggregator)this.flatMap(x -> gs.splitOSMEntitySnapshot((OSMEntitySnapshot)x).entrySet())).aggregateBy(Map.Entry::getKey, geometries.keySet()).map(Map.Entry::getValue);
        } else {
            throw new UnsupportedOperationException("aggregateByGeometry not implemented for objects of type: " + this.mapReducer.forClass.toString());
        }
        return ret;
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> areaOfInterest(OSHDBBoundingBox bboxFilter) {
        return this.copyTransform((MapReducer)this.mapReducer.areaOfInterest(bboxFilter));
    }

    @Override
    @Contract(pure=true)
    public <P extends Geometry> MapAggregator<U, X> areaOfInterest(P polygonFilter) {
        return this.copyTransform((MapReducer)this.mapReducer.areaOfInterest((Geometry)polygonFilter));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmType(Set<OSMType> typeFilter) {
        return this.copyTransform((MapReducer)this.mapReducer.osmType((Set)typeFilter));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmEntityFilter(SerializablePredicate<OSMEntity> f) {
        return this.copyTransform((MapReducer)this.mapReducer.osmEntityFilter((SerializablePredicate)f));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmTag(OSMTagInterface tag) {
        return this.copyTransform((MapReducer)this.mapReducer.osmTag(tag));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmTag(String key) {
        return this.copyTransform((MapReducer)this.mapReducer.osmTag(key));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmTag(String key, String value) {
        return this.copyTransform((MapReducer)this.mapReducer.osmTag(key, value));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmTag(String key, Collection<String> values) {
        return this.copyTransform((MapReducer)this.mapReducer.osmTag(key, (Collection)values));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmTag(String key, Pattern valuePattern) {
        return this.copyTransform((MapReducer)this.mapReducer.osmTag(key, valuePattern));
    }

    @Override
    @Contract(pure=true)
    public MapAggregator<U, X> osmTag(Collection<? extends OSMTagInterface> tags) {
        return this.copyTransform((MapReducer)this.mapReducer.osmTag(tags));
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Number> sum() throws Exception {
        return this.makeNumeric().reduce(() -> 0, NumberUtils::add);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> SortedMap<U, R> sum(SerializableFunction<X, R> mapper) throws Exception {
        return ((MapAggregator)this.map((SerializableFunction)mapper)).reduce(() -> 0, NumberUtils::add);
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Integer> count() throws Exception {
        return this.sum(ignored -> 1);
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Set<X>> uniq() throws Exception {
        return this.reduce(MapReducer::uniqIdentitySupplier, MapReducer::uniqAccumulator, MapReducer::uniqCombiner);
    }

    @Override
    @Contract(pure=true)
    public <R> SortedMap<U, Set<R>> uniq(SerializableFunction<X, R> mapper) throws Exception {
        return ((MapAggregator)this.map((SerializableFunction)mapper)).uniq();
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Integer> countUniq() throws Exception {
        return this.transformSortedMap((SortedMap)this.uniq(), (Function)Set::size);
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Double> average() throws Exception {
        return this.makeNumeric().average(n -> n);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> SortedMap<U, Double> average(SerializableFunction<X, R> mapper) throws Exception {
        return this.weightedAverage(data -> new WeightedValue<Number>((Number)mapper.apply(data), 1.0));
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Double> weightedAverage(SerializableFunction<X, WeightedValue> mapper) throws Exception {
        return this.transformSortedMap((SortedMap)((MapAggregator)this.map(mapper)).reduce(PayloadWithWeight::identitySupplier, PayloadWithWeight::accumulator, PayloadWithWeight::combiner), (Function)x -> (Double)x.num / x.weight);
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Double> estimatedMedian() throws Exception {
        return this.estimatedQuantile(0.5);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> SortedMap<U, Double> estimatedMedian(SerializableFunction<X, R> mapper) throws Exception {
        return this.estimatedQuantile((SerializableFunction)mapper, 0.5);
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, Double> estimatedQuantile(double q) throws Exception {
        return this.makeNumeric().estimatedQuantile(n -> n, q);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> SortedMap<U, Double> estimatedQuantile(SerializableFunction<X, R> mapper, double q) throws Exception {
        return this.transformSortedMap((SortedMap)this.estimatedQuantiles((SerializableFunction)mapper), (Function)quantileFunction -> quantileFunction.applyAsDouble(q));
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, List<Double>> estimatedQuantiles(Iterable<Double> q) throws Exception {
        return this.makeNumeric().estimatedQuantiles(n -> n, (Iterable)q);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> SortedMap<U, List<Double>> estimatedQuantiles(SerializableFunction<X, R> mapper, Iterable<Double> q) throws Exception {
        return this.transformSortedMap((SortedMap)this.estimatedQuantiles((SerializableFunction)mapper), (Function)quantileFunction -> Streams.stream((Iterable)q).mapToDouble(Double::doubleValue).map((DoubleUnaryOperator)quantileFunction).boxed().collect(Collectors.toList()));
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, DoubleUnaryOperator> estimatedQuantiles() throws Exception {
        return this.makeNumeric().estimatedQuantiles(n -> n);
    }

    @Override
    @Contract(pure=true)
    public <R extends Number> SortedMap<U, DoubleUnaryOperator> estimatedQuantiles(SerializableFunction<X, R> mapper) throws Exception {
        return this.transformSortedMap(this.digest(mapper), d -> arg_0 -> ((TDigest)d).quantile(arg_0));
    }

    @Contract(pure=true)
    private <R extends Number> SortedMap<U, TDigest> digest(SerializableFunction<X, R> mapper) throws Exception {
        return ((MapAggregator)this.map((SerializableFunction)mapper)).reduce(TDigestReducer::identitySupplier, TDigestReducer::accumulator, TDigestReducer::combiner);
    }

    @Deprecated
    public void forEach(SerializableBiConsumer<U, List<X>> action) throws Exception {
        this.collect().forEach(action);
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, List<X>> collect() throws Exception {
        return this.reduce(MapReducer::collectIdentitySupplier, MapReducer::collectAccumulator, MapReducer::collectCombiner);
    }

    @Override
    @Contract(pure=true)
    public Stream<Map.Entry<U, X>> stream() throws Exception {
        return this.mapReducer.stream().map((? super T d) -> new Map.Entry<U, X>((IndexValuePair)d){
            final /* synthetic */ IndexValuePair val$d;
            {
                this.val$d = indexValuePair;
            }

            @Override
            public U getKey() {
                return (Comparable)this.val$d.getKey();
            }

            @Override
            public X getValue() {
                return this.val$d.getValue();
            }

            @Override
            public X setValue(X value) {
                throw new RuntimeException("cannot modify the value of this entry");
            }
        });
    }

    @Contract(pure=true)
    public <R> MapAggregator<U, R> map(SerializableFunction<X, R> mapper) {
        return this.copyTransform((MapReducer<IndexValuePair<U, R>>)this.mapReducer.map(inData -> {
            IndexValuePair outData = inData;
            outData.setValue(mapper.apply(inData.getValue()));
            return outData;
        }));
    }

    @Contract(pure=true)
    public <R> MapAggregator<U, R> flatMap(SerializableFunction<X, Iterable<R>> flatMapper) {
        return this.copyTransform((MapReducer<IndexValuePair<U, R>>)this.mapReducer.flatMap(inData -> {
            LinkedList outData = new LinkedList();
            ((Iterable)flatMapper.apply(inData.getValue())).forEach((? super T flatMappedData) -> outData.add(new IndexValuePair(inData.getKey(), flatMappedData)));
            return outData;
        }));
    }

    @Contract(pure=true)
    public MapAggregator<U, X> filter(SerializablePredicate<X> f) {
        return this.copyTransform((MapReducer)this.mapReducer.filter(data -> f.test(data.getValue())));
    }

    @Override
    @Contract(pure=true)
    public <S> SortedMap<U, S> reduce(SerializableSupplier<S> identitySupplier, SerializableBiFunction<S, X, S> accumulator, SerializableBinaryOperator<S> combiner) throws Exception {
        SortedMap result = (SortedMap)this.mapReducer.reduce(TreeMap::new, (m, r) -> {
            m.put(r.getKey(), accumulator.apply(m.getOrDefault(r.getKey(), identitySupplier.get()), r.getValue()));
            return m;
        }, (a, b) -> {
            TreeMap combined = new TreeMap(a);
            for (Map.Entry entry : b.entrySet()) {
                combined.merge(entry.getKey(), entry.getValue(), combiner);
            }
            return combined;
        });
        Collection<Comparable> zerofill = this.completeZerofill(result.keySet(), Lists.reverse(this.zerofill));
        zerofill.forEach((? super T zerofillKey) -> {
            if (!result.containsKey(zerofillKey)) {
                result.put(zerofillKey, identitySupplier.get());
            }
        });
        return result;
    }

    @Override
    @Contract(pure=true)
    public SortedMap<U, X> reduce(SerializableSupplier<X> identitySupplier, SerializableBinaryOperator<X> accumulator) throws Exception {
        return this.reduce(identitySupplier, accumulator::apply, accumulator);
    }

    @Contract(pure=true)
    private MapAggregator<U, Number> makeNumeric() {
        return this.map(MapReducer::checkAndMapToNumeric);
    }

    @Contract(pure=true)
    private <V extends Comparable<V> & Serializable> MapAggregator<V, X> mapIndex(SerializableBiFunction<U, X, V> keyMapper) {
        return this.copyTransformKey((MapReducer<IndexValuePair<V, X>>)this.mapReducer.map(inData -> new IndexValuePair(keyMapper.apply(inData.getKey(), inData.getValue()), inData.getValue())));
    }

    private Collection<? extends Comparable> completeZerofill(Set<? extends Comparable> keys, List<Collection<? extends Comparable>> zerofills) {
        if (zerofills.isEmpty()) {
            return Collections.emptyList();
        }
        TreeSet<? extends Comparable> seen = new TreeSet<Comparable>(zerofills.get(0));
        TreeSet nextLevelKeys = new TreeSet();
        for (Comparable comparable : keys) {
            Comparable<Object> v;
            if (comparable instanceof OSHDBCombinedIndex) {
                v = ((OSHDBCombinedIndex)comparable).getSecondIndex();
                nextLevelKeys.add(((OSHDBCombinedIndex)comparable).getFirstIndex());
            } else {
                v = comparable;
            }
            seen.add(v);
        }
        if (zerofills.size() == 1) {
            return seen;
        }
        Collection<Comparable> nextLevel = this.completeZerofill(nextLevelKeys, zerofills.subList(1, zerofills.size()));
        Stream stream = nextLevel.stream().flatMap((? super T u) -> seen.stream().map((? super T v) -> new OSHDBCombinedIndex<Comparable, Comparable>((Comparable)u, (Comparable)v)));
        return stream.collect(Collectors.toList());
    }

    private <A, B> SortedMap<U, B> transformSortedMap(SortedMap<U, A> in, Function<A, B> transform) {
        return in.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> transform.apply(e.getValue()), (v1, v2) -> {
            assert (false);
            return v1;
        }, TreeMap::new));
    }

    private static class IndexValuePair<U, X> {
        private U key;
        protected X value;

        private IndexValuePair(U key, X value) {
            this.key = key;
            this.value = value;
        }

        public U getKey() {
            return this.key;
        }

        public X getValue() {
            return this.value;
        }

        public void setValue(X value) {
            this.value = value;
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public boolean equals(Object other) {
            return this == other || other instanceof IndexValuePair && Objects.equals(this.key, ((IndexValuePair)other).key) && Objects.equals(this.value, ((IndexValuePair)other).value);
        }

        public String toString() {
            return "[index=" + this.key + ", value=" + this.value + "]";
        }
    }
}

