/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.mapreducer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.heigit.bigspatialdata.oshdb.api.object.OSMContribution;
import org.heigit.bigspatialdata.oshdb.api.object.OSMEntitySnapshot;
import org.heigit.bigspatialdata.oshdb.util.OSHDBBoundingBox;
import org.heigit.bigspatialdata.oshdb.util.celliterator.ContributionType;
import org.heigit.bigspatialdata.oshdb.util.geometry.OSHDBGeometryBuilder;
import org.heigit.bigspatialdata.oshdb.util.geometry.fip.FastBboxInPolygon;
import org.heigit.bigspatialdata.oshdb.util.geometry.fip.FastBboxOutsidePolygon;
import org.heigit.bigspatialdata.oshdb.util.geometry.fip.FastPolygonOperations;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.index.strtree.STRtree;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;

class GeometrySplitter<U extends Comparable<U>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private STRtree spatialIndex = new STRtree();
    private Map<U, FastBboxInPolygon> bips = new HashMap<U, FastBboxInPolygon>();
    private Map<U, FastBboxOutsidePolygon> bops = new HashMap<U, FastBboxOutsidePolygon>();
    private Map<U, FastPolygonOperations> poops = new HashMap<U, FastPolygonOperations>();
    private Map<U, ? extends Geometry> subregions;

    <P extends Geometry> GeometrySplitter(Map<U, P> subregions) {
        subregions.forEach((index, geometry) -> {
            this.spatialIndex.insert(geometry.getEnvelopeInternal(), index);
            this.bips.put(index, new FastBboxInPolygon(geometry));
            this.bops.put(index, new FastBboxOutsidePolygon(geometry));
            this.poops.put(index, new FastPolygonOperations(geometry));
        });
        this.subregions = subregions;
    }

    public Map<U, OSMEntitySnapshot> splitOSMEntitySnapshot(OSMEntitySnapshot data) {
        OSHDBBoundingBox oshBoundingBox = data.getOSHEntity().getBoundingBox();
        List candidates = this.spatialIndex.query(OSHDBGeometryBuilder.getGeometry((OSHDBBoundingBox)oshBoundingBox).getEnvelopeInternal());
        return candidates.stream().filter(index -> !this.bops.get(index).test(oshBoundingBox)).flatMap(index -> {
            if (this.bips.get(index).test(oshBoundingBox)) {
                return Stream.of(new IndexData<Comparable, OSMEntitySnapshot>((Comparable)index, data));
            }
            Geometry snapshotGeometry = data.getGeometry();
            OSHDBBoundingBox snapshotBbox = OSHDBGeometryBuilder.boundingBoxOf((Envelope)snapshotGeometry.getEnvelopeInternal());
            if (this.bops.get(index).test(snapshotBbox)) {
                return Stream.empty();
            }
            if (this.bips.get(index).test(snapshotBbox)) {
                return Stream.of(new IndexData<Comparable, OSMEntitySnapshot>((Comparable)index, data));
            }
            FastPolygonOperations poop = this.poops.get(index);
            try {
                Geometry intersection = poop.intersection(snapshotGeometry);
                if (intersection == null || intersection.isEmpty()) {
                    return Stream.empty();
                }
                return Stream.of(new IndexData<Comparable, OSMEntitySnapshot>((Comparable)index, new OSMEntitySnapshot(data, intersection)));
            }
            catch (TopologyException ignored) {
                return Stream.empty();
            }
        }).collect(Collectors.toMap(IndexData::getIndex, IndexData::getData));
    }

    public Map<U, OSMContribution> splitOSMContribution(OSMContribution data) {
        OSHDBBoundingBox oshBoundingBox = data.getOSHEntity().getBoundingBox();
        List candidates = this.spatialIndex.query(OSHDBGeometryBuilder.getGeometry((OSHDBBoundingBox)oshBoundingBox).getEnvelopeInternal());
        return candidates.stream().filter(index -> !this.bops.get(index).test(oshBoundingBox)).flatMap(index -> {
            OSHDBBoundingBox contributionGeometryBbox;
            if (this.bips.get(index).test(oshBoundingBox)) {
                return Stream.of(new IndexData<Comparable, OSMContribution>((Comparable)index, data));
            }
            Geometry contributionGeometryBefore = data.getGeometryBefore();
            Geometry contributionGeometryAfter = data.getGeometryAfter();
            if (data.is(ContributionType.CREATION)) {
                contributionGeometryBbox = OSHDBGeometryBuilder.boundingBoxOf((Envelope)contributionGeometryAfter.getEnvelopeInternal());
            } else if (data.is(ContributionType.DELETION)) {
                contributionGeometryBbox = OSHDBGeometryBuilder.boundingBoxOf((Envelope)contributionGeometryBefore.getEnvelopeInternal());
            } else {
                contributionGeometryBbox = OSHDBGeometryBuilder.boundingBoxOf((Envelope)contributionGeometryBefore.getEnvelopeInternal());
                contributionGeometryBbox.add(OSHDBGeometryBuilder.boundingBoxOf((Envelope)contributionGeometryAfter.getEnvelopeInternal()));
            }
            if (this.bops.get(index).test(contributionGeometryBbox)) {
                return Stream.empty();
            }
            if (this.bips.get(index).test(contributionGeometryBbox)) {
                return Stream.of(new IndexData<Comparable, OSMContribution>((Comparable)index, data));
            }
            FastPolygonOperations poop = this.poops.get(index);
            try {
                Geometry intersectionBefore = poop.intersection(contributionGeometryBefore);
                Geometry intersectionAfter = poop.intersection(contributionGeometryAfter);
                if ((intersectionBefore == null || intersectionBefore.isEmpty()) && (intersectionAfter == null || intersectionAfter.isEmpty())) {
                    return Stream.empty();
                }
                return Stream.of(new IndexData<Comparable, OSMContribution>((Comparable)index, new OSMContribution(data, intersectionBefore, intersectionAfter)));
            }
            catch (TopologyException ignored) {
                return Stream.empty();
            }
        }).collect(Collectors.toMap(IndexData::getIndex, IndexData::getData));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        WKBWriter writer = new WKBWriter();
        out.writeInt(this.subregions.size());
        for (Map.Entry<U, Geometry> entry : this.subregions.entrySet()) {
            out.writeObject(entry.getKey());
            byte[] data = writer.write(entry.getValue());
            out.writeInt(data.length);
            out.write(data);
        }
    }

    private <P extends Geometry> void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        WKBReader reader = new WKBReader();
        int numEntries = in.readInt();
        TreeMap<U, Geometry> result = new TreeMap<U, Geometry>();
        for (int i = 0; i < numEntries; ++i) {
            Comparable key = (Comparable)in.readObject();
            int dataLength = in.readInt();
            byte[] data = new byte[dataLength];
            int bytesRead = in.read(data);
            assert (bytesRead == dataLength) : "fewer bytes read than expected";
            try {
                result.put(key, (Geometry)reader.read(data));
                continue;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        this.subregions = result;
    }

    protected <P extends Geometry> Object readResolve() throws ObjectStreamException {
        return new GeometrySplitter<U>(this.subregions);
    }

    private static class IndexData<I, D> {
        private final I index;
        private final D data;

        IndexData(I index, D data) {
            this.index = index;
            this.data = data;
        }

        I getIndex() {
            return this.index;
        }

        D getData() {
            return this.data;
        }
    }
}

