/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.generic;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class OSHDBCombinedIndex<U extends Comparable<U> & Serializable, V extends Comparable<V> & Serializable>
implements Comparable<OSHDBCombinedIndex<U, V>>,
Serializable {
    private U index1;
    private V index2;

    public OSHDBCombinedIndex(U index1, V index2) {
        this.index1 = index1;
        this.index2 = index2;
    }

    public U getFirstIndex() {
        return this.index1;
    }

    public V getSecondIndex() {
        return this.index2;
    }

    @Override
    public int compareTo(@NotNull OSHDBCombinedIndex<U, V> other) {
        int c = this.index1.compareTo(other.index1);
        if (c == 0) {
            c = this.index2.compareTo(other.index2);
        }
        return c;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof OSHDBCombinedIndex && Objects.equals(this.index1, ((OSHDBCombinedIndex)obj).index1) && Objects.equals(this.index2, ((OSHDBCombinedIndex)obj).index2);
    }

    public int hashCode() {
        return Objects.hash(this.index1, this.index2);
    }

    public String toString() {
        return this.getFirstIndex().toString() + "&" + this.getSecondIndex().toString();
    }

    public static <A, U extends Comparable<U> & Serializable, V extends Comparable<V> & Serializable> SortedMap<U, SortedMap<V, A>> nest(Map<OSHDBCombinedIndex<U, V>, A> result) {
        TreeMap ret = new TreeMap();
        result.forEach((index, data) -> {
            if (!ret.containsKey(index.getFirstIndex())) {
                ret.put(index.getFirstIndex(), new TreeMap());
            }
            ((SortedMap)ret.get(index.getFirstIndex())).put(index.getSecondIndex(), data);
        });
        return ret;
    }
}

