/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.db;

import com.google.common.base.Joiner;
import java.io.File;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.Ignite;
import org.apache.ignite.Ignition;
import org.apache.ignite.lang.IgniteRunnable;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBDatabase;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.MapReducer;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.MapReducerIgniteAffinityCall;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.MapReducerIgniteLocalPeek;
import org.heigit.bigspatialdata.oshdb.api.mapreducer.backend.MapReducerIgniteScanQuery;
import org.heigit.bigspatialdata.oshdb.api.object.OSHDBMapReducible;
import org.heigit.bigspatialdata.oshdb.osm.OSMType;
import org.heigit.bigspatialdata.oshdb.util.TableNames;
import org.heigit.bigspatialdata.oshdb.util.exceptions.OSHDBTableNotFoundException;

public class OSHDBIgnite
extends OSHDBDatabase
implements AutoCloseable {
    private final transient Ignite ignite;
    private ComputeMode computeMode = ComputeMode.LocalPeek;
    private IgniteRunnable onCloseCallback = null;

    public OSHDBIgnite() {
        this(new File("ignite-config.xml"));
    }

    public OSHDBIgnite(Ignite ignite) {
        this.ignite = ignite;
        this.ignite.cluster().active(true);
    }

    public OSHDBIgnite(String igniteConfigFilePath) {
        this(new File(igniteConfigFilePath));
    }

    public OSHDBIgnite(File igniteConfig) {
        Ignition.setClientMode((boolean)true);
        this.ignite = Ignition.start((String)igniteConfig.toString());
        this.ignite.cluster().active(true);
    }

    @Override
    public OSHDBIgnite prefix(String prefix) {
        return (OSHDBIgnite)super.prefix(prefix);
    }

    @Override
    public <X extends OSHDBMapReducible> MapReducer<X> createMapReducer(Class<X> forClass) {
        MapReducer mapReducer;
        Collection expectedCaches;
        Collection allCaches = this.getIgnite().cacheNames();
        if (!allCaches.containsAll(expectedCaches = (Collection)Stream.of(OSMType.values()).map(TableNames::forOSMType).filter(Optional::isPresent).map(Optional::get).map(t -> t.toString(this.prefix())).collect(Collectors.toList()))) {
            throw new OSHDBTableNotFoundException(Joiner.on((String)", ").join((Iterable)expectedCaches));
        }
        switch (this.computeMode()) {
            case LocalPeek: {
                mapReducer = new MapReducerIgniteLocalPeek(this, forClass);
                break;
            }
            case ScanQuery: {
                mapReducer = new MapReducerIgniteScanQuery(this, forClass);
                break;
            }
            case AffinityCall: {
                mapReducer = new MapReducerIgniteAffinityCall(this, forClass);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Backend not implemented for this compute mode.");
            }
        }
        return mapReducer;
    }

    @Override
    public String metadata(String property) {
        return null;
    }

    public Ignite getIgnite() {
        return this.ignite;
    }

    @Override
    public void close() {
        this.ignite.close();
    }

    public OSHDBIgnite computeMode(ComputeMode computeMode) {
        this.computeMode = computeMode;
        return this;
    }

    public ComputeMode computeMode() {
        return this.computeMode;
    }

    public OSHDBIgnite onClose(IgniteRunnable action) {
        this.onCloseCallback = action;
        return this;
    }

    public Optional<IgniteRunnable> onClose() {
        if (this.onCloseCallback == null) {
            return Optional.empty();
        }
        return Optional.of(this.onCloseCallback);
    }

    public static enum ComputeMode {
        LocalPeek,
        ScanQuery,
        AffinityCall;

    }
}

