/*
 * Decompiled with CFR 0.152.
 */
package org.heigit.bigspatialdata.oshdb.api.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.heigit.bigspatialdata.oshdb.api.db.OSHDBJdbc;
import org.heigit.bigspatialdata.oshdb.util.TableNames;

public class OSHDBH2
extends OSHDBJdbc {
    public OSHDBH2(String databaseFile) throws SQLException, ClassNotFoundException {
        super("org.h2.Driver", "jdbc:h2:" + databaseFile.replaceAll("\\.mv\\.db$", "") + ";ACCESS_MODE_DATA=r");
    }

    public OSHDBH2(Connection conn) throws ClassNotFoundException, SQLException {
        super(conn);
    }

    @Override
    public OSHDBH2 prefix(String prefix) {
        return (OSHDBH2)super.prefix(prefix);
    }

    @Override
    public OSHDBH2 multithreading(boolean useMultithreading) {
        return (OSHDBH2)super.multithreading(useMultithreading);
    }

    public OSHDBH2 inMemory(boolean cache) throws SQLException {
        if (!cache) {
            return this;
        }
        Connection dest = DriverManager.getConnection("jdbc:h2:mem:");
        try (Connection src = this.getConnection();){
            try (Statement srcStmt = src.createStatement();
                 ResultSet srcRst = srcStmt.executeQuery("script nodata");
                 Statement destStmt = dest.createStatement();){
                while (srcRst.next()) {
                    destStmt.executeUpdate(srcRst.getString(1));
                }
            }
            Consumer<String> copyData = tablename -> {
                try (Statement srcStmt = src.createStatement();){
                    ResultSet rs = srcStmt.executeQuery("show columns from " + tablename);
                    LinkedList<String> columnNames = new LinkedList<String>();
                    while (rs.next()) {
                        columnNames.add(rs.getString(1));
                    }
                    String columns = columnNames.stream().collect(Collectors.joining(", "));
                    String placeholders = columnNames.stream().map(ignored -> "?").collect(Collectors.joining(", "));
                    PreparedStatement destStmt = dest.prepareStatement("insert into " + tablename + "(" + columns + ") values (" + placeholders + ")");
                    rs = srcStmt.executeQuery("select " + columns + " from " + tablename);
                    while (rs.next()) {
                        for (int i = 1; i <= columnNames.size(); ++i) {
                            destStmt.setObject(i, rs.getObject(i));
                        }
                        destStmt.execute();
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            };
            try (Statement srcStmt = src.createStatement();){
                ResultSet rs = srcStmt.executeQuery("show tables");
                while (rs.next()) {
                    String tableName = rs.getString(1).toLowerCase();
                    Set tableNames = Stream.of(TableNames.values()).map(x -> x.toString(this.prefix())).map(String::toLowerCase).collect(Collectors.toSet());
                    if (!tableNames.contains(tableName)) continue;
                    copyData.accept(tableName);
                }
            }
        }
        this.connection = dest;
        return this;
    }
}

