/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.structure.client.editors.fileexplorer;

import org.guvnor.structure.client.resources.i18n.CommonConstants;
import org.uberfire.backend.vfs.Path;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.core.client.tree.TreeItem;

class FileExplorerItem {
    private CommonConstants constants = CommonConstants.INSTANCE;
    private final TreeItem parent;

    FileExplorerItem(TreeItem treeItem) {
        this.parent = (TreeItem)PortablePreconditions.checkNotNull((String)"parent", (Object)treeItem);
    }

    public void addDirectory(Path child) {
        this.checkCleanupLoading();
        TreeItem newDirectory = this.parent.addItem(TreeItem.Type.FOLDER, child.getFileName());
        newDirectory.addItem(TreeItem.Type.LOADING, this.constants.Loading());
        newDirectory.setUserObject((Object)child);
    }

    public void addFile(Path child) {
        this.checkCleanupLoading();
        TreeItem newFile = this.parent.addItem(TreeItem.Type.ITEM, child.getFileName());
        newFile.setUserObject((Object)child);
    }

    private void checkCleanupLoading() {
        if (this.parent.getChild(0) != null && this.parent.getChild(0).getUserObject() == null) {
            this.parent.getChild(0).remove();
        }
    }
}

