/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.common.services.project.context;

import javax.enterprise.event.Event;
import org.guvnor.common.services.project.context.ProjectContext;
import org.guvnor.common.services.project.context.ProjectContextChangeEvent;
import org.guvnor.common.services.project.context.ProjectContextChangeHandle;
import org.guvnor.common.services.project.context.ProjectContextChangeHandler;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ProjectContextTest {
    private ProjectContextChangeEventMock changeEvent;
    private ProjectContext context;

    @Before
    public void setUp() throws Exception {
        this.changeEvent = (ProjectContextChangeEventMock)Mockito.mock(ProjectContextChangeEventMock.class);
        this.context = new ProjectContext((Event)this.changeEvent);
        ((ProjectContextChangeEventMock)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                ProjectContextTest.this.context.onProjectContextChanged((ProjectContextChangeEvent)invocationOnMock.getArguments()[0]);
                return null;
            }
        }).when((Object)this.changeEvent)).fire(Mockito.any(ProjectContextChangeEvent.class));
    }

    @Test
    public void testRepositoryDeleted() throws Exception {
        OrganizationalUnit organizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        GitRepository repository = new GitRepository();
        this.context.setActiveOrganizationalUnit(organizationalUnit);
        this.context.setActiveRepository((Repository)repository);
        RepositoryRemovedEvent repositoryRemovedEvent = new RepositoryRemovedEvent((Repository)repository);
        this.context.onRepositoryRemoved(repositoryRemovedEvent);
        Assert.assertEquals((Object)organizationalUnit, (Object)this.context.getActiveOrganizationalUnit());
        Assert.assertNull((Object)this.context.getActiveRepository());
    }

    @Test
    public void testIgnoreRepositoryDeletedEventIfTheActiveRepositoryWasNotDeleted() throws Exception {
        GitRepository activeRepository = new GitRepository("active repo");
        GitRepository deletedRepository = new GitRepository("deleted repo");
        this.context.setActiveRepository((Repository)activeRepository);
        RepositoryRemovedEvent repositoryRemovedEvent = new RepositoryRemovedEvent((Repository)deletedRepository);
        this.context.onRepositoryRemoved(repositoryRemovedEvent);
        Assert.assertEquals((Object)activeRepository, (Object)this.context.getActiveRepository());
    }

    @Test
    public void testContextChanged() throws Exception {
        OrganizationalUnit oldOrganizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Repository oldRepository = (Repository)Mockito.mock(Repository.class);
        Package oldPackage = new Package();
        Project oldProject = new Project();
        this.context.setActiveOrganizationalUnit(oldOrganizationalUnit);
        this.context.setActiveRepository(oldRepository);
        this.context.setActivePackage(oldPackage);
        this.context.setActiveProject(oldProject);
        OrganizationalUnit newOrganizationalUnit = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);
        Repository newRepository = (Repository)Mockito.mock(Repository.class);
        Package newPackage = new Package();
        Project newProject = new Project();
        ProjectContextChangeHandler changeHandler = (ProjectContextChangeHandler)Mockito.mock(ProjectContextChangeHandler.class);
        this.context.addChangeHandler(changeHandler);
        this.context.onProjectContextChanged(new ProjectContextChangeEvent(newOrganizationalUnit, newRepository, newProject, newPackage));
        Assert.assertEquals((Object)newOrganizationalUnit, (Object)this.context.getActiveOrganizationalUnit());
        Assert.assertEquals((Object)newRepository, (Object)this.context.getActiveRepository());
        Assert.assertEquals((Object)newProject, (Object)this.context.getActiveProject());
        Assert.assertEquals((Object)newPackage, (Object)this.context.getActivePackage());
        ((ProjectContextChangeHandler)Mockito.verify((Object)changeHandler)).onChange();
    }

    @Test
    public void testContextChangeHandlerGetsRemoved() throws Exception {
        ProjectContextChangeHandler changeHandler = (ProjectContextChangeHandler)Mockito.mock(ProjectContextChangeHandler.class);
        ProjectContextChangeHandle handle = this.context.addChangeHandler(changeHandler);
        this.context.onProjectContextChanged(new ProjectContextChangeEvent());
        ((ProjectContextChangeHandler)Mockito.verify((Object)changeHandler)).onChange();
        this.context.removeChangeHandler(handle);
        Mockito.reset((Object[])new ProjectContextChangeHandler[]{changeHandler});
        this.context.onProjectContextChanged(new ProjectContextChangeEvent());
        ((ProjectContextChangeHandler)Mockito.verify((Object)changeHandler, (VerificationMode)Mockito.never())).onChange();
    }

    static interface ProjectContextChangeEventMock
    extends Event<ProjectContextChangeEvent> {
    }
}

