/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.guvnor.common.services.project.model;

import java.util.ArrayList;
import java.util.List;

import org.jboss.errai.common.client.api.annotations.Portable;

@Portable
public class Plugin {

    private List<Dependency> dependencies = new ArrayList<Dependency>();
    private String groupId;
    private String artifactId;
    private String version;
    private boolean extensions = false;

    public List<Dependency> getDependencies() {
        return dependencies;
    }

    public void setDependencies( List<Dependency> dependencies ) {
        this.dependencies = dependencies;
    }

    public void setGroupId( String groupId ) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return groupId;
    }

    public void setArtifactId( String artifactId ) {
        this.artifactId = artifactId;
    }

    public String getArtifactId() {
        return artifactId;
    }

    public void setVersion( String version ) {
        this.version = version;
    }

    public String getVersion() {
        return version;
    }

    public void setExtensions( boolean extensions ) {
        this.extensions = extensions;
    }

    public boolean isExtensions() {
        return extensions;
    }
}
