/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.organizationalunit.manager.client.editor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerPresenter;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerView;
import org.guvnor.organizationalunit.manager.client.resources.i18n.OrganizationalUnitManagerConstants;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.repositories.Repository;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ListBox;
import org.uberfire.ext.widgets.common.client.common.BusyPopup;

@ApplicationScoped
public class OrganizationalUnitManagerViewImpl
extends Composite
implements OrganizationalUnitManagerView {
    private static final Comparator<OrganizationalUnit> ORGANIZATIONAL_UNIT_COMPARATOR = new Comparator<OrganizationalUnit>(){

        @Override
        public int compare(OrganizationalUnit o1, OrganizationalUnit o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    };
    private static final Comparator<Repository> REPOSITORY_COMPARATOR = new Comparator<Repository>(){

        @Override
        public int compare(Repository o1, Repository o2) {
            return o1.getAlias().toLowerCase().compareTo(o2.getAlias().toLowerCase());
        }
    };
    private static OrganizationalUnitManagerViewBinder uiBinder = (OrganizationalUnitManagerViewBinder)GWT.create(OrganizationalUnitManagerViewBinder.class);
    @UiField
    ListBox lstOrganizationalUnits;
    @UiField
    ListBox lstOrganizationalUnitRepositories;
    @UiField
    ListBox lstAvailableRepositories;
    @UiField
    Button btnAddOrganizationalUnit;
    @UiField
    Button btnEditOrganizationalUnit;
    @UiField
    Button btnDeleteOrganizationalUnit;
    @UiField
    Button btnAddRepository;
    @UiField
    Button btnRemoveRepository;
    private OrganizationalUnitManagerPresenter presenter;
    private List<OrganizationalUnit> sortedOrganizationalUnits = new ArrayList<OrganizationalUnit>();
    private List<Repository> sortedOrganizationalUnitRepositories = new ArrayList<Repository>();
    private List<Repository> sortedAvailableRepositories = new ArrayList<Repository>();

    public OrganizationalUnitManagerViewImpl() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.lstOrganizationalUnits.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                int selectedOrganizationalUnitIndex = OrganizationalUnitManagerViewImpl.this.lstOrganizationalUnits.getSelectedIndex();
                if (selectedOrganizationalUnitIndex == -1) {
                    return;
                }
                if (OrganizationalUnitManagerViewImpl.this.sortedOrganizationalUnits.isEmpty()) {
                    return;
                }
                OrganizationalUnit selectedOrganizationalUnit = (OrganizationalUnit)OrganizationalUnitManagerViewImpl.this.sortedOrganizationalUnits.get(selectedOrganizationalUnitIndex);
                OrganizationalUnitManagerViewImpl.this.presenter.organizationalUnitSelected(selectedOrganizationalUnit);
                OrganizationalUnitManagerViewImpl.this.btnAddRepository.setEnabled(false);
                OrganizationalUnitManagerViewImpl.this.btnRemoveRepository.setEnabled(false);
            }
        });
        this.lstOrganizationalUnitRepositories.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                OrganizationalUnitManagerViewImpl.this.btnRemoveRepository.setEnabled(true);
            }
        });
        this.lstAvailableRepositories.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                OrganizationalUnitManagerViewImpl.this.btnAddRepository.setEnabled(true);
            }
        });
    }

    public void init(OrganizationalUnitManagerPresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void reset() {
        this.sortedOrganizationalUnits.clear();
        this.sortedOrganizationalUnitRepositories.clear();
        this.sortedAvailableRepositories.clear();
        this.lstOrganizationalUnits.clear();
        this.lstOrganizationalUnitRepositories.clear();
        this.lstAvailableRepositories.clear();
        this.btnAddRepository.setEnabled(false);
        this.btnRemoveRepository.setEnabled(false);
        this.btnDeleteOrganizationalUnit.setEnabled(false);
        this.btnEditOrganizationalUnit.setEnabled(false);
    }

    @Override
    public void setOrganizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
        int selectedOrganizationalUnitIndex = this.lstOrganizationalUnits.getSelectedIndex();
        OrganizationalUnit selectedOrganizationalUnit = selectedOrganizationalUnitIndex < 0 ? null : this.sortedOrganizationalUnits.get(selectedOrganizationalUnitIndex);
        this.lstOrganizationalUnits.clear();
        this.sortedOrganizationalUnits.clear();
        if (organizationalUnits != null && !organizationalUnits.isEmpty()) {
            this.lstOrganizationalUnits.setEnabled(true);
            this.sortedOrganizationalUnits = this.sortOrganizationalUnits(organizationalUnits);
            for (OrganizationalUnit organizationalUnit : this.sortedOrganizationalUnits) {
                this.lstOrganizationalUnits.addItem(this.getOrganizationalUnitDisplayName(organizationalUnit));
            }
        } else {
            this.lstOrganizationalUnits.setEnabled(false);
            this.lstOrganizationalUnits.addItem(OrganizationalUnitManagerConstants.INSTANCE.NoOrganizationalUnitsDefined());
        }
        if (this.sortedOrganizationalUnits.contains(selectedOrganizationalUnit)) {
            this.lstOrganizationalUnits.setSelectedIndex(this.sortedOrganizationalUnits.indexOf(selectedOrganizationalUnit));
            this.presenter.organizationalUnitSelected(selectedOrganizationalUnit);
        } else {
            this.lstOrganizationalUnitRepositories.clear();
            this.lstOrganizationalUnitRepositories.setEnabled(false);
            this.lstOrganizationalUnitRepositories.addItem(OrganizationalUnitManagerConstants.INSTANCE.NoOrganizationalUnitSelected());
            this.lstAvailableRepositories.clear();
            this.lstAvailableRepositories.setEnabled(false);
            this.lstAvailableRepositories.addItem(OrganizationalUnitManagerConstants.INSTANCE.NoOrganizationalUnitSelected());
            this.btnDeleteOrganizationalUnit.setEnabled(false);
            this.btnEditOrganizationalUnit.setEnabled(false);
        }
    }

    private String getOrganizationalUnitDisplayName(OrganizationalUnit organizationalUnit) {
        StringBuilder sb = new StringBuilder(organizationalUnit.getName());
        if (organizationalUnit.getOwner() != null && !organizationalUnit.getOwner().isEmpty()) {
            sb.append(" : ").append(organizationalUnit.getOwner());
        }
        return sb.toString();
    }

    private List<OrganizationalUnit> sortOrganizationalUnits(Collection<OrganizationalUnit> organizationalUnits) {
        ArrayList<OrganizationalUnit> sortedOrganizationalUnits = new ArrayList<OrganizationalUnit>();
        sortedOrganizationalUnits.addAll(organizationalUnits);
        Collections.sort(sortedOrganizationalUnits, ORGANIZATIONAL_UNIT_COMPARATOR);
        return sortedOrganizationalUnits;
    }

    @Override
    public void setOrganizationalUnitRepositories(Collection<Repository> repositories, Collection<Repository> availableRepositories) {
        this.lstOrganizationalUnitRepositories.clear();
        this.sortedOrganizationalUnitRepositories.clear();
        if (repositories != null && !repositories.isEmpty()) {
            this.lstOrganizationalUnitRepositories.setEnabled(true);
            this.sortedOrganizationalUnitRepositories = this.sortRepositories(repositories);
            for (Repository repository : this.sortedOrganizationalUnitRepositories) {
                this.lstOrganizationalUnitRepositories.addItem(repository.getAlias());
            }
        } else {
            this.lstOrganizationalUnitRepositories.setEnabled(false);
            this.lstOrganizationalUnitRepositories.addItem(OrganizationalUnitManagerConstants.INSTANCE.NoRepositoriesDefined());
        }
        this.lstAvailableRepositories.clear();
        this.sortedAvailableRepositories.clear();
        this.sortedAvailableRepositories.addAll(availableRepositories);
        this.sortedAvailableRepositories.removeAll(this.sortedOrganizationalUnitRepositories);
        if (this.sortedAvailableRepositories != null && !this.sortedAvailableRepositories.isEmpty()) {
            this.lstAvailableRepositories.setEnabled(true);
            for (Repository repo : this.sortedAvailableRepositories) {
                this.lstAvailableRepositories.addItem(repo.getAlias());
            }
        } else {
            this.lstAvailableRepositories.setEnabled(false);
            this.lstAvailableRepositories.addItem(OrganizationalUnitManagerConstants.INSTANCE.NoRepositoriesAvailable());
        }
    }

    private List<Repository> sortRepositories(Collection<Repository> repositories) {
        ArrayList<Repository> sortedRepositories = new ArrayList<Repository>();
        sortedRepositories.addAll(repositories);
        Collections.sort(sortedRepositories, REPOSITORY_COMPARATOR);
        return sortedRepositories;
    }

    @Override
    public void addOrganizationalUnit(OrganizationalUnit newOrganizationalUnit) {
        ArrayList<OrganizationalUnit> existingOrganizationalUnits = new ArrayList<OrganizationalUnit>(this.sortedOrganizationalUnits);
        existingOrganizationalUnits.add(newOrganizationalUnit);
        this.setOrganizationalUnits(existingOrganizationalUnits);
    }

    @Override
    public void deleteOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        for (int i = 0; i < this.lstOrganizationalUnits.getItemCount(); ++i) {
            this.lstOrganizationalUnits.setItemSelected(i, false);
        }
        ArrayList<OrganizationalUnit> existingOrganizationalUnits = new ArrayList<OrganizationalUnit>(this.sortedOrganizationalUnits);
        existingOrganizationalUnits.remove(organizationalUnit);
        this.setOrganizationalUnits(existingOrganizationalUnits);
    }

    public void showBusyIndicator(String message) {
        BusyPopup.showMessage((String)message);
    }

    public void hideBusyIndicator() {
        BusyPopup.close();
    }

    @Override
    public void setAddOrganizationalUnitEnabled(boolean enabled) {
        this.btnAddOrganizationalUnit.setEnabled(enabled);
    }

    @Override
    public void setEditOrganizationalUnitEnabled(boolean enabled) {
        this.btnEditOrganizationalUnit.setEnabled(enabled);
        this.btnAddRepository.setEnabled(enabled);
        this.btnRemoveRepository.setEnabled(enabled);
    }

    @Override
    public void setDeleteOrganizationalUnitEnabled(boolean enabled) {
        this.btnDeleteOrganizationalUnit.setEnabled(enabled);
    }

    @UiHandler(value={"btnAddOrganizationalUnit"})
    public void onClickAddOrganizationalUnitButton(ClickEvent event) {
        this.presenter.addNewOrganizationalUnit();
    }

    @UiHandler(value={"btnDeleteOrganizationalUnit"})
    public void onClickDeleteOrganizationalUnitButton(ClickEvent event) {
        int selectedOrganizationalUnitIndex = this.lstOrganizationalUnits.getSelectedIndex();
        if (selectedOrganizationalUnitIndex < 0) {
            return;
        }
        OrganizationalUnit organizationalUnit = this.sortedOrganizationalUnits.get(selectedOrganizationalUnitIndex);
        if (Window.confirm((String)OrganizationalUnitManagerConstants.INSTANCE.ConfirmOrganizationalUnitDeletion0(organizationalUnit.getName()))) {
            this.presenter.deleteOrganizationalUnit(organizationalUnit);
        }
    }

    @UiHandler(value={"btnEditOrganizationalUnit"})
    public void onClickEditOrganizationalUnitButton(ClickEvent event) {
        int selectedOrganizationalUnitIndex = this.lstOrganizationalUnits.getSelectedIndex();
        if (selectedOrganizationalUnitIndex < 0) {
            return;
        }
        OrganizationalUnit organizationalUnit = this.sortedOrganizationalUnits.get(selectedOrganizationalUnitIndex);
        this.presenter.editOrganizationalUnit(organizationalUnit);
    }

    @UiHandler(value={"btnAddRepository"})
    public void onClickAddRepositoryButton(ClickEvent event) {
        Repository selectedRepository;
        OrganizationalUnit selectedOrganizationalUnit;
        int selectedOrganizationalUnitIndex = this.lstOrganizationalUnits.getSelectedIndex();
        OrganizationalUnit organizationalUnit = selectedOrganizationalUnit = selectedOrganizationalUnitIndex < 0 ? null : this.sortedOrganizationalUnits.get(selectedOrganizationalUnitIndex);
        if (selectedOrganizationalUnit == null) {
            return;
        }
        int selectedRepositoryIndex = this.lstAvailableRepositories.getSelectedIndex();
        Repository repository = selectedRepository = selectedRepositoryIndex < 0 ? null : this.sortedAvailableRepositories.get(selectedRepositoryIndex);
        if (selectedRepository == null) {
            return;
        }
        this.presenter.addOrganizationalUnitRepository(selectedOrganizationalUnit, selectedRepository);
    }

    @UiHandler(value={"btnRemoveRepository"})
    public void onClickRemoveRepositoryButton(ClickEvent event) {
        Repository selectedRepository;
        OrganizationalUnit selectedOrganizationalUnit;
        int selectedOrganizationalUnitIndex = this.lstOrganizationalUnits.getSelectedIndex();
        OrganizationalUnit organizationalUnit = selectedOrganizationalUnit = selectedOrganizationalUnitIndex < 0 ? null : this.sortedOrganizationalUnits.get(selectedOrganizationalUnitIndex);
        if (selectedOrganizationalUnit == null) {
            return;
        }
        int selectedRepositoryIndex = this.lstOrganizationalUnitRepositories.getSelectedIndex();
        Repository repository = selectedRepository = selectedRepositoryIndex < 0 ? null : this.sortedOrganizationalUnitRepositories.get(selectedRepositoryIndex);
        if (selectedRepository == null) {
            return;
        }
        this.presenter.removeOrganizationalUnitRepository(selectedOrganizationalUnit, selectedRepository);
    }

    static interface OrganizationalUnitManagerViewBinder
    extends UiBinder<Widget, OrganizationalUnitManagerViewImpl> {
    }
}

