/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.organizationalunit.manager.client.editor;

import com.google.gwt.user.client.Command;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerPresenter;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerView;
import org.guvnor.organizationalunit.manager.client.editor.popups.AddOrganizationalUnitPopup;
import org.guvnor.organizationalunit.manager.client.editor.popups.EditOrganizationalUnitPopup;
import org.guvnor.organizationalunit.manager.client.resources.i18n.OrganizationalUnitManagerConstants;
import org.guvnor.structure.client.security.OrganizationalUnitController;
import org.guvnor.structure.config.SystemRepositoryChangedEvent;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterDeleteOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.NewRepositoryEvent;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryRemovedEvent;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.security.annotations.ResourceCheck;

@ApplicationScoped
@WorkbenchScreen(identifier="org.kie.workbench.common.screens.organizationalunit.manager.OrganizationalUnitManager")
public class OrganizationalUnitManagerPresenterImpl
implements OrganizationalUnitManagerPresenter {
    private OrganizationalUnitManagerView view;
    private Caller<OrganizationalUnitService> organizationalUnitService;
    private Caller<RepositoryService> repositoryService;
    private AddOrganizationalUnitPopup addOrganizationalUnitPopup;
    private EditOrganizationalUnitPopup editOrganizationalUnitPopup;
    private Event<AfterCreateOrganizationalUnitEvent> createOUEvent;
    private Event<AfterDeleteOrganizationalUnitEvent> deleteOUEvent;
    private Collection<Repository> allRepositories;
    private Collection<OrganizationalUnit> allOrganizationalUnits;
    private OrganizationalUnitController controller;

    public OrganizationalUnitManagerPresenterImpl() {
    }

    @Inject
    public OrganizationalUnitManagerPresenterImpl(OrganizationalUnitManagerView view, Caller<OrganizationalUnitService> organizationalUnitService, Caller<RepositoryService> repositoryService, OrganizationalUnitController organizationalUnitController, AddOrganizationalUnitPopup addOrganizationalUnitPopup, EditOrganizationalUnitPopup editOrganizationalUnitPopup, Event<AfterCreateOrganizationalUnitEvent> createOUEvent, Event<AfterDeleteOrganizationalUnitEvent> deleteOUEvent) {
        this.view = (OrganizationalUnitManagerView)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        this.organizationalUnitService = (Caller)PortablePreconditions.checkNotNull((String)"organizationalUnitService", organizationalUnitService);
        this.repositoryService = (Caller)PortablePreconditions.checkNotNull((String)"repositoryService", repositoryService);
        this.controller = (OrganizationalUnitController)PortablePreconditions.checkNotNull((String)"organizationalUnitController", (Object)organizationalUnitController);
        this.addOrganizationalUnitPopup = (AddOrganizationalUnitPopup)((Object)PortablePreconditions.checkNotNull((String)"addOrganizationalUnitPopup", (Object)((Object)addOrganizationalUnitPopup)));
        this.editOrganizationalUnitPopup = (EditOrganizationalUnitPopup)((Object)PortablePreconditions.checkNotNull((String)"editOrganizationalUnitPopup", (Object)((Object)editOrganizationalUnitPopup)));
        this.createOUEvent = (Event)PortablePreconditions.checkNotNull((String)"createOUEvent", createOUEvent);
        this.deleteOUEvent = (Event)PortablePreconditions.checkNotNull((String)"deleteOUEvent", deleteOUEvent);
    }

    @PostConstruct
    public void setup() {
        this.addOrganizationalUnitPopup.init(this);
        this.editOrganizationalUnitPopup.init(this);
    }

    @OnStartup
    public void onStartup() {
        this.view.reset();
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        this.view.setAddOrganizationalUnitEnabled(this.controller.canCreateOrgUnits());
        this.view.setEditOrganizationalUnitEnabled(false);
        this.view.setDeleteOrganizationalUnitEnabled(false);
        ((RepositoryService)this.repositoryService.call((RemoteCallback)new RemoteCallback<Collection<Repository>>(){

            public void callback(Collection<Repository> repositories) {
                OrganizationalUnitManagerPresenterImpl.this.allRepositories = repositories;
                OrganizationalUnitManagerPresenterImpl.this.loadOrganizationalUnits();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).getRepositories();
    }

    @OnOpen
    public void onOpen() {
        this.view.reset();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return OrganizationalUnitManagerConstants.INSTANCE.OrganizationalUnitManagerTitle();
    }

    @WorkbenchPartView
    public UberView<OrganizationalUnitManagerPresenter> getView() {
        return this.view;
    }

    private Collection<Repository> getAllowedRepositories(Collection<Repository> repositories) {
        ArrayList<Repository> available = new ArrayList<Repository>();
        for (Repository repo : repositories) {
            if (!this.controller.canReadRepository(repo)) continue;
            available.add(repo);
        }
        return available;
    }

    @Override
    public void loadOrganizationalUnits() {
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Collection<OrganizationalUnit>>(){

            public void callback(Collection<OrganizationalUnit> organizationalUnits) {
                OrganizationalUnitManagerPresenterImpl.this.allOrganizationalUnits = organizationalUnits;
                OrganizationalUnitManagerPresenterImpl.this.view.setOrganizationalUnits(organizationalUnits);
                OrganizationalUnitManagerPresenterImpl.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).getOrganizationalUnits();
    }

    @Override
    @ResourceCheck(action="read")
    public void organizationalUnitSelected(OrganizationalUnit organizationalUnit) {
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<OrganizationalUnit>(){

            public void callback(OrganizationalUnit organizationalUnit) {
                Collection onlyAllowed = OrganizationalUnitManagerPresenterImpl.this.getAllowedRepositories(organizationalUnit.getRepositories());
                OrganizationalUnitManagerPresenterImpl.this.view.setOrganizationalUnitRepositories(onlyAllowed, OrganizationalUnitManagerPresenterImpl.this.getAvailableRepositories());
                OrganizationalUnitManagerPresenterImpl.this.view.setEditOrganizationalUnitEnabled(OrganizationalUnitManagerPresenterImpl.this.controller.canUpdateOrgUnit(organizationalUnit));
                OrganizationalUnitManagerPresenterImpl.this.view.setDeleteOrganizationalUnitEnabled(OrganizationalUnitManagerPresenterImpl.this.controller.canDeleteOrgUnit(organizationalUnit));
                OrganizationalUnitManagerPresenterImpl.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).getOrganizationalUnit(organizationalUnit.getName());
    }

    private Collection<Repository> getAvailableRepositories() {
        ArrayList<Repository> availableRepositories = new ArrayList<Repository>();
        availableRepositories.addAll(this.allRepositories);
        for (OrganizationalUnit ou : this.allOrganizationalUnits) {
            availableRepositories.removeAll(ou.getRepositories());
        }
        return availableRepositories;
    }

    @Override
    @ResourceCheck(type="orgunit", action="create")
    public void addNewOrganizationalUnit() {
        this.addOrganizationalUnitPopup.show();
    }

    @Override
    public void checkIfOrganizationalUnitExists(String organizationalUnitName, final Command onSuccessCommand, final Command onFailureCommand) {
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<OrganizationalUnit>(){

            public void callback(OrganizationalUnit organizationalUnit) {
                if (organizationalUnit == null) {
                    onSuccessCommand.execute();
                } else {
                    onFailureCommand.execute();
                }
            }
        })).getOrganizationalUnit(organizationalUnitName);
    }

    @Override
    @ResourceCheck(type="orgunit", action="create")
    public void createNewOrganizationalUnit(String organizationalUnitName, String organizationalUnitOwner, String defaultGroupId) {
        ArrayList repositories = new ArrayList();
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<OrganizationalUnit>(){

            public void callback(OrganizationalUnit newOrganizationalUnit) {
                OrganizationalUnitManagerPresenterImpl.this.createOUEvent.fire((Object)new AfterCreateOrganizationalUnitEvent(newOrganizationalUnit));
                OrganizationalUnitManagerPresenterImpl.this.allOrganizationalUnits.add(newOrganizationalUnit);
                OrganizationalUnitManagerPresenterImpl.this.view.addOrganizationalUnit(newOrganizationalUnit);
                OrganizationalUnitManagerPresenterImpl.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).createOrganizationalUnit(organizationalUnitName, organizationalUnitOwner, defaultGroupId, repositories);
    }

    @Override
    @ResourceCheck(action="update")
    public void editOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        this.editOrganizationalUnitPopup.setOrganizationalUnit(organizationalUnit);
        this.editOrganizationalUnitPopup.show();
    }

    @Override
    @ResourceCheck(type="orgunit", action="update")
    public void saveOrganizationalUnit(String organizationalUnitName, String organizationalUnitOwner, String defaultGroupId) {
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<OrganizationalUnit>(){

            public void callback(OrganizationalUnit response) {
                OrganizationalUnitManagerPresenterImpl.this.loadOrganizationalUnits();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).updateOrganizationalUnit(organizationalUnitName, organizationalUnitOwner, defaultGroupId);
    }

    @Override
    @ResourceCheck(action="delete")
    public void deleteOrganizationalUnit(final OrganizationalUnit organizationalUnit) {
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                OrganizationalUnitManagerPresenterImpl.this.deleteOUEvent.fire((Object)new AfterDeleteOrganizationalUnitEvent(organizationalUnit));
                OrganizationalUnitManagerPresenterImpl.this.allOrganizationalUnits.remove(organizationalUnit);
                OrganizationalUnitManagerPresenterImpl.this.view.deleteOrganizationalUnit(organizationalUnit);
                OrganizationalUnitManagerPresenterImpl.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).removeOrganizationalUnit(organizationalUnit.getName());
    }

    @Override
    @ResourceCheck(action="update")
    public void addOrganizationalUnitRepository(final OrganizationalUnit organizationalUnit, Repository repository) {
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        organizationalUnit.getRepositories().add(repository);
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                OrganizationalUnitManagerPresenterImpl.this.view.setOrganizationalUnitRepositories(organizationalUnit.getRepositories(), OrganizationalUnitManagerPresenterImpl.this.getAvailableRepositories());
                OrganizationalUnitManagerPresenterImpl.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).addRepository(organizationalUnit, repository);
    }

    @Override
    @ResourceCheck(action="update")
    public void removeOrganizationalUnitRepository(final OrganizationalUnit organizationalUnit, Repository repository) {
        this.view.showBusyIndicator(OrganizationalUnitManagerConstants.INSTANCE.Wait());
        organizationalUnit.getRepositories().remove(repository);
        ((OrganizationalUnitService)this.organizationalUnitService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void v) {
                OrganizationalUnitManagerPresenterImpl.this.view.setOrganizationalUnitRepositories(organizationalUnit.getRepositories(), OrganizationalUnitManagerPresenterImpl.this.getAvailableRepositories());
                OrganizationalUnitManagerPresenterImpl.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).removeRepository(organizationalUnit, repository);
    }

    @Override
    public void checkValidGroupId(String proposedGroupId, RemoteCallback<Boolean> callback) {
        ((OrganizationalUnitService)this.organizationalUnitService.call(callback, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).isValidGroupId(proposedGroupId);
    }

    @Override
    public void getSanitizedGroupId(String proposedGroupId, RemoteCallback<String> callback) {
        ((OrganizationalUnitService)this.organizationalUnitService.call(callback, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).getSanitizedDefaultGroupId(proposedGroupId);
    }

    public void onRepositoryAddedEvent(@Observes NewRepositoryEvent event) {
        this.onStartup();
    }

    public void onRepositoryRemovedEvent(@Observes RepositoryRemovedEvent event) {
        this.onStartup();
    }

    public void onSystemRepositoryChanged(@Observes SystemRepositoryChangedEvent event) {
        this.onStartup();
    }
}

