/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.organizationalunit.manager.client.editor;

import com.google.gwtmockito.GwtMock;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Collection;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerPresenter;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerPresenterImpl;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerView;
import org.guvnor.organizationalunit.manager.client.editor.popups.AddOrganizationalUnitPopup;
import org.guvnor.organizationalunit.manager.client.editor.popups.EditOrganizationalUnitPopup;
import org.guvnor.structure.events.AfterCreateOrganizationalUnitEvent;
import org.guvnor.structure.events.AfterDeleteOrganizationalUnitEvent;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.OrganizationalUnitService;
import org.guvnor.structure.repositories.RepositoryService;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class OrganizationalUnitManagerPresenterTest {
    @GwtMock
    private AddOrganizationalUnitPopup addOrganizationalUnitPopup;
    @GwtMock
    private EditOrganizationalUnitPopup editOrganizationalUnitPopup;
    @Mock
    private EventSourceMock<AfterCreateOrganizationalUnitEvent> createOUEvent;
    @Mock
    private EventSourceMock<AfterDeleteOrganizationalUnitEvent> deleteOUEvent;
    private OrganizationalUnitManagerView view = (OrganizationalUnitManagerView)Mockito.mock(OrganizationalUnitManagerView.class);
    private OrganizationalUnitService mockOUService = (OrganizationalUnitService)Mockito.mock(OrganizationalUnitService.class);
    private Caller<OrganizationalUnitService> organizationalUnitService = new CallerMock((Object)this.mockOUService);
    private RepositoryService mockRepositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
    private Caller<RepositoryService> repositoryService = new CallerMock((Object)this.mockRepositoryService);
    private OrganizationalUnitManagerPresenter presenter;
    private OrganizationalUnit mockOU = (OrganizationalUnit)Mockito.mock(OrganizationalUnit.class);

    @Before
    public void setup() {
        this.presenter = new OrganizationalUnitManagerPresenterImpl(this.view, this.organizationalUnitService, this.repositoryService, this.addOrganizationalUnitPopup, this.editOrganizationalUnitPopup, this.createOUEvent, this.deleteOUEvent);
        Mockito.when((Object)this.mockOU.getName()).thenReturn((Object)"mock");
        Mockito.when((Object)this.mockOU.getOwner()).thenReturn((Object)"mock");
        Mockito.when((Object)this.mockOU.getDefaultGroupId()).thenReturn((Object)"mock");
        Mockito.when((Object)this.mockOUService.getOrganizationalUnits()).thenReturn(new ArrayList());
        Mockito.when((Object)this.mockOUService.createOrganizationalUnit((String)Mockito.any(String.class), (String)Mockito.any(String.class), (String)Mockito.any(String.class), (Collection)Mockito.any(Collection.class))).thenReturn((Object)this.mockOU);
        this.presenter.loadOrganizationalUnits();
    }

    @Test
    public void testCreateOUEvent() {
        this.presenter.createNewOrganizationalUnit(this.mockOU.getName(), this.mockOU.getOwner(), this.mockOU.getDefaultGroupId());
        ((EventSourceMock)Mockito.verify(this.createOUEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(AfterCreateOrganizationalUnitEvent.class));
    }

    @Test
    public void testDeleteOUEvent() {
        this.presenter.deleteOrganizationalUnit(this.mockOU);
        ((EventSourceMock)Mockito.verify(this.deleteOUEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any(AfterDeleteOrganizationalUnitEvent.class));
    }
}

