/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.organizationalunit.manager.client.editor.popups;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerPresenter;
import org.guvnor.organizationalunit.manager.client.resources.i18n.OrganizationalUnitManagerConstants;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class EditOrganizationalUnitPopup
extends BaseModal
implements UberView<OrganizationalUnitManagerPresenter> {
    private static EditOrganizationalUnitPopupBinder uiBinder = (EditOrganizationalUnitPopupBinder)GWT.create(EditOrganizationalUnitPopupBinder.class);
    @UiField
    TextBox nameTextBox;
    @UiField
    TextBox ownerTextBox;
    @UiField
    ControlGroup defaultGroupIdGroup;
    @UiField
    TextBox defaultGroupIdTextBox;
    @UiField
    HelpInline defaultGroupIdHelpInline;
    @UiField
    Icon groupIdHelpIcon;
    private OrganizationalUnit organizationalUnit;
    private OrganizationalUnitManagerPresenter presenter;
    private final Command okCommand = new Command(){

        public void execute() {
            EditOrganizationalUnitPopup.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            EditOrganizationalUnitPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);

    public EditOrganizationalUnitPopup() {
        this.setTitle(OrganizationalUnitManagerConstants.INSTANCE.EditOrganizationalUnitPopupTitle());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        this.groupIdHelpIcon.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
        this.groupIdHelpIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
    }

    public void init(OrganizationalUnitManagerPresenter presenter) {
        this.presenter = presenter;
    }

    private void onOKButtonClick() {
        if (this.defaultGroupIdTextBox.getText() == null || this.defaultGroupIdTextBox.getText().trim().isEmpty()) {
            this.defaultGroupIdGroup.setType(ControlGroupType.ERROR);
            this.defaultGroupIdHelpInline.setText(OrganizationalUnitManagerConstants.INSTANCE.DefaultGroupIdIsMandatory());
            return;
        }
        this.presenter.checkValidGroupId(this.defaultGroupIdTextBox.getText(), new RemoteCallback<Boolean>(){

            public void callback(Boolean valid) {
                if (!valid.booleanValue()) {
                    EditOrganizationalUnitPopup.this.defaultGroupIdGroup.setType(ControlGroupType.ERROR);
                    EditOrganizationalUnitPopup.this.defaultGroupIdHelpInline.setText(OrganizationalUnitManagerConstants.INSTANCE.InvalidGroupId());
                    return;
                }
                EditOrganizationalUnitPopup.this.presenter.saveOrganizationalUnit(EditOrganizationalUnitPopup.this.nameTextBox.getText(), EditOrganizationalUnitPopup.this.ownerTextBox.getText(), EditOrganizationalUnitPopup.this.defaultGroupIdTextBox.getText());
                EditOrganizationalUnitPopup.this.hide();
            }
        });
    }

    public void setOrganizationalUnit(OrganizationalUnit organizationalUnit) {
        this.organizationalUnit = organizationalUnit;
    }

    public void show() {
        this.defaultGroupIdGroup.setType(ControlGroupType.NONE);
        this.defaultGroupIdHelpInline.setText("");
        if (this.organizationalUnit == null) {
            this.nameTextBox.setText("");
            this.defaultGroupIdTextBox.setText("");
            this.ownerTextBox.setText("");
            super.show();
        } else {
            this.presenter.getSanitizedGroupId(this.organizationalUnit.getName(), new RemoteCallback<String>(){

                public void callback(String sanitizedGroupId) {
                    EditOrganizationalUnitPopup.this.nameTextBox.setText(EditOrganizationalUnitPopup.this.organizationalUnit.getName());
                    if (EditOrganizationalUnitPopup.this.organizationalUnit.getDefaultGroupId() == null || EditOrganizationalUnitPopup.this.organizationalUnit.getDefaultGroupId().trim().isEmpty()) {
                        EditOrganizationalUnitPopup.this.defaultGroupIdTextBox.setText(sanitizedGroupId);
                    } else {
                        EditOrganizationalUnitPopup.this.defaultGroupIdTextBox.setText(EditOrganizationalUnitPopup.this.organizationalUnit.getDefaultGroupId());
                    }
                    EditOrganizationalUnitPopup.this.ownerTextBox.setText(EditOrganizationalUnitPopup.this.organizationalUnit.getOwner());
                    EditOrganizationalUnitPopup.super.show();
                }
            });
        }
    }

    static interface EditOrganizationalUnitPopupBinder
    extends UiBinder<Widget, EditOrganizationalUnitPopup> {
    }
}

