/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.organizationalunit.manager.client.editor.popups;

import com.github.gwtbootstrap.client.ui.ControlGroup;
import com.github.gwtbootstrap.client.ui.HelpInline;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.ControlGroupType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import org.guvnor.organizationalunit.manager.client.editor.OrganizationalUnitManagerPresenter;
import org.guvnor.organizationalunit.manager.client.resources.i18n.OrganizationalUnitManagerConstants;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.widgets.common.client.common.popups.BaseModal;
import org.uberfire.ext.widgets.common.client.common.popups.footers.ModalFooterOKCancelButtons;

public class AddOrganizationalUnitPopup
extends BaseModal
implements UberView<OrganizationalUnitManagerPresenter> {
    private static AddOrganizationalUnitPopupBinder uiBinder = (AddOrganizationalUnitPopupBinder)GWT.create(AddOrganizationalUnitPopupBinder.class);
    @UiField
    ControlGroup nameGroup;
    @UiField
    TextBox nameTextBox;
    @UiField
    HelpInline nameHelpInline;
    @UiField
    ControlGroup defaultGroupIdGroup;
    @UiField
    TextBox defaultGroupIdTextBox;
    @UiField
    HelpInline defaultGroupIdHelpInline;
    @UiField
    Icon groupIdHelpIcon;
    @UiField
    TextBox ownerTextBox;
    private OrganizationalUnitManagerPresenter presenter;
    private final Command okCommand = new Command(){

        public void execute() {
            AddOrganizationalUnitPopup.this.onOKButtonClick();
        }
    };
    private final Command cancelCommand = new Command(){

        public void execute() {
            AddOrganizationalUnitPopup.this.hide();
        }
    };
    private final ModalFooterOKCancelButtons footer = new ModalFooterOKCancelButtons(this.okCommand, this.cancelCommand);
    private boolean groupIdManuallyChanged = false;

    public AddOrganizationalUnitPopup() {
        this.setTitle(OrganizationalUnitManagerConstants.INSTANCE.AddOrganizationalUnitPopupTitle());
        this.add((Widget)uiBinder.createAndBindUi((Object)this));
        this.add((Widget)this.footer);
        this.groupIdHelpIcon.getElement().getStyle().setPaddingLeft(5.0, Style.Unit.PX);
        this.groupIdHelpIcon.getElement().getStyle().setCursor(Style.Cursor.POINTER);
        this.nameTextBox.addKeyPressHandler(new KeyPressHandler(){

            public void onKeyPress(KeyPressEvent event) {
                AddOrganizationalUnitPopup.this.nameGroup.setType(ControlGroupType.NONE);
                AddOrganizationalUnitPopup.this.nameHelpInline.setText("");
            }
        });
    }

    public void init(OrganizationalUnitManagerPresenter presenter) {
        this.presenter = presenter;
    }

    @UiHandler(value={"nameTextBox"})
    void nameChanged(ValueChangeEvent<String> event) {
        if (!this.groupIdManuallyChanged) {
            if (this.nameTextBox.getText() == null || this.nameTextBox.getText().trim().isEmpty()) {
                this.defaultGroupIdTextBox.setText("");
            } else {
                this.presenter.getSanitizedGroupId(this.nameTextBox.getText(), new RemoteCallback<String>(){

                    public void callback(String sanitizedGroupId) {
                        AddOrganizationalUnitPopup.this.defaultGroupIdTextBox.setText(sanitizedGroupId);
                    }
                });
            }
        }
    }

    @UiHandler(value={"defaultGroupIdTextBox"})
    void groupIdChangedChanged(ValueChangeEvent<String> event) {
        String input = this.defaultGroupIdTextBox.getText();
        this.groupIdManuallyChanged = input != null && !input.trim().isEmpty() && !input.trim().equals(this.nameTextBox.getText());
    }

    private void onOKButtonClick() {
        this.nameGroup.setType(ControlGroupType.NONE);
        if (this.nameTextBox.getText() == null || this.nameTextBox.getText().trim().isEmpty()) {
            this.nameGroup.setType(ControlGroupType.ERROR);
            this.nameHelpInline.setText(OrganizationalUnitManagerConstants.INSTANCE.OrganizationalUnitNameIsMandatory());
            return;
        }
        if (this.defaultGroupIdTextBox.getText() == null || this.defaultGroupIdTextBox.getText().trim().isEmpty()) {
            this.defaultGroupIdGroup.setType(ControlGroupType.ERROR);
            this.defaultGroupIdHelpInline.setText(OrganizationalUnitManagerConstants.INSTANCE.DefaultGroupIdIsMandatory());
            return;
        }
        this.presenter.checkValidGroupId(this.defaultGroupIdTextBox.getText(), new RemoteCallback<Boolean>(){

            public void callback(Boolean valid) {
                if (!valid.booleanValue()) {
                    AddOrganizationalUnitPopup.this.defaultGroupIdGroup.setType(ControlGroupType.ERROR);
                    AddOrganizationalUnitPopup.this.defaultGroupIdHelpInline.setText(OrganizationalUnitManagerConstants.INSTANCE.InvalidGroupId());
                    return;
                }
                AddOrganizationalUnitPopup.this.presenter.checkIfOrganizationalUnitExists(AddOrganizationalUnitPopup.this.nameTextBox.getText(), new Command(){

                    public void execute() {
                        AddOrganizationalUnitPopup.this.onOKSuccess();
                    }
                }, new Command(){

                    public void execute() {
                        AddOrganizationalUnitPopup.this.nameGroup.setType(ControlGroupType.ERROR);
                        AddOrganizationalUnitPopup.this.nameHelpInline.setText(OrganizationalUnitManagerConstants.INSTANCE.OrganizationalUnitAlreadyExists());
                    }
                });
            }
        });
    }

    private void onOKSuccess() {
        this.presenter.createNewOrganizationalUnit(this.nameTextBox.getText(), this.ownerTextBox.getText(), this.defaultGroupIdTextBox.getText());
        this.hide();
    }

    public void show() {
        this.nameTextBox.setText("");
        this.nameGroup.setType(ControlGroupType.NONE);
        this.nameHelpInline.setText("");
        this.defaultGroupIdTextBox.setText("");
        this.defaultGroupIdGroup.setType(ControlGroupType.NONE);
        this.defaultGroupIdHelpInline.setText("");
        this.groupIdManuallyChanged = false;
        this.ownerTextBox.setText("");
        super.show();
    }

    static interface AddOrganizationalUnitPopupBinder
    extends UiBinder<Widget, AddOrganizationalUnitPopup> {
    }
}

