package org.gtk.glib

import glib.*

/**
 * gtk-kt
 *
 * 09 / 10 / 2021
 *
 * @see <a href=""></a>
 */
enum class VariantClass(val glib: GVariantClass) {
	BOOLEAN(G_VARIANT_CLASS_BOOLEAN),
	BYTE(G_VARIANT_CLASS_BYTE),
	SHORT(G_VARIANT_CLASS_INT16),
	USHORT(G_VARIANT_CLASS_UINT16),
	INT(G_VARIANT_CLASS_INT32),
	UINT(G_VARIANT_CLASS_UINT32),
	LONG(G_VARIANT_CLASS_INT64),
	ULONG(G_VARIANT_CLASS_UINT64),
	HANDLE(G_VARIANT_CLASS_HANDLE),
	DOUBLE(G_VARIANT_CLASS_DOUBLE),
	STRING(G_VARIANT_CLASS_STRING),
	OBJECT_PATH(G_VARIANT_CLASS_OBJECT_PATH),
	SIGNATURE(G_VARIANT_CLASS_SIGNATURE),
	VARIANT(G_VARIANT_CLASS_VARIANT),
	MAYBE(G_VARIANT_CLASS_MAYBE),
	ARRAY(G_VARIANT_CLASS_ARRAY),
	TUPLE(G_VARIANT_CLASS_TUPLE),
	DICT_ENTRY(G_VARIANT_CLASS_DICT_ENTRY);

	companion object {
		inline fun valueOf(glib: GVariantClass): VariantClass? =
			values().find { it.glib == glib }
	}
}