/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneFile;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneInputStream;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;

public class GridLuceneOutputStream
extends IndexOutput {
    static final int BUFFER_SIZE = 32768;
    private GridLuceneFile file;
    private long currBuf;
    private int currBufIdx;
    private int bufPosition;
    private long bufStart;
    private int bufLength;
    private final GridUnsafeMemory mem;

    public GridLuceneOutputStream(GridLuceneFile f) {
        this.file = f;
        this.mem = f.getDirectory().memory();
        this.currBufIdx = -1;
        this.currBuf = 0L;
    }

    public void reset() {
        this.currBuf = 0L;
        this.currBufIdx = -1;
        this.bufPosition = 0;
        this.bufStart = 0L;
        this.bufLength = 0;
        this.file.setLength(0L);
    }

    public void close() throws IOException {
        this.flush();
    }

    public void seek(long pos) throws IOException {
        this.setFileLength();
        if (pos < this.bufStart || pos >= this.bufStart + (long)this.bufLength) {
            this.currBufIdx = (int)(pos / 32768L);
            this.switchCurrentBuffer();
        }
        this.bufPosition = (int)(pos % 32768L);
    }

    public long length() {
        return this.file.getLength();
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufPosition == this.bufLength) {
            ++this.currBufIdx;
            this.switchCurrentBuffer();
        }
        this.mem.writeByte(this.currBuf + (long)this.bufPosition++, b);
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        assert (b != null);
        while (len > 0) {
            int remainInBuf;
            if (this.bufPosition == this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer();
            }
            int bytesToCp = len < (remainInBuf = 32768 - this.bufPosition) ? len : remainInBuf;
            this.mem.writeBytes(this.currBuf + (long)this.bufPosition, b, offset, bytesToCp);
            offset += bytesToCp;
            len -= bytesToCp;
            this.bufPosition += bytesToCp;
        }
    }

    private void switchCurrentBuffer() {
        this.currBuf = this.currBufIdx == this.file.numBuffers() ? this.file.addBuffer() : this.file.getBuffer(this.currBufIdx);
        this.bufPosition = 0;
        this.bufStart = 32768L * (long)this.currBufIdx;
        this.bufLength = 32768;
    }

    private void setFileLength() {
        long pointer = this.bufStart + (long)this.bufPosition;
        if (pointer > this.file.getLength()) {
            this.file.setLength(pointer);
        }
    }

    public void flush() throws IOException {
        this.setFileLength();
    }

    public long getFilePointer() {
        return this.currBufIdx < 0 ? 0L : this.bufStart + (long)this.bufPosition;
    }

    public long sizeInBytes() {
        return (long)this.file.numBuffers() * 32768L;
    }

    public void copyBytes(DataInput input, long numBytes) throws IOException {
        GridLuceneInputStream gridInput;
        assert (numBytes >= 0L) : "numBytes=" + numBytes;
        GridLuceneInputStream gridLuceneInputStream = gridInput = input instanceof GridLuceneInputStream ? (GridLuceneInputStream)input : null;
        while (numBytes > 0L) {
            int toCp;
            if (this.bufPosition == this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer();
            }
            if (numBytes < (long)(toCp = 32768 - this.bufPosition)) {
                toCp = (int)numBytes;
            }
            if (gridInput != null) {
                gridInput.readBytes(this.currBuf + (long)this.bufPosition, toCp);
            } else {
                byte[] buff = new byte[toCp];
                input.readBytes(buff, 0, toCp, false);
                this.mem.writeBytes(this.currBuf + (long)this.bufPosition, buff);
            }
            numBytes -= (long)toCp;
            this.bufPosition += toCp;
        }
    }

    void writeBytes(long ptr, int len) throws IOException {
        while (len > 0) {
            int remainInBuf;
            if (this.bufPosition == this.bufLength) {
                ++this.currBufIdx;
                this.switchCurrentBuffer();
            }
            int bytesToCp = len < (remainInBuf = 32768 - this.bufPosition) ? len : remainInBuf;
            this.mem.copyMemory(ptr, this.currBuf + (long)this.bufPosition, (long)bytesToCp);
            ptr += (long)bytesToCp;
            len -= bytesToCp;
            this.bufPosition += bytesToCp;
        }
    }
}

