/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.io.Closeable;
import java.io.IOException;
import java.util.BitSet;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Base64;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermRangeFilter;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.gridgain.grid.GridException;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.indexing.GridIndexDescriptor;
import org.gridgain.grid.spi.indexing.GridIndexType;
import org.gridgain.grid.spi.indexing.GridIndexingEntity;
import org.gridgain.grid.spi.indexing.GridIndexingEntityAdapter;
import org.gridgain.grid.spi.indexing.GridIndexingKeyValueRow;
import org.gridgain.grid.spi.indexing.GridIndexingKeyValueRowAdapter;
import org.gridgain.grid.spi.indexing.GridIndexingMarshaller;
import org.gridgain.grid.spi.indexing.GridIndexingQueryFilter;
import org.gridgain.grid.spi.indexing.GridIndexingTypeDescriptor;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneDirectory;
import org.gridgain.grid.util.GridAtomicLong;
import org.gridgain.grid.util.GridCloseableIteratorAdapter;
import org.gridgain.grid.util.lang.GridCloseableIterator;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridLuceneIndex
implements Closeable {
    private final GridIndexingMarshaller marshaller;
    private final String spaceName;
    private final GridIndexingTypeDescriptor type;
    private final IndexWriter writer;
    private final String[] idxdFields;
    private final boolean storeVal;
    private final BitSet keyFields = new BitSet();
    private final AtomicLong updateCntr = new GridAtomicLong();
    private final GridLuceneDirectory dir;

    public GridLuceneIndex(GridIndexingMarshaller marshaller, @Nullable GridUnsafeMemory mem, @Nullable String spaceName, GridIndexingTypeDescriptor type, boolean storeVal) throws GridSpiException {
        this.marshaller = marshaller;
        this.spaceName = spaceName;
        this.type = type;
        this.storeVal = storeVal;
        this.dir = new GridLuceneDirectory(mem == null ? new GridUnsafeMemory(0L) : mem);
        try {
            this.writer = new IndexWriter((Directory)this.dir, new IndexWriterConfig(Version.LUCENE_30, (Analyzer)new StandardAnalyzer(Version.LUCENE_30)));
        }
        catch (IOException e) {
            throw new GridSpiException((Throwable)e);
        }
        GridIndexDescriptor idx = null;
        for (GridIndexDescriptor descriptor : type.indexes().values()) {
            if (descriptor.type() != GridIndexType.FULLTEXT) continue;
            idx = descriptor;
            break;
        }
        if (idx != null) {
            Collection fields = idx.fields();
            this.idxdFields = new String[fields.size() + 1];
            fields.toArray(this.idxdFields);
            int len = fields.size();
            for (int i = 0; i < len; ++i) {
                this.keyFields.set(i, type.keyFields().containsKey(this.idxdFields[i]));
            }
        } else {
            assert (type.valueTextIndex() || type.valueClass() == String.class);
            this.idxdFields = new String[1];
        }
        this.idxdFields[this.idxdFields.length - 1] = "_gg_val_str__";
    }

    public void store(GridIndexingEntity<?> key, GridIndexingEntity<?> val, byte[] ver, long expires) throws GridSpiException {
        Document doc = new Document();
        Object k = key.value();
        Object v = val.value();
        boolean stringsFound = false;
        if (this.type.valueTextIndex() || this.type.valueClass() == String.class) {
            doc.add((Fieldable)new Field("_gg_val_str__", v.toString(), Field.Store.YES, Field.Index.ANALYZED));
            stringsFound = true;
        }
        int last = this.idxdFields.length - 1;
        for (int i = 0; i < last; ++i) {
            Object fieldVal = this.type.value(this.keyFields.get(i) ? k : v, this.idxdFields[i]);
            if (fieldVal == null) continue;
            doc.add((Fieldable)new Field(this.idxdFields[i], fieldVal.toString(), Field.Store.YES, Field.Index.ANALYZED));
            stringsFound = true;
        }
        if (!stringsFound) {
            return;
        }
        doc.add((Fieldable)new Field("_key", Base64.encodeBase64String((byte[])this.marshaller.marshal(key)), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (this.storeVal && this.type.valueClass() != String.class) {
            doc.add((Fieldable)new Field("_val", this.marshaller.marshal(val)));
        }
        doc.add((Fieldable)new Field("_gg_ver__", ver));
        doc.add((Fieldable)new Field("_gg_expires__", DateTools.timeToString((long)expires, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
        try {
            this.writer.addDocument(doc);
            this.updateCntr.incrementAndGet();
        }
        catch (IOException e) {
            throw new GridSpiException((Throwable)e);
        }
    }

    public void remove(GridIndexingEntity<?> key) throws GridSpiException {
        try {
            this.writer.deleteDocuments(new Term("_key", Base64.encodeBase64String((byte[])this.marshaller.marshal(key))));
            this.updateCntr.incrementAndGet();
        }
        catch (IOException e) {
            throw new GridSpiException((Throwable)e);
        }
    }

    public <K, V> GridCloseableIterator<GridIndexingKeyValueRow<K, V>> query(String qry, GridIndexingQueryFilter<K, V>[] filters) throws GridSpiException {
        TopDocs docs;
        IndexReader reader;
        try {
            long updates = this.updateCntr.get();
            if (updates != 0L) {
                this.writer.commit();
                this.updateCntr.addAndGet(-updates);
            }
            reader = IndexReader.open((IndexWriter)this.writer, (boolean)true);
        }
        catch (IOException e) {
            throw new GridSpiException((Throwable)e);
        }
        IndexSearcher searcher = new IndexSearcher(reader);
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_30, this.idxdFields, this.writer.getAnalyzer());
        TermRangeFilter f = new TermRangeFilter("_gg_expires__", DateTools.timeToString((long)U.currentTimeMillis(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), null, false, false);
        try {
            docs = searcher.search(parser.parse(qry), (Filter)f, Integer.MAX_VALUE);
        }
        catch (Exception e) {
            throw new GridSpiException((Throwable)e);
        }
        return new It(reader, searcher, docs.scoreDocs, filters);
    }

    @Override
    public void close() {
        U.closeQuiet((Closeable)this.writer);
        U.closeQuiet((Closeable)((Object)this.dir));
    }

    private class It<K, V>
    extends GridCloseableIteratorAdapter<GridIndexingKeyValueRow<K, V>> {
        private static final long serialVersionUID = 0L;
        private final IndexReader reader;
        private final IndexSearcher searcher;
        private final ScoreDoc[] docs;
        private final GridIndexingQueryFilter<K, V>[] filters;
        private int idx;
        private GridIndexingKeyValueRow<K, V> curr;

        private It(IndexReader reader, IndexSearcher searcher, ScoreDoc[] docs, GridIndexingQueryFilter<K, V>[] filters) throws GridSpiException {
            this.reader = reader;
            this.searcher = searcher;
            this.docs = docs;
            this.filters = filters;
            this.findNext();
        }

        private boolean filter(K key, V val) {
            if (!F.isEmpty((Object[])this.filters)) {
                for (GridIndexingQueryFilter<K, V> f : this.filters) {
                    if (f.apply(GridLuceneIndex.this.spaceName, key, val)) continue;
                    return false;
                }
            }
            return true;
        }

        private void findNext() throws GridSpiException {
            this.curr = null;
            while (this.idx < this.docs.length) {
                GridIndexingEntity v;
                Document doc;
                try {
                    doc = this.searcher.doc(this.docs[this.idx++].doc);
                }
                catch (IOException e) {
                    throw new GridSpiException((Throwable)e);
                }
                String keyStr = doc.get("_key");
                GridIndexingEntity k = GridLuceneIndex.this.marshaller.unmarshal(Base64.decodeBase64((String)keyStr));
                byte[] valBytes = doc.getBinaryValue("_val");
                Object object = v = valBytes != null ? GridLuceneIndex.this.marshaller.unmarshal(valBytes) : (GridLuceneIndex.this.type.valueClass() == String.class ? new GridIndexingEntityAdapter((Object)doc.get("_gg_val_str__"), null) : null);
                if (!this.filter(k.value(), v == null ? null : v.value())) continue;
                byte[] ver = doc.getBinaryValue("_gg_ver__");
                this.curr = new GridIndexingKeyValueRowAdapter(k, v, ver);
                break;
            }
        }

        protected GridIndexingKeyValueRow<K, V> onNext() throws GridException {
            GridIndexingKeyValueRow<K, V> res = this.curr;
            this.findNext();
            return res;
        }

        protected boolean onHasNext() throws GridException {
            return this.curr != null;
        }

        protected void onClose() throws GridException {
            U.closeQuiet((Closeable)this.searcher);
            U.closeQuiet((Closeable)this.reader);
        }
    }
}

