/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneDirectory;

public class GridLuceneFile
implements Serializable {
    private static final long serialVersionUID = 0L;
    public static final AtomicInteger filesCnt = new AtomicInteger();
    private LongArray buffers = new LongArray();
    private long length;
    private final GridLuceneDirectory dir;
    private volatile long sizeInBytes;

    GridLuceneFile(GridLuceneDirectory dir) {
        this.dir = dir;
        filesCnt.incrementAndGet();
    }

    public synchronized long getLength() {
        return this.length;
    }

    protected synchronized void setLength(long length) {
        this.length = length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final long addBuffer() {
        long buf = this.newBuffer();
        GridLuceneFile gridLuceneFile = this;
        synchronized (gridLuceneFile) {
            this.buffers.add(buf);
            this.sizeInBytes += 32768L;
        }
        if (this.dir != null) {
            this.dir.sizeInBytes.getAndAdd(32768L);
        }
        return buf;
    }

    protected final synchronized long getBuffer(int idx) {
        return this.buffers.get(idx);
    }

    protected final synchronized int numBuffers() {
        return this.buffers.size();
    }

    protected long newBuffer() {
        return this.dir.memory().allocate(32768L);
    }

    public synchronized void delete() {
        if (this.buffers == null) {
            return;
        }
        for (int i = 0; i < this.buffers.idx; ++i) {
            this.dir.memory().release(this.buffers.arr[i], 32768L);
        }
        this.buffers = null;
        filesCnt.decrementAndGet();
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public GridLuceneDirectory getDirectory() {
        return this.dir;
    }

    private static class LongArray {
        private long[] arr = new long[128];
        private int idx;

        private LongArray() {
        }

        int size() {
            return this.idx;
        }

        long get(int idx) {
            assert (idx < this.idx);
            return this.arr[idx];
        }

        void add(long val) {
            int len = this.arr.length;
            if (this.idx == len) {
                this.arr = Arrays.copyOf(this.arr, Math.min(len * 2, len + 1024));
            }
            this.arr[this.idx++] = val;
        }
    }
}

