/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneFile;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneInputStream;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneLockFactory;
import org.gridgain.grid.spi.indexing.h2.opt.GridLuceneOutputStream;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;

public class GridLuceneDirectory
extends Directory {
    protected final Map<String, GridLuceneFile> fileMap = new ConcurrentHashMap<String, GridLuceneFile>();
    protected final AtomicLong sizeInBytes = new AtomicLong();
    private final GridUnsafeMemory mem;

    public GridLuceneDirectory(GridUnsafeMemory mem) {
        this.mem = mem;
        try {
            this.setLockFactory(new GridLuceneLockFactory());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public final String[] listAll() {
        this.ensureOpen();
        Set<String> fileNames = this.fileMap.keySet();
        ArrayList<String> names = new ArrayList<String>(fileNames.size());
        for (String name : fileNames) {
            names.add(name);
        }
        return names.toArray(new String[names.size()]);
    }

    public final boolean fileExists(String name) {
        this.ensureOpen();
        return this.fileMap.containsKey(name);
    }

    public final long fileModified(String name) {
        this.ensureOpen();
        throw new IllegalStateException(name);
    }

    public void touchFile(String name) throws IOException {
        this.ensureOpen();
        throw new IllegalStateException(name);
    }

    public final long fileLength(String name) throws IOException {
        this.ensureOpen();
        GridLuceneFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        this.doDeleteFile(name);
    }

    private void doDeleteFile(String name) throws IOException {
        GridLuceneFile file = this.fileMap.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        file.delete();
        this.sizeInBytes.addAndGet(-file.getSizeInBytes());
    }

    public IndexOutput createOutput(String name) throws IOException {
        this.ensureOpen();
        GridLuceneFile file = this.newRAMFile();
        GridLuceneFile existing = this.fileMap.remove(name);
        if (existing != null) {
            this.sizeInBytes.addAndGet(-existing.getSizeInBytes());
            existing.delete();
        }
        this.fileMap.put(name, file);
        return new GridLuceneOutputStream(file);
    }

    protected GridLuceneFile newRAMFile() {
        return new GridLuceneFile(this);
    }

    public IndexInput openInput(String name) throws IOException {
        this.ensureOpen();
        GridLuceneFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new GridLuceneInputStream(name, file);
    }

    public void close() {
        this.isOpen = false;
        for (String fileName : this.fileMap.keySet()) {
            try {
                this.doDeleteFile(fileName);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        assert (this.fileMap.isEmpty());
    }

    GridUnsafeMemory memory() {
        return this.mem;
    }
}

