/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2AbstractKeyValueRow;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Cursor;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2IndexBase;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2KeyValueRowOffheap;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Row;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2RowDescriptor;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Table;
import org.gridgain.grid.spi.indexing.h2.opt.GridSearchRowPointer;
import org.gridgain.grid.util.GridEmptyIterator;
import org.gridgain.grid.util.offheap.unsafe.GridOffHeapSmartPointerFactory;
import org.gridgain.grid.util.offheap.unsafe.GridOffHeapSnapTreeMap;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.snaptree.SnapTreeMap;
import org.gridgain.grid.util.typedef.internal.SB;
import org.gridgain.grid.util.typedef.internal.U;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2TreeIndex
extends GridH2IndexBase
implements Comparator<GridSearchRowPointer> {
    protected final ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> tree;
    private final ThreadLocal<ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row>> snapshot = new ThreadLocal();

    public GridH2TreeIndex(String name, GridH2Table tbl, boolean unique, int keyCol, int valCol, final GridUnsafeMemory memory, IndexColumn ... cols) {
        super(keyCol, valCol);
        if (!unique) {
            cols = Arrays.copyOf(cols, cols.length + 1);
            cols[cols.length - 1] = tbl.indexColumn(keyCol, 0);
        }
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        this.initBaseIndex((Table)tbl, 0, name, cols, unique ? IndexType.createUnique((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false));
        final GridH2RowDescriptor desc = tbl.rowDescriptor();
        this.tree = (ConcurrentNavigableMap)(memory == null ? new SnapTreeMap<GridSearchRowPointer, GridH2Row>((Comparator)this){

            protected void afterNodeUpdate_nl(SnapTreeMap.Node<GridSearchRowPointer, GridH2Row> node, Object val) {
                if (val != null) {
                    node.key = (GridSearchRowPointer)val;
                }
            }

            protected Comparable<? super GridSearchRowPointer> comparable(Object key) {
                if (key instanceof ComparableRow) {
                    return (Comparable)key;
                }
                return super.comparable(key);
            }
        } : new GridOffHeapSnapTreeMap<GridSearchRowPointer, GridH2Row>((GridOffHeapSmartPointerFactory)desc, (GridOffHeapSmartPointerFactory)desc, memory, (Comparator)this){

            protected void afterNodeUpdate_nl(long node, GridH2Row val) {
                final long oldKey = this.keyPtr(node);
                if (val != null) {
                    this.key(node, val);
                    memory.finalizeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((GridH2KeyValueRowOffheap)desc.createPointer(oldKey)).decrementRefCount();
                        }
                    });
                }
            }

            protected Comparable<? super GridSearchRowPointer> comparable(Object key) {
                if (key instanceof ComparableRow) {
                    return (Comparable)key;
                }
                return super.comparable(key);
            }
        });
    }

    public void close() {
        if (this.tree instanceof Closeable) {
            U.closeQuiet((Closeable)((Closeable)((Object)this.tree)));
        }
    }

    @Override
    public Object takeSnapshot(@Nullable Object s) {
        assert (this.snapshot.get() == null);
        if (s == null) {
            s = this.tree instanceof SnapTreeMap ? ((SnapTreeMap)this.tree).clone() : ((GridOffHeapSnapTreeMap)this.tree).clone();
        }
        this.snapshot.set((ConcurrentNavigableMap)s);
        return s;
    }

    @Override
    public void releaseSnapshot() {
        ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> s = this.snapshot.get();
        this.snapshot.remove();
        if (s instanceof Closeable) {
            U.closeQuiet((Closeable)((Closeable)((Object)s)));
        }
    }

    private ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> treeForRead() {
        ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> res = this.snapshot.get();
        if (res == null) {
            res = this.tree;
        }
        return res;
    }

    public void close(Session ses) {
        assert (this.snapshot.get() == null);
        if (this.tree instanceof Closeable) {
            U.closeQuiet((Closeable)((Closeable)((Object)this.tree)));
        }
    }

    public long getRowCount(@Nullable Session ses) {
        Iterator<GridH2Row> iter = this.doFind(null, false, null);
        long size = 0L;
        while (iter.hasNext()) {
            iter.next();
            ++size;
        }
        return size;
    }

    public long getRowCountApproximation() {
        return this.tree.size();
    }

    @Override
    public int compare(GridSearchRowPointer r1, GridSearchRowPointer r2) {
        return -this.compareRows(r2, r1);
    }

    public String toString() {
        SB sb = new SB((this.indexType.isUnique() ? "Unique index '" : "Index '") + this.getName() + "' [");
        boolean first = true;
        for (IndexColumn col : this.getIndexColumns()) {
            if (first) {
                first = false;
            } else {
                sb.a(", ");
            }
            sb.a(col.getSQL());
        }
        sb.a(" ]");
        return sb.toString();
    }

    public double getCost(Session ses, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return this.getCostRangeIndex(masks, this.getRowCountApproximation(), filter, sortOrder);
    }

    public boolean canFindNext() {
        return true;
    }

    public Cursor find(Session ses, @Nullable SearchRow first, @Nullable SearchRow last) {
        return new GridH2Cursor(this.doFind(first, true, last));
    }

    public Cursor findNext(Session ses, SearchRow higherThan, SearchRow last) {
        return new GridH2Cursor(this.doFind(higherThan, false, last));
    }

    public GridH2AbstractKeyValueRow findOne(GridSearchRowPointer row) {
        return (GridH2AbstractKeyValueRow)this.tree.get(row);
    }

    private Iterator<GridH2Row> doFind(@Nullable SearchRow first, boolean includeFirst, @Nullable SearchRow last) {
        ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> t = this.treeForRead();
        NavigableMap<GridSearchRowPointer, GridH2Row> range = this.subTree(t, this.comparable(first, (includeFirst &= first != null) ? -1 : 1), this.comparable(last, 1));
        if (range == null) {
            return new GridEmptyIterator();
        }
        return this.filter(range.values().iterator());
    }

    private GridSearchRowPointer comparable(SearchRow row, int bias) {
        if (row == null) {
            return null;
        }
        if (bias == 0 && row instanceof GridH2Row) {
            return (GridSearchRowPointer)row;
        }
        return new ComparableRow(row, bias);
    }

    private NavigableMap<GridSearchRowPointer, GridH2Row> subTree(NavigableMap<GridSearchRowPointer, GridH2Row> map, @Nullable GridSearchRowPointer first, @Nullable GridSearchRowPointer last) {
        if (first == null) {
            if (last == null) {
                return map;
            }
            return map.headMap(last, false);
        }
        if (last == null) {
            return map.tailMap(first, false);
        }
        if (this.compare(first, last) > 0) {
            return null;
        }
        return map.subMap(first, false, last, false);
    }

    Iterator<GridH2Row> rows() {
        return this.doFind(null, false, null);
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findFirstOrLast(Session ses, boolean first) {
        ConcurrentNavigableMap<GridSearchRowPointer, GridH2Row> tree = this.treeForRead();
        GridSearchRowPointer res = null;
        Iterator<GridH2Row> iter = this.filter(first ? tree.values().iterator() : tree.descendingMap().values().iterator());
        if (iter.hasNext()) {
            GridSearchRowPointer r = iter.next();
            if (first && this.compare(r, res) < 0 || !first && this.compare(r, res) > 0) {
                res = r;
            }
        }
        return new SingleRowCursor((Row)res);
    }

    @Override
    public GridH2Row put(GridH2Row row, boolean ifAbsent) {
        return ifAbsent ? this.tree.putIfAbsent(row, row) : this.tree.put(row, row);
    }

    @Override
    public GridH2Row remove(SearchRow row) {
        return (GridH2Row)this.tree.remove(this.comparable(row, 0));
    }

    @Override
    public GridH2TreeIndex rebuild(GridUnsafeMemory memory) throws InterruptedException {
        IndexColumn[] cols = this.getIndexColumns();
        if (!this.getIndexType().isUnique()) {
            cols = Arrays.copyOf(cols, cols.length - 1);
        }
        GridH2TreeIndex idx = new GridH2TreeIndex(this.getName(), (GridH2Table)this.getTable(), this.getIndexType().isUnique(), this.keyCol, this.valCol, memory, cols);
        Thread thread = Thread.currentThread();
        long i = 0L;
        for (GridH2Row row : this.tree.values()) {
            if (++i % 1000L == 0L && thread.isInterrupted()) {
                throw new InterruptedException();
            }
            idx.tree.put(row, row);
        }
        return idx;
    }

    private class ComparableRow
    implements GridSearchRowPointer,
    Comparable<SearchRow> {
        private final SearchRow row;
        private final int bias;

        private ComparableRow(SearchRow row, int bias) {
            this.row = row;
            this.bias = bias;
        }

        @Override
        public int compareTo(SearchRow o) {
            int res = GridH2TreeIndex.this.compareRows(o, this.row);
            if (res == 0) {
                return this.bias;
            }
            return -res;
        }

        public boolean equals(Object obj) {
            throw new IllegalStateException("Should never be called.");
        }

        public int getColumnCount() {
            return this.row.getColumnCount();
        }

        public Value getValue(int idx) {
            return this.row.getValue(idx);
        }

        public void setValue(int idx, Value v) {
            this.row.setValue(idx, v);
        }

        public void setKeyAndVersion(SearchRow old) {
            this.row.setKeyAndVersion(old);
        }

        public int getVersion() {
            return this.row.getVersion();
        }

        public void setKey(long key) {
            this.row.setKey(key);
        }

        public long getKey() {
            return this.row.getKey();
        }

        public int getMemory() {
            return this.row.getMemory();
        }

        public long pointer() {
            throw new IllegalStateException();
        }

        public void incrementRefCount() {
            throw new IllegalStateException();
        }

        public void decrementRefCount() {
            throw new IllegalStateException();
        }
    }
}

