/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Cursor;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2IndexBase;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Row;
import org.h2.engine.Session;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.SingleRowCursor;
import org.h2.index.SpatialIndex;
import org.h2.message.DbException;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.result.SearchRow;
import org.h2.result.SortOrder;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueGeometry;

public class GridH2SpatialIndex
extends GridH2IndexBase
implements SpatialIndex {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile long rowCnt;
    private long rowIds;
    private boolean closed;
    private final MVRTreeMap<Long> treeMap;
    private final Map<Long, GridH2Row> idToRow = new HashMap<Long, GridH2Row>();
    private final Map<Value, Long> keyToId = new HashMap<Value, Long>();
    private final MVStore store;

    public GridH2SpatialIndex(Table tbl, String idxName, IndexColumn[] cols, int keyCol, int valCol) {
        super(keyCol, valCol);
        if (cols.length > 1) {
            throw DbException.getUnsupportedException((String)"can only do one column");
        }
        if ((cols[0].sortType & 1) != 0) {
            throw DbException.getUnsupportedException((String)"cannot do descending");
        }
        if ((cols[0].sortType & 2) != 0) {
            throw DbException.getUnsupportedException((String)"cannot do nulls first");
        }
        if ((cols[0].sortType & 4) != 0) {
            throw DbException.getUnsupportedException((String)"cannot do nulls last");
        }
        this.initBaseIndex(tbl, 0, idxName, cols, IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)true));
        this.table = tbl;
        if (cols[0].column.getType() != 22) {
            throw DbException.getUnsupportedException((String)("spatial index on non-geometry column, " + cols[0].column.getCreateSQL()));
        }
        this.store = MVStore.open(null);
        this.treeMap = (MVRTreeMap)this.store.openMap("spatialIndex", (MVMap.MapBuilder)new MVRTreeMap.Builder());
    }

    private void checkClosed() {
        if (this.closed) {
            throw DbException.throwInternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridH2Row put(GridH2Row row, boolean ifAbsent) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.checkClosed();
            Value key = row.getValue(this.keyCol);
            assert (key != null);
            Long rowId = this.keyToId.get(key);
            if (rowId != null) {
                Long oldRowId = (Long)this.treeMap.remove((Object)this.getEnvelope(this.idToRow.get(rowId), rowId));
                assert (rowId.equals(oldRowId));
            } else {
                rowId = ++this.rowIds;
                this.keyToId.put(key, rowId);
            }
            GridH2Row old = this.idToRow.put(rowId, row);
            this.treeMap.put(this.getEnvelope(row, rowId), (Object)rowId);
            if (old == null) {
                ++this.rowCnt;
            }
            GridH2Row gridH2Row = old;
            return gridH2Row;
        }
        finally {
            l.unlock();
        }
    }

    private SpatialKey getEnvelope(SearchRow row, long rowId) {
        Value v = row.getValue(this.columnIds[0]);
        Geometry g = ((ValueGeometry)v.convertTo(22)).getGeometry();
        Envelope env = g.getEnvelopeInternal();
        return new SpatialKey(rowId, new float[]{(float)env.getMinX(), (float)env.getMaxX(), (float)env.getMinY(), (float)env.getMaxY()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GridH2Row remove(SearchRow row) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.checkClosed();
            Value key = row.getValue(this.keyCol);
            assert (key != null);
            Long rowId = this.keyToId.remove(key);
            assert (rowId != null);
            GridH2Row oldRow = this.idToRow.remove(rowId);
            assert (oldRow != null);
            if (!this.treeMap.remove((Object)this.getEnvelope(row, rowId), (Object)rowId)) {
                throw DbException.throwInternalError((String)"row not found");
            }
            --this.rowCnt;
            GridH2Row gridH2Row = oldRow;
            return gridH2Row;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Session ses) {
        Lock l = this.lock.writeLock();
        l.lock();
        try {
            this.closed = true;
            this.store.close();
        }
        finally {
            l.unlock();
        }
    }

    protected long getCostRangeIndex(int[] masks, long rowCnt, TableFilter filter, SortOrder sortOrder) {
        long cost = rowCnt += 1000L;
        long rows = rowCnt;
        if (masks == null) {
            return cost;
        }
        for (Column column : this.columns) {
            int idx = column.getColumnId();
            int mask = masks[idx];
            if ((mask & 0x10) == 0) continue;
            cost = 3L + rows / 4L;
            break;
        }
        return cost;
    }

    public double getCost(Session ses, int[] masks, TableFilter filter, SortOrder sortOrder) {
        return this.getCostRangeIndex(masks, this.rowCnt, filter, sortOrder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor find(Session ses, SearchRow first, SearchRow last) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            this.checkClosed();
            GridH2Cursor gridH2Cursor = new GridH2Cursor(this.rowIterator(this.treeMap.keySet().iterator()));
            return gridH2Cursor;
        }
        finally {
            l.unlock();
        }
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    private Iterator<GridH2Row> rowIterator(Iterator<SpatialKey> i) {
        if (!i.hasNext()) {
            return Collections.emptyIterator();
        }
        ArrayList<GridH2Row> rows = new ArrayList<GridH2Row>();
        do {
            GridH2Row row = this.idToRow.get(i.next().getId());
            assert (row != null);
            rows.add(row);
        } while (i.hasNext());
        return this.filter(rows.iterator());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor findFirstOrLast(Session ses, boolean first) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            this.checkClosed();
            if (!first) {
                throw DbException.throwInternalError((String)"Spatial Index can only be fetch by ascending order");
            }
            Iterator<GridH2Row> iter = this.rowIterator(this.treeMap.keySet().iterator());
            SingleRowCursor singleRowCursor = new SingleRowCursor(iter.hasNext() ? iter.next() : null);
            return singleRowCursor;
        }
        finally {
            l.unlock();
        }
    }

    public long getRowCount(Session ses) {
        return this.rowCnt;
    }

    public long getRowCountApproximation() {
        return this.rowCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cursor findByGeometry(TableFilter filter, SearchRow intersection) {
        Lock l = this.lock.readLock();
        l.lock();
        try {
            if (intersection == null) {
                Cursor cursor = this.find(filter.getSession(), null, null);
                return cursor;
            }
            GridH2Cursor gridH2Cursor = new GridH2Cursor(this.rowIterator((Iterator<SpatialKey>)this.treeMap.findIntersectingKeys(this.getEnvelope(intersection, 0L))));
            return gridH2Cursor;
        }
        finally {
            l.unlock();
        }
    }
}

