/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import org.gridgain.grid.spi.indexing.h2.opt.GridSearchRowPointer;
import org.h2.result.Row;
import org.h2.value.Value;

public class GridH2Row
extends Row
implements GridSearchRowPointer {
    protected static final byte STATE_NEW = 0;
    protected static final byte STATE_INSERTED = 1;
    protected static final byte STATE_REJECTED = 2;
    private volatile byte state;

    public GridH2Row(Value ... data) {
        this(0, data);
    }

    public GridH2Row(byte state, Value ... data) {
        super(data, -1);
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean waitInsertComplete() {
        byte s = this.state;
        if (s == 0) {
            GridH2Row gridH2Row = this;
            synchronized (gridH2Row) {
                while ((s = this.state) == 0) {
                    s = this.refreshState();
                    if (s != 0) {
                        this.state = s;
                        break;
                    }
                    try {
                        this.wait(10L);
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        return true;
                    }
                }
            }
        }
        return s == 1;
    }

    protected byte refreshState() {
        return 0;
    }

    public synchronized byte finishInsert(boolean success) {
        assert (this.state == 0);
        byte s = success ? (byte)1 : 2;
        this.state = s;
        this.notifyAll();
        return s;
    }

    public long pointer() {
        throw new IllegalStateException();
    }

    public void incrementRefCount() {
        throw new IllegalStateException();
    }

    public void decrementRefCount() {
        throw new IllegalStateException();
    }
}

