/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.util.concurrent.locks.Lock;
import org.gridgain.grid.GridException;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2AbstractKeyValueRow;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2RowDescriptor;
import org.gridgain.grid.util.GridStripedLock;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.h2.store.Data;
import org.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class GridH2KeyValueRowOffheap
extends GridH2AbstractKeyValueRow {
    private static final GridStripedLock lock;
    private static final int OFFSET_EXPIRATION = 4;
    private static final int OFFSET_STATE = 12;
    private static final int OFFSET_VALUE_REF = 13;
    private static final int OFFSET_KEY_SIZE = 21;
    private static final int OFFSET_KEY = 25;
    private static final int OFFSET_VALUE = 4;
    private static final Data SIZE_CALCULATOR;
    private long ptr;

    public GridH2KeyValueRowOffheap(GridH2RowDescriptor desc, long ptr) {
        super(desc);
        assert (ptr > 0L) : ptr;
        this.ptr = ptr;
    }

    public GridH2KeyValueRowOffheap(GridH2RowDescriptor desc, Object key, int keyType, @Nullable Object val, int valType, long expirationTime) throws GridSpiException {
        super(desc, key, keyType, val, valType, expirationTime);
    }

    @Override
    public long expirationTime() {
        if (this.expirationTime == 0L) {
            long p = this.ptr;
            assert (p > 0L) : p;
            this.expirationTime = this.desc.memory().readLong(p + 4L);
        }
        return this.expirationTime;
    }

    @Override
    protected void cache() {
        this.desc.cache(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Value getOffheapValue(int col) {
        GridUnsafeMemory mem = this.desc.memory();
        long p = this.ptr;
        assert (p > 0L) : p;
        byte[] bytes = null;
        if (col == 0) {
            int size = mem.readInt(p + 21L);
            assert (size > 0) : size;
            bytes = mem.readBytes(p + 25L, size);
        } else if (col == 1) {
            Lock l = lock.getLock(p);
            l.lock();
            GridUnsafeMemory.Operation op = mem.begin();
            try {
                long valPtr = mem.readLongVolatile(p + 13L);
                if (valPtr == 0L) {
                    Value value = null;
                    return value;
                }
                int size = mem.readInt(valPtr);
                assert (size > 0) : size;
                bytes = mem.readBytes(valPtr + 4L, size);
            }
            finally {
                mem.end(op);
                l.unlock();
            }
        } else assert (false) : col;
        Data data = Data.create(null, bytes);
        return data.readValue();
    }

    @Override
    protected byte refreshState() {
        return this.desc.memory().readByteVolatile(this.ptr + 12L);
    }

    @Override
    public synchronized byte finishInsert(boolean success) {
        byte s = super.finishInsert(success);
        this.desc.memory().writeByteVolatile(this.ptr + 12L, s);
        return s;
    }

    @Override
    public long pointer() {
        long p = this.ptr;
        assert (p > 0L) : p;
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onSwap() throws GridException {
        Lock l = lock.getLock(this.ptr);
        l.lock();
        try {
            final long p = this.ptr + 13L;
            final GridUnsafeMemory mem = this.desc.memory();
            final long valPtr = mem.readLongVolatile(p);
            assert (valPtr > 0L) : valPtr;
            mem.finalizeLater(new Runnable(){

                @Override
                public void run() {
                    mem.casLong(p, valPtr, 0L);
                    mem.release(valPtr, (long)(mem.readInt(valPtr) + 4));
                }
            });
        }
        finally {
            l.unlock();
        }
    }

    @Override
    protected Value updateWeakValue(Value exp, Value upd) {
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onUnswap(Object val) throws GridException {
        super.onUnswap(val);
        Value v = this.getValue(1);
        byte[] bytes = new byte[SIZE_CALCULATOR.getValueLen(v)];
        Data data = Data.create(null, (byte[])bytes);
        data.writeValue(v);
        long p = this.ptr;
        assert (p > 0L) : p;
        Lock l = lock.getLock(p);
        l.lock();
        try {
            GridUnsafeMemory mem = this.desc.memory();
            long valPtr = mem.allocate((long)(bytes.length + 4));
            mem.writeInt(valPtr, bytes.length);
            mem.writeBytes(valPtr + 4L, bytes);
            mem.writeLongVolatile(p + 13L, valPtr);
        }
        finally {
            l.unlock();
        }
    }

    @Override
    protected synchronized Value syncValue() {
        Value v = super.syncValue();
        if (v != null) {
            return v;
        }
        return this.getOffheapValue(1);
    }

    @Override
    public void incrementRefCount() {
        long p = this.ptr;
        GridUnsafeMemory mem = this.desc.memory();
        if (p == 0L) {
            Value key = this.getValue(0);
            Value val = this.getValue(1);
            assert (key != null);
            assert (val != null);
            Data data = Data.create(null, (byte[])new byte[SIZE_CALCULATOR.getValueLen(key)]);
            data.writeValue(key);
            int keySize = data.length();
            p = mem.allocate((long)(keySize + 25));
            mem.writeInt(p, 1);
            mem.writeLong(p + 4L, this.expirationTime);
            mem.writeByte(p + 12L, (byte)0);
            mem.writeInt(p + 21L, keySize);
            mem.writeBytes(p + 25L, data.getBytes(), 0, keySize);
            data = Data.create(null, (byte[])new byte[SIZE_CALCULATOR.getValueLen(val)]);
            data.writeValue(val);
            int valSize = data.length();
            long valPtr = mem.allocate((long)(valSize + 4));
            mem.writeInt(valPtr, valSize);
            mem.writeBytes(valPtr + 4L, data.getBytes(), 0, valSize);
            mem.writeLongVolatile(p + 13L, valPtr);
            this.ptr = p;
            this.desc.cache(this);
        } else {
            int cnt;
            do {
                cnt = mem.readIntVolatile(p);
                assert (cnt > 0) : cnt;
            } while (!mem.casInt(p, cnt, cnt + 1));
        }
    }

    @Override
    public void decrementRefCount() {
        GridUnsafeMemory mem;
        long p;
        block4: {
            int cnt;
            p = this.ptr;
            assert (p > 0L) : p;
            mem = this.desc.memory();
            do {
                cnt = mem.readIntVolatile(p);
                assert (cnt > 0) : cnt;
                if (cnt == 1) break block4;
            } while (!mem.casInt(p, cnt, cnt - 1));
            return;
        }
        this.desc.uncache(p);
        long valPtr = mem.readLongVolatile(p + 13L);
        if (valPtr > 0L) {
            mem.release(valPtr, (long)(mem.readInt(valPtr) + 4));
        }
        mem.release(p, (long)(mem.readInt(p + 21L) + 25));
    }

    static {
        int cpus = Runtime.getRuntime().availableProcessors();
        lock = new GridStripedLock(cpus * cpus * 8);
        SIZE_CALCULATOR = Data.create(null, null);
    }
}

