/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.util.Iterator;
import org.gridgain.grid.spi.indexing.GridIndexingQueryFilter;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2AbstractKeyValueRow;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Row;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Table;
import org.gridgain.grid.util.lang.GridFilteredIterator;
import org.gridgain.grid.util.offheap.unsafe.GridUnsafeMemory;
import org.gridgain.grid.util.typedef.F;
import org.gridgain.grid.util.typedef.internal.U;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2IndexBase
extends BaseIndex {
    protected static final ThreadLocal<GridIndexingQueryFilter<?, ?>[]> filters = new ThreadLocal();
    protected final int keyCol;
    protected final int valCol;

    public GridH2IndexBase(int keyCol, int valCol) {
        this.keyCol = keyCol;
        this.valCol = valCol;
    }

    public static void setFiltersForThread(GridIndexingQueryFilter<?, ?>[] fs) {
        filters.set(fs);
    }

    public GridH2IndexBase rebuild(GridUnsafeMemory memory) throws InterruptedException {
        return this;
    }

    public abstract GridH2Row put(GridH2Row var1, boolean var2);

    public abstract GridH2Row remove(SearchRow var1);

    public Object takeSnapshot(@Nullable Object s) {
        return s;
    }

    public void releaseSnapshot() {
    }

    protected Iterator<GridH2Row> filter(Iterator<GridH2Row> iter) {
        return new FilteringIterator(iter, U.currentTimeMillis());
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public void remove(Session ses) {
        throw DbException.getUnsupportedException((String)"remove index");
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean needRebuild() {
        return false;
    }

    protected class FilteringIterator
    extends GridFilteredIterator<GridH2Row> {
        private final GridIndexingQueryFilter<?, ?>[] fs;
        private final long time;

        protected FilteringIterator(Iterator<GridH2Row> iter, long time) {
            super(iter);
            this.fs = filters.get();
            this.time = time;
        }

        protected boolean accept(GridH2Row row) {
            if (row instanceof GridH2AbstractKeyValueRow && ((GridH2AbstractKeyValueRow)row).expirationTime() <= this.time) {
                return false;
            }
            if (F.isEmpty((Object[])this.fs)) {
                return true;
            }
            String spaceName = ((GridH2Table)GridH2IndexBase.this.getTable()).spaceName();
            Object key = row.getValue(GridH2IndexBase.this.keyCol).getObject();
            Object val = row.getValue(GridH2IndexBase.this.valCol).getObject();
            assert (key != null);
            assert (val != null);
            for (GridIndexingQueryFilter<?, ?> f : this.fs) {
                if (f == null || f.apply(spaceName, key, val)) continue;
                return false;
            }
            return true;
        }
    }
}

