/*
 * Decompiled with CFR 0.152.
 */
package org.gridgain.grid.spi.indexing.h2.opt;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.UUID;
import org.gridgain.grid.GridException;
import org.gridgain.grid.GridRuntimeException;
import org.gridgain.grid.spi.GridSpiException;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2Row;
import org.gridgain.grid.spi.indexing.h2.opt.GridH2RowDescriptor;
import org.gridgain.grid.util.typedef.internal.SB;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueByte;
import org.h2.value.ValueBytes;
import org.h2.value.ValueDate;
import org.h2.value.ValueDecimal;
import org.h2.value.ValueDouble;
import org.h2.value.ValueFloat;
import org.h2.value.ValueGeometry;
import org.h2.value.ValueInt;
import org.h2.value.ValueJavaObject;
import org.h2.value.ValueLong;
import org.h2.value.ValueNull;
import org.h2.value.ValueShort;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;
import org.h2.value.ValueUuid;
import org.jetbrains.annotations.Nullable;

public abstract class GridH2AbstractKeyValueRow
extends GridH2Row {
    private static final int DEFAULT_COLUMNS_COUNT = 3;
    public static final int KEY_COL = 0;
    public static final int VAL_COL = 1;
    public static final int VAL_STR_IDX = 2;
    protected final GridH2RowDescriptor desc;
    protected long expirationTime;

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc, Object key, int keyType, @Nullable Object val, int valType, long expirationTime) throws GridSpiException {
        super(GridH2AbstractKeyValueRow.wrap(key, keyType), val == null ? null : GridH2AbstractKeyValueRow.wrap(val, valType));
        this.desc = desc;
        this.expirationTime = expirationTime;
    }

    protected GridH2AbstractKeyValueRow(GridH2RowDescriptor desc) {
        super((byte)1, new Value[3]);
        this.desc = desc;
    }

    private static Value wrap(Object obj, int type) throws GridSpiException {
        switch (type) {
            case 1: {
                return ValueBoolean.get((boolean)((Boolean)obj));
            }
            case 2: {
                return ValueByte.get((byte)((Byte)obj));
            }
            case 3: {
                return ValueShort.get((short)((Short)obj));
            }
            case 4: {
                return ValueInt.get((int)((Integer)obj));
            }
            case 8: {
                return ValueFloat.get((float)((Float)obj).floatValue());
            }
            case 5: {
                return ValueLong.get((long)((Long)obj));
            }
            case 7: {
                return ValueDouble.get((double)((Double)obj));
            }
            case 20: {
                UUID uuid = (UUID)obj;
                return ValueUuid.get((long)uuid.getMostSignificantBits(), (long)uuid.getLeastSignificantBits());
            }
            case 10: {
                return ValueDate.get((Date)((Date)obj));
            }
            case 9: {
                return ValueTime.get((Time)((Time)obj));
            }
            case 11: {
                if (obj instanceof java.util.Date) {
                    obj = new Timestamp(((java.util.Date)obj).getTime());
                }
                return ValueTimestamp.get((Timestamp)((Timestamp)obj));
            }
            case 6: {
                return ValueDecimal.get((BigDecimal)((BigDecimal)obj));
            }
            case 13: {
                return ValueString.get((String)obj.toString());
            }
            case 12: {
                return ValueBytes.get((byte[])((byte[])obj));
            }
            case 19: {
                return ValueJavaObject.getNoCopy((Object)obj, null, null);
            }
            case 17: {
                Object[] arr = (Object[])obj;
                Value[] valArr = new Value[arr.length];
                for (int i = 0; i < arr.length; ++i) {
                    Object o = arr[i];
                    valArr[i] = o == null ? ValueNull.INSTANCE : GridH2AbstractKeyValueRow.wrap(o, DataType.getTypeFromClass(o.getClass()));
                }
                return ValueArray.get((Value[])valArr);
            }
            case 22: {
                return ValueGeometry.getFromGeometry((Object)obj);
            }
        }
        throw new GridSpiException("Failed to wrap value[type=" + type + ", value=" + obj + "]");
    }

    public long expirationTime() {
        return this.expirationTime;
    }

    public int getColumnCount() {
        return 3 + this.desc.fieldsCount();
    }

    public synchronized void onSwap() throws GridException {
        this.setValue(1, null);
    }

    public synchronized void onUnswap(Object val) throws GridException {
        this.setValue(1, GridH2AbstractKeyValueRow.wrap(val, this.desc.valueType()));
    }

    protected synchronized Value updateWeakValue(Value exp, Value upd) {
        Value res = super.getValue(1);
        if (res != exp && !(res instanceof WeakValue)) {
            return res;
        }
        this.setValue(1, new WeakValue(upd));
        return exp;
    }

    protected synchronized Value syncValue() {
        return super.getValue(1);
    }

    public Value getValue(int col) {
        if (col < 3) {
            if (col == 2) {
                Value v = this.getValue(1);
                if (v.getType() == 13) {
                    return v;
                }
                return ValueString.get((String)v.getString());
            }
            Value v = super.getValue(col);
            if (col == 1) {
                while ((v = WeakValue.unwrap(v)) == null) {
                    v = this.getOffheapValue(1);
                    if (v != null) {
                        this.setValue(1, v);
                        if (super.getValue(0) == null) {
                            this.cache();
                        }
                        return v;
                    }
                    try {
                        Object valObj = this.desc.readFromSwap(this.getValue(0).getObject());
                        if (valObj != null) {
                            Value upd = GridH2AbstractKeyValueRow.wrap(valObj, this.desc.valueType());
                            Value res = this.updateWeakValue(v, upd);
                            if (res == v) {
                                if (super.getValue(0) == null) {
                                    this.cache();
                                }
                                return upd;
                            }
                            v = res;
                            continue;
                        }
                        v = this.syncValue();
                    }
                    catch (GridException e) {
                        throw new GridRuntimeException((Throwable)e);
                    }
                }
            }
            if (v == null) {
                assert (col == 0) : col;
                v = this.getOffheapValue(0);
                assert (v != null) : v;
                this.setValue(0, v);
                if (super.getValue(1) == null) {
                    this.cache();
                }
            }
            assert (!(v instanceof WeakValue)) : v;
            return v;
        }
        assert ((col -= 3) >= 0);
        Value v = this.getValue(this.desc.isKeyColumn(col) ? 0 : 1);
        if (v == null) {
            return null;
        }
        Object obj = v.getObject();
        Object res = this.desc.columnValue(obj, col);
        if (res == null) {
            return ValueNull.INSTANCE;
        }
        try {
            return GridH2AbstractKeyValueRow.wrap(res, this.desc.fieldType(col));
        }
        catch (GridSpiException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    protected abstract void cache();

    protected abstract Value getOffheapValue(int var1);

    public String toString() {
        SB sb = new SB("Row@");
        sb.a(Integer.toHexString(System.identityHashCode(this)));
        Value v = super.getValue(0);
        sb.a("[ key: ").a(v == null ? "nil" : v.getString());
        v = WeakValue.unwrap(super.getValue(1));
        sb.a(", val: ").a(v == null ? "nil" : v.getString());
        sb.a(" ][ ");
        if (v != null) {
            int cnt = this.getColumnCount();
            for (int i = 2; i < cnt; ++i) {
                v = this.getValue(i);
                if (i != 2) {
                    sb.a(", ");
                }
                sb.a(v == null ? "nil" : v.getString());
            }
        }
        sb.a(" ]");
        return sb.toString();
    }

    public void setKeyAndVersion(SearchRow old) {
        assert (false);
    }

    public void setKey(long key) {
        assert (false);
    }

    public Row getCopy() {
        assert (false);
        return null;
    }

    public void setDeleted(boolean deleted) {
        assert (false);
    }

    public long getKey() {
        assert (false);
        return 0L;
    }

    public void setSessionId(int sesId) {
        assert (false);
    }

    public void setVersion(int ver) {
        assert (false);
    }

    private static class WeakValue
    extends Value {
        private final WeakReference<Value> ref;

        static Value unwrap(Value v) {
            return v instanceof WeakValue ? ((WeakValue)v).get() : v;
        }

        private WeakValue(Value v) {
            this.ref = new WeakReference<Value>(v);
        }

        public Value get() {
            return (Value)this.ref.get();
        }

        public String getSQL() {
            throw new IllegalStateException();
        }

        public int getType() {
            throw new IllegalStateException();
        }

        public long getPrecision() {
            throw new IllegalStateException();
        }

        public int getDisplaySize() {
            throw new IllegalStateException();
        }

        public String getString() {
            throw new IllegalStateException();
        }

        public Object getObject() {
            throw new IllegalStateException();
        }

        public void set(PreparedStatement preparedStatement, int i) throws SQLException {
            throw new IllegalStateException();
        }

        protected int compareSecure(Value val, CompareMode compareMode) {
            throw new IllegalStateException();
        }

        public int hashCode() {
            throw new IllegalStateException();
        }

        public boolean equals(Object o) {
            throw new IllegalStateException();
        }
    }
}

